/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.rdf.mediatypes;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.activation.MimeTypeParseException;
import org.wymiwyg.commons.mediatypes.MimeType;
import org.wymiwyg.commons.vocabulary.MEDIATYPES;

public class MediaTypesUtil {
    private static MediaTypesUtil defaultInstance;
    private Map extensionCanonicalMimeMap = new HashMap();
    private Map mimeCanonicalExtensionMap = new HashMap();
    private Map mimeCanonicalMimeMap = new HashMap();

    public MediaTypesUtil() throws MimeTypeParseException {
        Model model = ModelFactory.createDefaultModel();
        model.read(this.getClass().getResource("mimetypes.rdf").toString());
        this.load(model);
    }

    public MediaTypesUtil(Model model) throws MimeTypeParseException {
        this.load(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaTypesUtil getDefaultInstance() {
        if (defaultInstance != null) return defaultInstance;
        Class<MediaTypesUtil> clazz = MediaTypesUtil.class;
        synchronized (MediaTypesUtil.class) {
            if (defaultInstance != null) return defaultInstance;
            try {
                defaultInstance = new MediaTypesUtil();
            }
            catch (MimeTypeParseException e) {
                throw new RuntimeException(e);
            }
            return defaultInstance;
        }
    }

    public static void setDefaultInstance(MediaTypesUtil defaultInstance) {
        MediaTypesUtil.defaultInstance = defaultInstance;
    }

    private void load(Model model) throws MimeTypeParseException {
        ResIterator typesResIter = model.listSubjectsWithProperty(RDF.type, (RDFNode)MEDIATYPES.Type);
        while (typesResIter.hasNext()) {
            Resource type = typesResIter.nextResource();
            this.processType(type);
        }
        typesResIter.close();
    }

    private void processType(Resource type) throws MimeTypeParseException {
        String canonicalExtension;
        String canonicalMimeTypeString = type.getRequiredProperty(MEDIATYPES.canonicalMimeType).getString();
        HashSet<String> otherMimeTypeStrings = new HashSet<String>();
        StmtIterator mimeTypes = type.listProperties(MEDIATYPES.mimeType);
        while (mimeTypes.hasNext()) {
            otherMimeTypeStrings.add(mimeTypes.nextStatement().getString());
        }
        mimeTypes.close();
        otherMimeTypeStrings.add(canonicalMimeTypeString);
        MimeType canonicalMimeType = new MimeType(canonicalMimeTypeString);
        if (type.hasProperty(MEDIATYPES.canonicalFileExtension)) {
            canonicalExtension = type.getProperty(MEDIATYPES.canonicalFileExtension).getString();
        } else {
            if (type.hasProperty(MEDIATYPES.fileExtension)) {
                throw new RuntimeException("no file extension for type " + canonicalMimeTypeString + " marked as canonicacl");
            }
            canonicalExtension = null;
        }
        for (String currentMimeTypeString : otherMimeTypeStrings) {
            MimeType currentMimeType = new MimeType(currentMimeTypeString);
            this.mimeCanonicalMimeMap.put(currentMimeType, canonicalMimeType);
            if (canonicalExtension == null) continue;
            this.mimeCanonicalExtensionMap.put(currentMimeType, canonicalExtension);
        }
        if (canonicalExtension != null) {
            HashSet<String> allExtensions = new HashSet<String>();
            StmtIterator otherExtensionsIter = type.listProperties(MEDIATYPES.fileExtension);
            while (otherExtensionsIter.hasNext()) {
                allExtensions.add(otherExtensionsIter.nextStatement().getString());
            }
            otherExtensionsIter.close();
            allExtensions.add(canonicalExtension);
            for (String currentExtension : allExtensions) {
                this.extensionCanonicalMimeMap.put(currentExtension, canonicalMimeType);
            }
        }
    }

    public MimeType getTypeForExtension(String extension) {
        return (MimeType)this.extensionCanonicalMimeMap.get(extension);
    }

    public String getExtensionForType(MimeType type) {
        return (String)this.mimeCanonicalExtensionMap.get(type);
    }

    public MimeType getCanonicalType(MimeType type) {
        return (MimeType)this.mimeCanonicalMimeMap.get(type);
    }
}

