/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.rdf.mediatypes;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.wymiwyg.commons.vocabulary.MEDIATYPES;

public class MimeTypeParser {
    public static void main(String[] args) throws IOException {
        String filename = args.length != 1 ? MimeTypeParser.class.getResource("mime.types").getFile() : args[0];
        FileReader in = new FileReader(filename);
        BufferedReader reader = new BufferedReader(in);
        Model model = ModelFactory.createDefaultModel();
        String line = reader.readLine();
        while (line != null) {
            if (line.length() != 0 && line.charAt(0) != '#') {
                StringTokenizer tokens = new StringTokenizer(line);
                String mimeTypeString = tokens.nextToken();
                if (tokens.hasMoreTokens()) {
                    Resource typeRes = model.createResource(MEDIATYPES.Type);
                    typeRes.addProperty(MEDIATYPES.canonicalMimeType, mimeTypeString);
                    typeRes.addProperty(MEDIATYPES.canonicalFileExtension, tokens.nextToken());
                    while (tokens.hasMoreTokens()) {
                        String extension = tokens.nextToken();
                        typeRes.addProperty(MEDIATYPES.fileExtension, extension);
                    }
                }
            }
            line = reader.readLine();
        }
        model.write((OutputStream)System.out);
    }
}

