/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.tsmodel;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wymiwyg.commons.tsmodel.CachingNodeIterator;
import org.wymiwyg.commons.tsmodel.CachingRSIterator;
import org.wymiwyg.commons.tsmodel.CachingResIterator;
import org.wymiwyg.commons.tsmodel.CachingStmtIterator;
import org.wymiwyg.commons.tsmodel.ThreadSafeAlt;
import org.wymiwyg.commons.tsmodel.ThreadSafeBag;
import org.wymiwyg.commons.tsmodel.ThreadSafeProperty;
import org.wymiwyg.commons.tsmodel.ThreadSafeReifiedStatement;
import org.wymiwyg.commons.tsmodel.ThreadSafeResource;
import org.wymiwyg.commons.tsmodel.ThreadSafeSeq;
import org.wymiwyg.commons.tsmodel.ThreadSafeStatement;

public class ThreadSafeModel
extends ModelCom
implements Model {
    Model wrapped;

    public ThreadSafeModel(Model wrapped) {
        super(wrapped.getGraph());
        this.wrapped = wrapped;
    }

    public Model abort() {
        this.wrapped.abort();
        return this;
    }

    public synchronized Model add(List statements) {
        this.wrapped.add(statements);
        return this;
    }

    public synchronized Model add(Model m) {
        this.wrapped.add(m);
        return this;
    }

    public synchronized Model add(Model m, boolean suppressReifications) {
        this.wrapped.add(m, suppressReifications);
        return this;
    }

    public synchronized Model add(Resource s, Property p, RDFNode o) {
        this.wrapped.add(s, p, o);
        return this;
    }

    public synchronized Model add(Resource s, Property p, String o) {
        this.wrapped.add(s, p, o);
        return this;
    }

    public synchronized Model add(Resource s, Property p, String o, boolean wellFormed) {
        this.wrapped.add(s, p, o, wellFormed);
        return this;
    }

    public synchronized Model add(Resource s, Property p, String o, String l) {
        this.wrapped.add(s, p, o, l);
        return this;
    }

    public synchronized Model add(Resource s, Property p, String o, String l, boolean wellFormed) {
        this.wrapped.add(s, p, o, l, wellFormed);
        return this;
    }

    public synchronized Model add(Statement s) {
        this.wrapped.add(s);
        return this;
    }

    public synchronized Model add(Statement[] statements) {
        this.wrapped.add(statements);
        return this;
    }

    public synchronized Model add(StmtIterator iter) {
        this.wrapped.add(iter);
        return this;
    }

    public synchronized Model begin() {
        this.wrapped.begin();
        return this;
    }

    public synchronized void close() {
        this.wrapped.close();
    }

    public Model commit() {
        this.wrapped.commit();
        return this;
    }

    public synchronized boolean contains(Resource s, Property p) {
        return this.wrapped.contains(s, p);
    }

    public synchronized boolean contains(Resource s, Property p, RDFNode o) {
        return this.wrapped.contains(s, p, o);
    }

    public synchronized boolean contains(Resource s, Property p, String o) {
        return this.wrapped.contains(s, p, o);
    }

    public synchronized boolean contains(Resource s, Property p, String o, String l) {
        return this.wrapped.contains(s, p, o, l);
    }

    public synchronized boolean contains(Statement s) {
        return this.wrapped.contains(s);
    }

    public synchronized boolean containsAll(Model model) {
        return this.wrapped.containsAll(model);
    }

    public synchronized boolean containsAll(StmtIterator iter) {
        return this.wrapped.containsAll(iter);
    }

    public synchronized boolean containsAny(Model model) {
        return this.wrapped.containsAny(model);
    }

    public synchronized boolean containsAny(StmtIterator iter) {
        return this.wrapped.containsAny(iter);
    }

    public synchronized boolean containsResource(RDFNode r) {
        return this.wrapped.containsResource(r);
    }

    public Alt createAlt() {
        return new ThreadSafeAlt(this, this.wrapped.createAlt());
    }

    public Alt createAlt(String uri) {
        return new ThreadSafeAlt(this, this.wrapped.createAlt(uri));
    }

    public Bag createBag() {
        return new ThreadSafeBag(this, (Container)this.wrapped.createBag());
    }

    public Bag createBag(String uri) {
        return new ThreadSafeBag(this, (Container)this.wrapped.createBag(uri));
    }

    public RDFList createList() {
        return this.wrapped.createList();
    }

    public synchronized RDFList createList(Iterator members) {
        return this.wrapped.createList(members);
    }

    public synchronized RDFList createList(RDFNode[] members) {
        return this.wrapped.createList(members);
    }

    public Literal createLiteral(String v) {
        return this.wrapped.createLiteral(v);
    }

    public Literal createLiteral(String v, boolean wellFormed) {
        return this.wrapped.createLiteral(v, wellFormed);
    }

    public Literal createLiteral(String v, String language) {
        return this.wrapped.createLiteral(v, language);
    }

    public Property createProperty(String uri) {
        return new ThreadSafeProperty(this, this.wrapped.createProperty(uri));
    }

    public Property createProperty(String nameSpace, String localName) {
        return new ThreadSafeProperty(this, this.wrapped.createProperty(nameSpace, localName));
    }

    public ReifiedStatement createReifiedStatement(Statement s) {
        return new ThreadSafeReifiedStatement(this, this.wrapped.createReifiedStatement(s));
    }

    public ReifiedStatement createReifiedStatement(String uri, Statement s) {
        return new ThreadSafeReifiedStatement(this, this.wrapped.createReifiedStatement(uri, s));
    }

    public Resource createResource() {
        return new ThreadSafeResource(this, this.wrapped.createResource());
    }

    public Resource createResource(AnonId id) {
        return new ThreadSafeResource(this, this.wrapped.createResource(id));
    }

    public Resource createResource(Resource type) {
        return new ThreadSafeResource(this, this.wrapped.createResource(type));
    }

    public Resource createResource(ResourceF f) {
        return new ThreadSafeResource(this, this.wrapped.createResource(f));
    }

    public Resource createResource(String uri) {
        return new ThreadSafeResource(this, this.wrapped.createResource(uri));
    }

    public Resource createResource(String uri, Resource type) {
        return new ThreadSafeResource(this, this.wrapped.createResource(uri, type));
    }

    public Resource createResource(String uri, ResourceF f) {
        return new ThreadSafeResource(this, this.wrapped.createResource(uri, f));
    }

    public Seq createSeq() {
        return new ThreadSafeSeq(this, this.wrapped.createSeq());
    }

    public synchronized Seq createSeq(String uri) {
        return new ThreadSafeSeq(this, this.wrapped.createSeq(uri));
    }

    public Statement createStatement(Resource s, Property p, RDFNode o) {
        return new ThreadSafeStatement(this, this.wrapped.createStatement(s, p, o));
    }

    public Statement createStatement(Resource s, Property p, String o) {
        return new ThreadSafeStatement(this, this.wrapped.createStatement(s, p, o));
    }

    public Statement createStatement(Resource s, Property p, String o, boolean wellFormed) {
        return new ThreadSafeStatement(this, this.wrapped.createStatement(s, p, o, wellFormed));
    }

    public Statement createStatement(Resource s, Property p, String o, String l) {
        return new ThreadSafeStatement(this, this.wrapped.createStatement(s, p, o, l));
    }

    public Statement createStatement(Resource s, Property p, String o, String l, boolean wellFormed) {
        return new ThreadSafeStatement(this, this.wrapped.createStatement(s, p, o, l, wellFormed));
    }

    public Literal createTypedLiteral(boolean v) {
        return this.wrapped.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(char v) {
        return this.wrapped.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(double v) {
        return this.wrapped.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(float v) {
        return this.wrapped.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(int v) {
        return this.wrapped.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(long v) {
        return this.wrapped.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(Object value) {
        return this.wrapped.createTypedLiteral(value);
    }

    public Literal createTypedLiteral(Object value, RDFDatatype dtype) {
        return this.wrapped.createTypedLiteral(value, dtype);
    }

    public Literal createTypedLiteral(Object value, String typeURI) {
        return this.wrapped.createTypedLiteral(value, typeURI);
    }

    public Literal createTypedLiteral(String v) {
        return this.wrapped.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(String lex, RDFDatatype dtype) {
        return this.wrapped.createTypedLiteral(lex, dtype);
    }

    public Literal createTypedLiteral(String lex, String typeURI) {
        return this.wrapped.createTypedLiteral(lex, typeURI);
    }

    public synchronized Model difference(Model model) {
        return new ThreadSafeModel(this.wrapped.difference(model));
    }

    public void enterCriticalSection(boolean readLockRequested) {
    }

    public synchronized Object executeInTransaction(Command cmd) {
        return this.wrapped.executeInTransaction(cmd);
    }

    public synchronized String expandPrefix(String prefixed) {
        return this.wrapped.expandPrefix(prefixed);
    }

    public Alt getAlt(Resource r) {
        return new ThreadSafeAlt(this, this.wrapped.getAlt(r));
    }

    public Alt getAlt(String uri) {
        return new ThreadSafeAlt(this, this.wrapped.getAlt(uri));
    }

    public synchronized Resource getAnyReifiedStatement(Statement s) {
        Resource wrappedResult = this.wrapped.getAnyReifiedStatement(s);
        if (wrappedResult instanceof ReifiedStatement) {
            return new ThreadSafeReifiedStatement(this, (ReifiedStatement)wrappedResult);
        }
        return new ThreadSafeResource(this, wrappedResult);
    }

    public Bag getBag(Resource r) {
        return new ThreadSafeBag(this, (Container)this.wrapped.getBag(r));
    }

    public Bag getBag(String uri) {
        return new ThreadSafeBag(this, (Container)this.wrapped.getBag(uri));
    }

    public synchronized Graph getGraph() {
        if (this.wrapped == null) {
            return super.getGraph();
        }
        return this.wrapped.getGraph();
    }

    public Map getNsPrefixMap() {
        if (this.wrapped == null) {
            return super.getNsPrefixMap();
        }
        return this.wrapped.getNsPrefixMap();
    }

    public synchronized String getNsPrefixURI(String prefix) {
        return this.wrapped.getNsPrefixURI(prefix);
    }

    public synchronized String getNsURIPrefix(String uri) {
        return this.wrapped.getNsURIPrefix(uri);
    }

    public synchronized Statement getProperty(Resource s, Property p) {
        return new ThreadSafeStatement(this, this.wrapped.getProperty(s, p));
    }

    public synchronized Property getProperty(String uri) {
        return new ThreadSafeProperty(this, this.wrapped.getProperty(uri));
    }

    public synchronized Property getProperty(String nameSpace, String localName) {
        return new ThreadSafeProperty(this, this.wrapped.getProperty(nameSpace, localName));
    }

    public synchronized RDFNode getRDFNode(Node n) {
        RDFNode wrappedResult = this.wrapped.getRDFNode(n);
        if (wrappedResult instanceof Resource) {
            return new ThreadSafeResource(this, (Resource)wrappedResult);
        }
        return wrappedResult;
    }

    public synchronized RDFReader getReader() {
        return this.wrapped.getReader();
    }

    public synchronized RDFReader getReader(String lang) {
        return this.wrapped.getReader(lang);
    }

    public synchronized Statement getRequiredProperty(Resource s, Property p) {
        return new ThreadSafeStatement(this, this.wrapped.getRequiredProperty(s, p));
    }

    public Resource getResource(String uri) {
        return new ThreadSafeResource(this, this.wrapped.getResource(uri));
    }

    public Resource getResource(String uri, ResourceF f) {
        return new ThreadSafeResource(this, this.wrapped.getResource(uri, f));
    }

    public Seq getSeq(Resource r) {
        return new ThreadSafeSeq(this, this.wrapped.getSeq(r));
    }

    public Seq getSeq(String uri) {
        return new ThreadSafeSeq(this, this.getSeq(uri));
    }

    public RDFWriter getWriter() {
        return this.wrapped.getWriter();
    }

    public RDFWriter getWriter(String lang) {
        return this.wrapped.getWriter(lang);
    }

    public boolean independent() {
        return this.wrapped.independent();
    }

    public synchronized Model intersection(Model model) {
        return new ThreadSafeModel(this.wrapped.intersection(model));
    }

    public synchronized boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public synchronized boolean isIsomorphicWith(Model g) {
        return this.wrapped.isIsomorphicWith(g);
    }

    public synchronized boolean isReified(Statement s) {
        return this.wrapped.isReified(s);
    }

    public void leaveCriticalSection() {
    }

    public synchronized NsIterator listNameSpaces() {
        return this.wrapped.listNameSpaces();
    }

    public synchronized NodeIterator listObjects() {
        return new CachingNodeIterator(this.wrapped.listObjects());
    }

    public synchronized NodeIterator listObjectsOfProperty(Property p) {
        return new CachingNodeIterator(this.wrapped.listObjectsOfProperty(p));
    }

    public synchronized NodeIterator listObjectsOfProperty(Resource s, Property p) {
        return new CachingNodeIterator(this.wrapped.listObjectsOfProperty(s, p));
    }

    public synchronized RSIterator listReifiedStatements() {
        return new CachingRSIterator(this, this.wrapped.listReifiedStatements());
    }

    public synchronized RSIterator listReifiedStatements(Statement st) {
        return new CachingRSIterator(this, this.wrapped.listReifiedStatements(st));
    }

    public synchronized StmtIterator listStatements() {
        return new CachingStmtIterator(this, this.wrapped.listStatements());
    }

    public synchronized StmtIterator listStatements(Resource s, Property p, RDFNode o) {
        return new CachingStmtIterator(this, this.wrapped.listStatements(s, p, o));
    }

    public synchronized StmtIterator listStatements(Resource subject, Property predicate, String object) {
        return new CachingStmtIterator(this, this.wrapped.listStatements(subject, predicate, object));
    }

    public synchronized StmtIterator listStatements(Resource subject, Property predicate, String object, String lang) {
        return new CachingStmtIterator(this, this.wrapped.listStatements(subject, predicate, object, lang));
    }

    public synchronized StmtIterator listStatements(Selector s) {
        return new CachingStmtIterator(this, this.wrapped.listStatements(s));
    }

    public synchronized ResIterator listSubjects() {
        return new CachingResIterator(this, this.wrapped.listSubjects());
    }

    public synchronized ResIterator listSubjectsWithProperty(Property p) {
        return new CachingResIterator(this, this.wrapped.listSubjectsWithProperty(p));
    }

    public synchronized ResIterator listSubjectsWithProperty(Property p, RDFNode o) {
        return new CachingResIterator(this, this.wrapped.listSubjectsWithProperty(p, o));
    }

    public synchronized ResIterator listSubjectsWithProperty(Property p, String o) {
        return new CachingResIterator(this, this.wrapped.listSubjectsWithProperty(p, o));
    }

    public synchronized ResIterator listSubjectsWithProperty(Property p, String o, String l) {
        return new CachingResIterator(this, this.wrapped.listSubjectsWithProperty(p, o, l));
    }

    public synchronized PrefixMapping lock() {
        return this.wrapped.lock();
    }

    public synchronized Model query(Selector s) {
        return new ThreadSafeModel(this.wrapped.query(s));
    }

    public synchronized QueryHandler queryHandler() {
        return this.wrapped.queryHandler();
    }

    public synchronized Model read(InputStream in, String base) {
        return this.wrapped.read(in, base);
    }

    public synchronized Model read(InputStream in, String base, String lang) {
        return this.wrapped.read(in, base, lang);
    }

    public synchronized Model read(Reader reader, String base) {
        return this.wrapped.read(reader, base);
    }

    public synchronized Model read(Reader reader, String base, String lang) {
        return this.wrapped.read(reader, base, lang);
    }

    public synchronized Model read(String url) {
        return this.wrapped.read(url);
    }

    public synchronized Model read(String url, String lang) {
        return this.wrapped.read(url, lang);
    }

    public synchronized Model register(ModelChangedListener listener) {
        return this.wrapped.register(listener);
    }

    public synchronized Model remove(List statements) {
        return this.wrapped.remove(statements);
    }

    public synchronized Model remove(Model m) {
        return this.wrapped.remove(m);
    }

    public synchronized Model remove(Model m, boolean suppressReifications) {
        return this.wrapped.remove(m, suppressReifications);
    }

    public synchronized Model remove(Statement s) {
        return this.wrapped.remove(s);
    }

    public synchronized Model remove(Statement[] statements) {
        return this.wrapped.remove(statements);
    }

    public synchronized Model remove(StmtIterator iter) {
        return this.wrapped.remove(iter);
    }

    public synchronized void removeAllReifications(Statement s) {
        this.wrapped.removeAllReifications(s);
    }

    public synchronized void removeReification(ReifiedStatement rs) {
        this.wrapped.removeReification(rs);
    }

    public synchronized PrefixMapping setNsPrefix(String prefix, String uri) {
        return this.wrapped.setNsPrefix(prefix, uri);
    }

    public synchronized PrefixMapping setNsPrefixes(Map map) {
        if (this.wrapped == null) {
            return super.setNsPrefixes(map);
        }
        return this.wrapped.setNsPrefixes(map);
    }

    public synchronized PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.wrapped.setNsPrefixes(other);
    }

    public synchronized String setReaderClassName(String lang, String className) {
        return this.wrapped.setReaderClassName(lang, className);
    }

    public synchronized String setWriterClassName(String lang, String className) {
        return this.wrapped.setWriterClassName(lang, className);
    }

    public synchronized long size() {
        return this.wrapped.size();
    }

    public synchronized boolean supportsSetOperations() {
        return this.wrapped.supportsSetOperations();
    }

    public synchronized boolean supportsTransactions() {
        return this.wrapped.supportsTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Model union(Model model) {
        Model model2 = model;
        synchronized (model2) {
            return new ThreadSafeModel(this.wrapped.union(model));
        }
    }

    public synchronized Model unregister(ModelChangedListener listener) {
        return this.wrapped.unregister(listener);
    }

    public synchronized Model write(OutputStream out) {
        return this.wrapped.write(out);
    }

    public synchronized Model write(OutputStream out, String lang) {
        return this.wrapped.write(out, lang);
    }

    public synchronized Model write(OutputStream out, String lang, String base) {
        return this.wrapped.write(out, lang, base);
    }

    public synchronized Model write(Writer writer) {
        return this.wrapped.write(writer);
    }

    public synchronized Model write(Writer writer, String lang) {
        return this.wrapped.write(writer, lang);
    }

    public synchronized Model write(Writer writer, String lang, String base) {
        return this.wrapped.write(writer, lang, base);
    }

    public ReificationStyle getReificationStyle() {
        return this.getGraph().getReifier().getStyle();
    }

    public Literal createTypedLiteral(Calendar arg0) {
        return this.wrapped.createTypedLiteral(arg0);
    }

    public PrefixMapping removeNsPrefix(String arg0) {
        return this.wrapped.removeNsPrefix(arg0);
    }
}

