/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.tsmodel;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.tsmodel.CachingStmtIterator;
import org.wymiwyg.commons.tsmodel.ThreadSafeModel;
import org.wymiwyg.commons.tsmodel.ThreadSafeStatement;

public class ThreadSafeResource
extends EnhNode
implements Resource {
    private static final Log logger = LogFactory.getLog(ThreadSafeResource.class);
    protected ThreadSafeModel model;
    private Resource wrapped;

    public ThreadSafeResource(ThreadSafeModel model, Resource wrapped) {
        super(wrapped.getNode(), new EnhGraph(model.getGraph(), (Personality)new GraphPersonality()));
        this.model = model;
        this.wrapped = wrapped;
    }

    public Resource abort() {
        this.wrapped.abort();
        return this;
    }

    public Resource addProperty(Property p, RDFNode o) {
        this.model.add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, String o) {
        this.model.add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, String o, String l) {
        this.model.add((Resource)this, p, o, l);
        return this;
    }

    public RDFNode as(Class view) {
        logger.warn((Object)"Synchronization not implemented");
        return this.wrapped.as(view);
    }

    public Node asNode() {
        return this.wrapped.asNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource begin() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            this.wrapped.begin();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAs(Class view) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.canAs(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource commit() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            this.wrapped.commit();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnonId getId() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalName() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.getLocalName();
        }
    }

    public Model getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNameSpace() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.getNameSpace();
        }
    }

    public Node getNode() {
        logger.warn((Object)"Synchronization not implemented");
        return this.wrapped.getNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getProperty(Property p) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            Statement wrappedResult = this.wrapped.getProperty(p);
            if (wrappedResult == null) {
                return null;
            }
            return new ThreadSafeStatement(this.model, wrappedResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getRequiredProperty(Property p) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return new ThreadSafeStatement(this.model, this.wrapped.getRequiredProperty(p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURI() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.getURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperty(Property p) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasProperty(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperty(Property p, RDFNode o) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasProperty(p, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperty(Property p, String o) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasProperty(p, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperty(Property p, String o, String l) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasProperty(p, o, l);
        }
    }

    public RDFNode inModel(Model m) {
        return this.wrapped.inModel(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StmtIterator listProperties() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return new CachingStmtIterator(this.model, this.wrapped.listProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StmtIterator listProperties(Property p) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return new CachingStmtIterator(this.model, this.wrapped.listProperties(p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource removeAll(Property p) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            this.wrapped.removeAll(p);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource removeProperties() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            this.wrapped.removeProperties();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitWith(RDFVisitor rv) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.visitWith(rv);
        }
    }

    Resource getWrapped() {
        return this.wrapped;
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public boolean hasURI(String arg0) {
        return !this.isAnon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addLiteral(Property arg0, boolean arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.addLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addLiteral(Property arg0, long arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.addLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addLiteral(Property arg0, char arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.addLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addLiteral(Property arg0, double arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.addLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addLiteral(Property arg0, float arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.addLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addLiteral(Property arg0, Object arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.addLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addProperty(Property arg0, String arg1, RDFDatatype arg2) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.addLiteral(arg0, (Object)arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiteral(Property arg0, boolean arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiteral(Property arg0, long arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiteral(Property arg0, char arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiteral(Property arg0, double arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiteral(Property arg0, float arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasLiteral(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiteral(Property arg0, Object arg1) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasLiteral(arg0, arg1);
        }
    }
}

