/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.tsmodel;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import org.wymiwyg.commons.tsmodel.CachingRSIterator;
import org.wymiwyg.commons.tsmodel.ThreadSafeModel;
import org.wymiwyg.commons.tsmodel.ThreadSafeProperty;
import org.wymiwyg.commons.tsmodel.ThreadSafeResource;
import org.wymiwyg.commons.tsmodel.ThreadSafeSeq;

public class ThreadSafeStatement
implements Statement {
    Statement wrapped;
    ThreadSafeModel model;

    public ThreadSafeStatement(ThreadSafeModel model, Statement wrapped) {
        this.model = model;
        this.wrapped = wrapped;
        if (wrapped == null) {
            throw new RuntimeException("Cannot wrapp null-statement");
        }
    }

    public Triple asTriple() {
        return this.wrapped.asTriple();
    }

    public Statement changeObject(boolean o) {
        return this.wrapped.changeObject(o);
    }

    public Statement changeObject(char o) {
        return this.wrapped.changeObject((long)o);
    }

    public Statement changeObject(double o) {
        return this.wrapped.changeObject(o);
    }

    public Statement changeObject(float o) {
        return this.wrapped.changeObject(o);
    }

    public Statement changeObject(long o) {
        return this.wrapped.changeObject(o);
    }

    public Statement changeObject(Object o) {
        return this.wrapped.changeObject(o);
    }

    public Statement changeObject(RDFNode o) {
        return this.wrapped.changeObject(o);
    }

    public Statement changeObject(String o, boolean wellFormed) {
        return this.wrapped.changeObject(o, wellFormed);
    }

    public Statement changeObject(String o, String l, boolean wellFormed) {
        return this.wrapped.changeObject(o, l, wellFormed);
    }

    public Statement changeObject(String o, String l) {
        return this.wrapped.changeObject(o, l);
    }

    public Statement changeObject(String o) {
        return this.wrapped.changeObject(o);
    }

    public ReifiedStatement createReifiedStatement() {
        return this.wrapped.createReifiedStatement();
    }

    public ReifiedStatement createReifiedStatement(String uri) {
        return this.wrapped.createReifiedStatement(uri);
    }

    public Alt getAlt() {
        return this.wrapped.getAlt();
    }

    public Bag getBag() {
        return this.wrapped.getBag();
    }

    public boolean getBoolean() {
        return this.wrapped.getBoolean();
    }

    public byte getByte() {
        return this.wrapped.getByte();
    }

    public char getChar() {
        return this.wrapped.getChar();
    }

    public double getDouble() {
        return this.wrapped.getDouble();
    }

    public float getFloat() {
        return this.wrapped.getFloat();
    }

    public int getInt() {
        return this.wrapped.getInt();
    }

    public String getLanguage() {
        return this.wrapped.getLanguage();
    }

    public Literal getLiteral() {
        return this.wrapped.getLiteral();
    }

    public long getLong() {
        return this.wrapped.getLong();
    }

    public Model getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDFNode getObject() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            RDFNode wrappedResult = this.wrapped.getObject();
            if (wrappedResult instanceof Resource) {
                return new ThreadSafeResource(this.model, (Resource)wrappedResult);
            }
            return wrappedResult;
        }
    }

    public Object getObject(ObjectF f) {
        return this.wrapped.getObject(f);
    }

    public Property getPredicate() {
        return new ThreadSafeProperty(this.model, this.wrapped.getPredicate());
    }

    public Statement getProperty(Property p) {
        Statement wrappedResult = this.wrapped.getProperty(p);
        if (wrappedResult == null) {
            return null;
        }
        return new ThreadSafeStatement(this.model, wrappedResult);
    }

    public Resource getResource() {
        return new ThreadSafeResource(this.model, this.wrapped.getResource());
    }

    public Resource getResource(ResourceF f) {
        return new ThreadSafeResource(this.model, this.wrapped.getResource(f));
    }

    public Seq getSeq() {
        Seq wrappedResult = this.wrapped.getSeq();
        if (wrappedResult == null) {
            return null;
        }
        return new ThreadSafeSeq(this.model, wrappedResult);
    }

    public short getShort() {
        return this.wrapped.getShort();
    }

    public Statement getStatementProperty(Property p) {
        return new ThreadSafeStatement(this.model, this.wrapped.getStatementProperty(p));
    }

    public String getString() {
        return this.wrapped.getString();
    }

    public Resource getSubject() {
        return new ThreadSafeResource(this.model, this.wrapped.getSubject());
    }

    public boolean isReified() {
        return this.wrapped.isReified();
    }

    public RSIterator listReifiedStatements() {
        return new CachingRSIterator(this.model, this.wrapped.listReifiedStatements());
    }

    public Statement remove() {
        this.model.remove(this.wrapped);
        return this;
    }

    public void removeReification() {
        this.model.removeAllReifications(this.wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            if (obj instanceof ThreadSafeStatement) {
                return this.wrapped.equals((Object)((ThreadSafeStatement)obj).wrapped);
            }
            return this.wrapped.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hashCode();
        }
    }

    public String toString() {
        return this.wrapped.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement changeLiteralObject(boolean arg0) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.changeLiteralObject(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement changeLiteralObject(long arg0) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.changeLiteralObject(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement changeLiteralObject(int arg0) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.changeLiteralObject(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement changeLiteralObject(char arg0) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.changeLiteralObject(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement changeLiteralObject(float arg0) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.changeLiteralObject(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement changeLiteralObject(double arg0) {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.changeLiteralObject(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWellFormedXML() {
        ThreadSafeModel threadSafeModel = this.model;
        synchronized (threadSafeModel) {
            return this.wrapped.hasWellFormedXML();
        }
    }
}

