/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.vocabulary.timezones;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import org.wymiwyg.commons.jena.JenaUtil;

public class Generator {
    public static void main(String[] args) throws URISyntaxException, IOException {
        Model tzData = ModelFactory.createDefaultModel();
        Model tzList = ModelFactory.createDefaultModel();
        tzList.read("http://www.w3.org/2002/12/cal/tzd/ifps.n3", "", "N3");
        ResIterator zoneIter = tzList.listSubjects();
        while (zoneIter.hasNext()) {
            Resource zone = zoneIter.nextResource();
            Model currentZoneModel = ModelFactory.createDefaultModel();
            try {
                currentZoneModel.read(zone.getURI().toString());
            }
            catch (Exception e) {
                System.err.println(e.toString());
                continue;
            }
            zone = (Resource)zone.inModel(currentZoneModel);
            tzData.add(JenaUtil.getExpandedResource(zone, 6));
        }
        zoneIter.close();
        File outFile = new File("time-zone-data.rdf");
        FileOutputStream outFileOut = new FileOutputStream(outFile);
        tzData.write((OutputStream)outFileOut);
        outFileOut.close();
    }
}

