/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.r3xserializer;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.XMLChar;
import org.wymiwyg.commons.jena.UnavailableLocalisationHandler;
import org.wymiwyg.commons.util.LanguageUnavailableException;
import org.wymiwyg.commons.util.MalformedURIException;
import org.wymiwyg.commons.util.URI;
import org.wymiwyg.rdfserializer.XMLEncoder;

public class Serializer {
    private static Log log = LogFactory.getLog(Serializer.class);
    private int prefixCounter = 0;
    private Map<String, String> nonModelPrefixMap = new HashMap<String, String>();
    private static final char ESCAPE = 'X';
    static final char[] hexchar = "0123456789abcdef".toCharArray();

    public Serializer() {
        this.nonModelPrefixMap.put(RDF.getURI(), "rdf");
        this.nonModelPrefixMap.put(RDFS.getURI(), "rdfs");
        this.nonModelPrefixMap.put(DC.getURI(), "dc");
        this.nonModelPrefixMap.put(RSS.getURI(), "rss");
        this.nonModelPrefixMap.put("http://www.daml.org/2001/03/daml+oil.daml#", "daml");
        this.nonModelPrefixMap.put(VCARD.getURI(), "vcard");
        this.nonModelPrefixMap.put("http://www.w3.org/2002/07/owl#", "owl");
        this.nonModelPrefixMap.put("http://jena.hpl.hp.com/gvs/aggregator#", "aggr");
        this.nonModelPrefixMap.put("http://discobits.org/ontology#", "disco");
        this.nonModelPrefixMap.put("http://gvs.hpl.hp.com/ontologies/authorization#", "gvsauth");
        this.nonModelPrefixMap.put("http://gvs.hpl.hp.com/ontologies/account-manager#", "gvsacc");
        this.nonModelPrefixMap.put("http://gvs.hpl.hp.com/ontologies/services#", "gvsser");
        this.nonModelPrefixMap.put("http://gvs.hpl.hp.com/ontologies/http-listener#", "gvshttp");
        this.nonModelPrefixMap.put("http://xmlns.com/foaf/0.1/", "foaf");
        this.nonModelPrefixMap.put("http://wymiwyg.org/ontologies/foaf/extensions#", "foafex");
        this.nonModelPrefixMap.put("http://wymiwyg.org/ontologies/foaf/postaddress#", "addr");
        this.nonModelPrefixMap.put("http://wymiwyg.org/ontologies/foaf/role#", "role");
        this.nonModelPrefixMap.put("http://wymiwyg.org/ontologies/knobot#", "knobot");
        this.nonModelPrefixMap.put("http://wymiwyg.org/ontologies/rss/attach#", "attach");
        this.nonModelPrefixMap.put("http://www.w3.org/2002/12/cal#", "calendar");
        this.nonModelPrefixMap.put("http://frot.org/space/0.1/", "space");
    }

    public void serialize(Model model, String base, Writer rawOut) throws IOException {
        try {
            this.serialize(model, base, rawOut, null, null, false);
        }
        catch (LanguageUnavailableException e) {
            throw new RuntimeException("LanguageUnavailableException at unexpected location", e);
        }
    }

    public void serialize(Model model, String base, Writer rawOut, Locale[] locales, UnavailableLocalisationHandler localisationHandler, boolean forceShow) throws IOException, LanguageUnavailableException {
        URI baseURI = null;
        if (base != null && !base.equals("")) {
            baseURI = new URI(base);
        }
        PrintWriter out = new PrintWriter(rawOut);
        this.writeHeader(out, model, baseURI);
        ResIterator subjects = model.listSubjects();
        while (subjects.hasNext()) {
            Resource current = subjects.nextResource();
            this.writeSubject(out, model, current, baseURI, locales, localisationHandler, forceShow);
        }
        out.print("</rdf:RDF>");
        out.flush();
    }

    private void writeSubject(PrintWriter out, Model model, Resource subject, URI baseURI, Locale[] locales, UnavailableLocalisationHandler localisationHandler, boolean forceShow) throws LanguageUnavailableException {
        if (subject.isAnon()) {
            out.print("  <rdf:Description rdf:nodeID=\"");
            out.print(Serializer.escapedId(subject.getId().toString()));
        } else {
            out.print("  <rdf:Description rdf:about=\"");
            out.print(XMLEncoder.encode(this.relativize(baseURI, subject.getURI())));
        }
        out.println("\">");
        StmtIterator stmtIter = subject.listProperties();
        TreeSet<Statement> sortedProperties = new TreeSet<Statement>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int ordinal1;
                Statement stmt0 = (Statement)arg0;
                Statement stmt1 = (Statement)arg1;
                if (stmt0.equals((Object)stmt1)) {
                    return 0;
                }
                Property predicate0 = stmt0.getPredicate();
                Property predicate1 = stmt1.getPredicate();
                int ordinal0 = predicate0.getOrdinal();
                if (ordinal0 != (ordinal1 = predicate1.getOrdinal())) {
                    return ordinal0 > ordinal1 ? 1 : -1;
                }
                int stringCompare = predicate0.getURI().compareTo(predicate1.getURI());
                if (stringCompare != 0) {
                    return stringCompare;
                }
                return stmt0.toString().compareTo(stmt1.toString());
            }
        });
        while (stmtIter.hasNext()) {
            sortedProperties.add(stmtIter.nextStatement());
        }
        HashSet<Property> processedLiteralPropertyTypes = new HashSet<Property>();
        for (Statement current : sortedProperties) {
            RDFNode object = current.getObject();
            if (object instanceof Literal) {
                Property predicate = current.getPredicate();
                if (processedLiteralPropertyTypes.contains(predicate)) continue;
                this.processLanguageProperty(out, model, baseURI, subject, predicate, locales, localisationHandler, forceShow);
                processedLiteralPropertyTypes.add(predicate);
                continue;
            }
            this.writeProperty(out, model, current, baseURI);
        }
        out.println("  </rdf:Description>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processLanguageProperty(PrintWriter out, Model model, URI baseURI, Resource subject, Property predicate, Locale[] locales, UnavailableLocalisationHandler localisationHandler, boolean forceShow) throws LanguageUnavailableException {
        StmtIterator stmtIter = subject.listProperties(predicate);
        if (locales == null) {
            while (stmtIter.hasNext()) {
                this.writeProperty(out, model, model.createStatement(subject, predicate, stmtIter.nextStatement().getObject()), baseURI);
            }
            return;
        } else {
            HashSet<Statement> noLanguageVersionStatementSet = new HashSet<Statement>();
            HashMap<Locale, Statement> availableVersions = new HashMap<Locale, Statement>();
            while (stmtIter.hasNext()) {
                Statement current = stmtIter.nextStatement();
                RDFNode currentObject = current.getObject();
                if (currentObject instanceof Literal) {
                    Locale currentLocale = this.parseLocale(((Literal)currentObject).getLanguage());
                    if (currentLocale == null) {
                        noLanguageVersionStatementSet.add(current);
                        continue;
                    }
                    availableVersions.put(currentLocale, current);
                    continue;
                }
                this.writeProperty(out, model, current, baseURI);
            }
            if (availableVersions.size() == 0 || locales == null) {
                for (Statement current : noLanguageVersionStatementSet) {
                    this.writeProperty(out, model, current, baseURI);
                }
                for (Statement current : availableVersions.values()) {
                    this.writeProperty(out, model, current, baseURI);
                }
                return;
            } else {
                boolean localizedVersionWritten = false;
                for (int i = 0; i < locales.length; ++i) {
                    Locale locale = locales[i];
                    Statement localizedStmt = (Statement)availableVersions.get(locale);
                    if (localizedStmt == null) {
                        locale = new Locale(locale.getLanguage());
                        localizedStmt = (Statement)availableVersions.get(locale);
                    }
                    if (localizedStmt == null) continue;
                    availableVersions.remove(locale);
                    this.writeProperty(out, model, localizedStmt, baseURI);
                    localizedVersionWritten = true;
                }
                if (forceShow) {
                    for (Statement current : availableVersions.values()) {
                        this.writeProperty(out, model, current, baseURI);
                    }
                }
                if (localizedVersionWritten && !forceShow) return;
                boolean languageIndependentVersionWritten = false;
                for (Statement current : noLanguageVersionStatementSet) {
                    this.writeProperty(out, model, current, baseURI);
                    languageIndependentVersionWritten = true;
                }
                if (languageIndependentVersionWritten && !forceShow) return;
                Literal[] availableLiterals = new Literal[availableVersions.size()];
                Iterator iter = availableVersions.values().iterator();
                for (int i = 0; i < availableLiterals.length; ++i) {
                    Statement currentAvailableVersion = (Statement)iter.next();
                    availableLiterals[i] = currentAvailableVersion.getLiteral();
                }
                try {
                    Literal[] replacement = localisationHandler.getReplacement(availableLiterals);
                    for (int i = 0; i < replacement.length; ++i) {
                        this.writeProperty(out, model, model.createStatement(subject, predicate, (RDFNode)replacement[i]), baseURI);
                    }
                    return;
                }
                catch (LanguageUnavailableException ex) {
                    if (localizedVersionWritten || languageIndependentVersionWritten || forceShow) return;
                    throw ex;
                }
            }
        }
    }

    private Locale parseLocale(String language) {
        if (language == null || language.equals("")) {
            return null;
        }
        int underscorePos = language.indexOf(45);
        if (underscorePos > -1) {
            return new Locale(language.substring(0, underscorePos - 1), language.substring(underscorePos + 1));
        }
        return new Locale(language);
    }

    private String relativize(URI baseURI, String uri) {
        if (baseURI == null) {
            return uri;
        }
        try {
            return baseURI.relativize(uri, 29);
        }
        catch (MalformedURIException e) {
            log.warn((Object)"failed relativizing URI", (Throwable)e);
            return uri;
        }
    }

    private void writeProperty(PrintWriter out, Model model, Statement statement, URI baseURI) {
        out.write("    ");
        Property predicate = statement.getPredicate();
        RDFNode object = statement.getObject();
        String nameSpaceURI = predicate.getNameSpace();
        String prefix = this.getPrefix(model, nameSpaceURI);
        String localName = predicate.getLocalName();
        if (predicate.getOrdinal() > 0) {
            localName = "li";
        }
        StringBuffer cNameBuffer = new StringBuffer();
        cNameBuffer.append(prefix);
        cNameBuffer.append(':');
        cNameBuffer.append(localName);
        String cName = cNameBuffer.toString();
        if (object instanceof Literal) {
            this.writeLiteralProperty(out, cName, (Literal)object);
        } else {
            this.writerResourceProperty(out, cName, (Resource)object, baseURI);
        }
    }

    private void writerResourceProperty(PrintWriter out, String cName, Resource resource, URI baseURI) {
        out.print('<');
        out.print(cName);
        if (resource.isAnon()) {
            out.print(" rdf:nodeID=\"");
            out.print(Serializer.escapedId(resource.getId().toString()));
        } else {
            out.print(" rdf:resource=\"");
            out.print(XMLEncoder.encode(this.relativize(baseURI, resource.getURI())));
        }
        out.println("\"/>");
    }

    private void writeLiteralProperty(PrintWriter out, String cName, Literal literal) {
        out.print('<');
        out.print(cName);
        String dataTypeURI = literal.getDatatypeURI();
        if (dataTypeURI != null) {
            if (dataTypeURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
                out.print(" rdf:parseType=\"Literal\"");
            } else {
                out.print(" rdf:datatype=\"");
                out.print(dataTypeURI);
                out.print('\"');
            }
        } else {
            String language = literal.getLanguage();
            if (language != null && !language.equals("")) {
                out.print(" xml:lang=\"");
                out.print(language);
                out.print('\"');
            }
        }
        out.write(62);
        if (literal.isWellFormedXML()) {
            out.write(literal.getLexicalForm());
        } else {
            out.write(XMLEncoder.encode(literal.getLexicalForm()));
        }
        out.print("</");
        out.print(cName);
        out.println(">");
    }

    private void writeHeader(PrintWriter out, Model model, URI baseURI) {
        NsIterator nsIterator = model.listNameSpaces();
        out.print("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        boolean first = true;
        while (nsIterator.hasNext()) {
            String uri = nsIterator.nextNs();
            String prefix = this.getPrefix(model, uri);
            if ("rdf".equals(prefix)) continue;
            if (first) {
                first = false;
            } else {
                out.println();
                out.print("  ");
            }
            out.print(" xmlns:");
            out.print(prefix);
            out.print("=\"");
            out.print(this.relativize(baseURI, uri));
            out.print('\"');
        }
        out.println('>');
    }

    private synchronized String getPrefix(Model model, String uri) {
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(uri)) {
            return "rdf";
        }
        String modelPrefix = model.getNsURIPrefix(uri);
        if (modelPrefix != null) {
            return modelPrefix;
        }
        String nonModelPrefix = this.nonModelPrefixMap.get(uri);
        if (nonModelPrefix != null) {
            return nonModelPrefix;
        }
        String newPrefix = this.getNewPrefix(model);
        this.nonModelPrefixMap.put(uri, newPrefix);
        return newPrefix;
    }

    private String getNewPrefix(Model model) {
        StringBuffer buffer = new StringBuffer("ns");
        buffer.append(this.prefixCounter++);
        String newName = buffer.toString();
        if (this.nonModelPrefixMap.containsKey(newName)) {
            return this.getNewPrefix(model);
        }
        if (model.getNsPrefixURI(newName) != null) {
            return this.getNewPrefix(model);
        }
        return newName;
    }

    private static String escapedId(String id) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (ch != 'X' && (i == 0 ? XMLChar.isNCNameStart((int)ch) : XMLChar.isNCName((int)ch))) {
                result.append(ch);
                continue;
            }
            Serializer.escape(result, ch);
        }
        return result.toString();
    }

    private static void escape(StringBuffer sb, char ch) {
        sb.append('X');
        int charcode = ch;
        do {
            sb.append(hexchar[charcode & 0xF]);
        } while ((charcode >>= 4) != 0);
        sb.append('X');
    }
}

