/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.rdfserializer;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.wymiwyg.rdfserializer.ContentProducer;
import org.wymiwyg.rdfserializer.NameSpaceAlreadyBoundException;

public class DocumentTag
implements ContentProducer {
    Map variables;
    Map nameSpaces = new HashMap();

    public DocumentTag(Map variables) {
        this.variables = variables;
        variables.put(DocumentTag.class, this);
        this.nameSpaces.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
    }

    public void write(Writer out) throws IOException {
        out.write("<rdf:RDF");
        for (String currentKey : this.nameSpaces.keySet()) {
            String currentValue = (String)this.nameSpaces.get(currentKey);
            out.write(" xmlns:");
            out.write(currentValue);
            out.write("=\"");
            out.write(currentKey);
            out.write(34);
        }
        out.write(62);
    }

    void addNameSpace(String prefix, String uri) throws NameSpaceAlreadyBoundException {
        if (this.nameSpaces.containsKey(uri)) {
            throw new NameSpaceAlreadyBoundException("The namespace " + uri + " is already bound");
        }
        this.nameSpaces.put(uri, prefix);
    }

    String getPrefixForNameSpace(String uri) {
        return (String)this.nameSpaces.get(uri);
    }
}

