/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.rdfserializer;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.jena.UnavailableLocalisationHandler;
import org.wymiwyg.commons.util.LanguageUnavailableException;
import org.wymiwyg.commons.util.MalformedURIException;
import org.wymiwyg.commons.util.URI;
import org.wymiwyg.rdfserializer.ContentProducer;
import org.wymiwyg.rdfserializer.ContentSink;
import org.wymiwyg.rdfserializer.ContentSinkImpl;
import org.wymiwyg.rdfserializer.DocumentTag;
import org.wymiwyg.rdfserializer.PropertyDescriptor;
import org.wymiwyg.rdfserializer.ResourceTag;
import org.wymiwyg.rdfserializer.Style;
import org.wymiwyg.rdfserializer.TypeDescriptor;
import org.wymiwyg.rdfserializer.ValueContentProducer;
import org.wymiwyg.rdfserializer.XMLEncoder;
import org.wymiwyg.rdfserializer.XMLTag;

public class ResourceSerializer {
    private static Log log = LogFactory.getLog(ResourceSerializer.class);
    private static final boolean escapeWellFormedLiteral = true;

    private Resource getDefaultStyle() {
        Model styleModel = ModelFactory.createDefaultModel();
        styleModel.read(this.getClass().getResource("default-style.rdf").toString());
        return styleModel.getResource("http://wymiwyg.org/rdfserializer/default-style#default");
    }

    public void serialize(Resource[] resources, Writer out) throws IOException, LanguageUnavailableException {
        this.serialize(resources, (String)null, out);
    }

    public void serialize(Resource[] resources, String urlBase, Writer out) throws IOException, LanguageUnavailableException {
        this.serialize(resources, this.getDefaultStyle(), urlBase, out);
    }

    public void serialize(Resource[] resources, String urlBase, String[] languages, UnavailableLocalisationHandler localisationHandler, Writer out) throws IOException, LanguageUnavailableException {
        this.serialize(resources, this.getDefaultStyle(), urlBase, languages, localisationHandler, out);
    }

    public void serialize(Resource[] resources, Resource styleRes, Writer out) throws IOException, LanguageUnavailableException {
        this.serialize(resources, styleRes, null, out);
    }

    public void serialize(Resource[] resources, Resource styleRes, String urlBase, Writer out) throws IOException, LanguageUnavailableException {
        this.serialize(resources, styleRes, urlBase, null, null, out);
    }

    public void serialize(Resource[] resources, Resource styleRes, String urlBase, String[] languages, UnavailableLocalisationHandler localisationHandler, Writer out) throws IOException, LanguageUnavailableException {
        ContentSinkImpl sink = new ContentSinkImpl();
        Style style = new Style(styleRes);
        this.serialize(resources, style, urlBase, languages, localisationHandler, sink);
        ContentProducer current = sink.nextProducer();
        while (current != null) {
            current.write(out);
            current = sink.nextProducer();
        }
        out.flush();
    }

    private void serialize(Resource[] resources, Style style, String urlBase, String[] languages, UnavailableLocalisationHandler localisationHandler, ContentSink sink) throws IOException, LanguageUnavailableException {
        HashMap variables = new HashMap();
        DocumentTag documentTag = new DocumentTag(variables);
        sink.append(documentTag);
        ArrayList remainingResources = new ArrayList();
        for (int i = 0; i < resources.length; ++i) {
            this.appendInlineResource(resources[i], style, variables, 0, urlBase, languages, localisationHandler, sink, remainingResources);
        }
        while (remainingResources.size() > 0) {
            Iterator appendingResourceIterator = remainingResources.iterator();
            remainingResources = new ArrayList();
            while (appendingResourceIterator.hasNext()) {
                Resource current = (Resource)appendingResourceIterator.next();
                this.appendInlineResource(current, style, variables, 0, urlBase, languages, localisationHandler, sink, remainingResources);
            }
        }
        sink.append(new ValueContentProducer("</rdf:RDF>"));
    }

    private void appendInlineResource(Resource resource, Style style, Map variables, int deepness, String urlBase, String[] languages, UnavailableLocalisationHandler localisationHandler, ContentSink sink, Collection remainingResources) throws IOException, LanguageUnavailableException {
        if (variables.containsKey(resource)) {
            return;
        }
        ++deepness;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deepness :" + deepness));
            log.debug((Object)("Appending resource of type (stmt): " + resource.getProperty(RDF.type)));
        }
        HashSet usedStatements = new HashSet();
        ResourceTag resourceTag = new ResourceTag(resource, style, usedStatements, variables, urlBase);
        sink.append(resourceTag);
        StmtIterator propertiesIter = resource.listProperties();
        HashSet<Property> propertyTypes = new HashSet<Property>();
        while (propertiesIter.hasNext()) {
            propertyTypes.add(propertiesIter.nextStatement().getPredicate());
        }
        PropertyDescriptor[] propertyDescriptors = style.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor current = propertyDescriptors[i];
            Property property = current.getProperty();
            if (!propertyTypes.contains(property)) continue;
            propertyTypes.remove(property);
            this.appendProperties(resource, property, usedStatements, current.getStyle(), variables, deepness, urlBase, languages, localisationHandler, sink, remainingResources);
        }
        Iterator remainingProperties = propertyTypes.iterator();
        TreeSet sortedProperties = new TreeSet(new PropertyComparator());
        while (remainingProperties.hasNext()) {
            sortedProperties.add(remainingProperties.next());
        }
        for (Property property : sortedProperties) {
            this.appendProperties(resource, property, usedStatements, style, variables, deepness, urlBase, languages, localisationHandler, sink, remainingResources);
        }
        sink.append(resourceTag.getClosingTag());
    }

    private void appendProperties(Resource resource, Property property, Set usedStatements, Style style, Map variables, int deepness, String urlBase, String[] languages, UnavailableLocalisationHandler localisationHandler, ContentSink sink, Collection remainingResources) throws IOException, LanguageUnavailableException {
        List<String> languageSet = Arrays.asList(languages);
        StmtIterator renderingProperties = resource.listProperties(property);
        Statement languageNeutral = null;
        boolean propertyValueAppended = false;
        HashSet<Literal> availableLiteralSet = new HashSet<Literal>();
        boolean languageVersionAvailable = false;
        Statement[] supportedLanguageVersions = new Statement[languages.length];
        while (renderingProperties.hasNext()) {
            Statement currentStatement = renderingProperties.nextStatement();
            if (!usedStatements.contains(currentStatement)) {
                RDFNode object = currentStatement.getObject();
                if (languages != null && object instanceof Literal) {
                    Literal literalObject = (Literal)object;
                    String language = literalObject.getLanguage();
                    if (language == null || language.equals("")) {
                        languageNeutral = currentStatement;
                    } else if (languageSet.contains(language)) {
                        supportedLanguageVersions[languageSet.indexOf((Object)language)] = currentStatement;
                        languageVersionAvailable = true;
                    } else {
                        availableLiteralSet.add(literalObject);
                    }
                } else {
                    this.appendProperty(currentStatement, style, variables, deepness, urlBase, languages, localisationHandler, sink, remainingResources);
                    propertyValueAppended = true;
                }
                usedStatements.add(currentStatement);
                continue;
            }
            propertyValueAppended = true;
        }
        if (languageVersionAvailable) {
            for (int i = 0; i < supportedLanguageVersions.length; ++i) {
                if (supportedLanguageVersions[i] == null) continue;
                this.appendProperty(supportedLanguageVersions[i], style, variables, deepness, urlBase, languages, localisationHandler, sink, remainingResources);
                propertyValueAppended = true;
            }
        }
        if (!propertyValueAppended) {
            if (languageNeutral != null) {
                this.appendProperty(languageNeutral, style, variables, deepness, urlBase, languages, localisationHandler, sink, remainingResources);
            } else {
                Literal[] availableLiterals = availableLiteralSet.toArray(new Literal[availableLiteralSet.size()]);
                Literal[] replacement = localisationHandler.getReplacement(availableLiterals);
                for (int i = 0; i < replacement.length; ++i) {
                    Statement replacementStatement = resource.getModel().createStatement(resource, property, (RDFNode)replacement[i]);
                    this.appendProperty(replacementStatement, style, variables, deepness, urlBase, languages, localisationHandler, sink, remainingResources);
                }
            }
        }
    }

    private void appendProperty(Statement statement, Style style, Map variables, int deepness, String urlBase, String[] languages, UnavailableLocalisationHandler localisationHandler, ContentSink sink, Collection remainingResources) throws IOException, LanguageUnavailableException {
        Property propertyType = statement.getPredicate();
        XMLTag openingTag = new XMLTag(style, variables);
        openingTag.setNameSpace(propertyType.getNameSpace());
        if (propertyType.getOrdinal() > 0) {
            openingTag.setLocalName("li");
        } else {
            openingTag.setLocalName(propertyType.getLocalName());
        }
        sink.append(openingTag);
        RDFNode object = statement.getObject();
        if (object instanceof Literal) {
            Literal literal;
            openingTag.setPreserveSpaces(true);
            String language = ((Literal)object).getLanguage();
            if (language != null && !language.equals("")) {
                openingTag.addXMLAttribute("lang", language);
            }
            if ((literal = (Literal)object).getWellFormed()) {
                sink.append(new ValueContentProducer(literal.getLexicalForm()));
            } else {
                if (literal.getWellFormed()) {
                    log.info((Object)("Literal " + literal + " is well formed"));
                }
                String literalValue = literal.getLexicalForm();
                sink.append(new ValueContentProducer(XMLEncoder.encode(literalValue)));
            }
            sink.append(openingTag.getClosingTag());
        } else {
            Resource resourceObject = (Resource)object;
            StmtIterator propertiesOfObject = ((Resource)object).listProperties();
            boolean hasProperty = propertiesOfObject.hasNext();
            propertiesOfObject.close();
            boolean hasChildElements = false;
            if (hasProperty) {
                ResourceTag existing = (ResourceTag)variables.get(object);
                if (resourceObject.isAnon() && deepness < style.getAnonymousDeepness() || deepness < style.getNonAnonymousDeepness()) {
                    if (existing == null) {
                        this.appendInlineResource((Resource)object, style, variables, deepness, urlBase, languages, localisationHandler, sink, remainingResources);
                        hasChildElements = true;
                    } else if (!((Resource)object).isAnon()) {
                        String uri = resourceObject.getURI();
                        if (urlBase != null && !urlBase.equals("")) {
                            try {
                                uri = new URI(urlBase).relativize(uri, 29);
                            }
                            catch (MalformedURIException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        openingTag.addAttribute(RDF.getURI(), "resource", uri);
                    } else {
                        String anonID = existing.getAnonID();
                        openingTag.addAttribute(RDF.getURI(), "ID", anonID);
                    }
                } else {
                    TypeDescriptor[] typeDescriptors = style.getTypeDescriptors();
                    boolean block = false;
                    for (int i = 0; i < typeDescriptors.length; ++i) {
                        TypeDescriptor current = typeDescriptors[i];
                        if (!resourceObject.hasProperty(RDF.type, (RDFNode)current.getType())) continue;
                        block = current.isBlock();
                        break;
                    }
                    if (!block) {
                        remainingResources.add(resourceObject);
                    }
                    if (!((Resource)object).isAnon()) {
                        String uri = resourceObject.getURI();
                        if (urlBase != null && !urlBase.equals("")) {
                            try {
                                uri = new URI(urlBase).relativize(uri, 29);
                            }
                            catch (MalformedURIException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        openingTag.addAttribute(RDF.getURI(), "resource", uri);
                    } else {
                        ResourceTag future = new ResourceTag(resourceObject, style, new HashSet(), variables, urlBase);
                        String anonID = future.getAnonID();
                        openingTag.addAttribute(RDF.getURI(), "ID", anonID);
                    }
                }
            } else if (!((Resource)object).isAnon()) {
                String uri = resourceObject.getURI();
                if (urlBase != null && !urlBase.equals("")) {
                    try {
                        uri = new URI(urlBase).relativize(uri, 29);
                    }
                    catch (MalformedURIException e) {
                        log.warn((Object)("Failed relativazing URI " + uri + " using URL base " + urlBase), (Throwable)e);
                    }
                }
                openingTag.addAttribute(RDF.getURI(), "resource", uri);
            }
            if (hasChildElements) {
                sink.append(openingTag.getClosingTag());
            } else {
                openingTag.close();
            }
        }
    }

    class PropertyComparator
    implements Comparator {
        PropertyComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0.equals(arg1)) {
                return 0;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing: " + arg0 + " with " + arg1));
            }
            int result = 0;
            if (arg0 instanceof Property && arg1 instanceof Property) {
                result = ((Property)arg0).getOrdinal() - ((Property)arg1).getOrdinal();
            }
            if (result != 0) {
                return result;
            }
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

