/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.rdfserializer;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.util.MalformedURIException;
import org.wymiwyg.commons.util.URI;
import org.wymiwyg.rdfserializer.Style;
import org.wymiwyg.rdfserializer.TypeDescriptor;
import org.wymiwyg.rdfserializer.XMLTag;

public class ResourceTag
extends XMLTag {
    private static Log log = LogFactory.getLog(ResourceTag.class);
    private String anonID = null;
    private static int anonCounter = 0;

    public ResourceTag(Resource resource, Style style, Set usedStatements, Map variables, String urlBase) {
        super(style, variables);
        variables.put(resource, this);
        StmtIterator typeIter = resource.listProperties(RDF.type);
        HashSet<Resource> typeSet = new HashSet<Resource>();
        while (typeIter.hasNext()) {
            typeSet.add(typeIter.nextStatement().getResource());
        }
        Resource mainType = null;
        TypeDescriptor[] typeDescriptors = style.getTypeDescriptors();
        for (int i = 0; i < typeDescriptors.length; ++i) {
            Resource current = typeDescriptors[i].getType();
            if (!typeSet.contains(current)) continue;
            mainType = current;
            break;
        }
        if (mainType == null) {
            if (typeSet.size() > 1) {
                log.warn((Object)("None of the types of resource " + resource + " has a type descriptor"));
            }
            if (typeSet.size() == 1) {
                mainType = (Resource)typeSet.iterator().next();
            }
        }
        if (mainType != null) {
            this.setNameSpace(mainType.getNameSpace());
            this.setLocalName(mainType.getLocalName());
            usedStatements.add(resource.getModel().createStatement(resource, RDF.type, (RDFNode)mainType));
        } else {
            this.setNameSpace(RDF.getURI());
            this.setLocalName("Description");
        }
        if (!resource.isAnon()) {
            String uri = resource.getURI();
            if (urlBase != null && !urlBase.equals("")) {
                try {
                    uri = new URI(urlBase).relativize(uri, 29);
                }
                catch (MalformedURIException e) {
                    throw new RuntimeException(e);
                }
            }
            this.addAttribute(RDF.getURI(), "about", uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnonID() {
        Class<ResourceTag> clazz = ResourceTag.class;
        synchronized (ResourceTag.class) {
            if (this.anonID == null) {
                this.anonID = "A" + ++anonCounter;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.anonID;
        }
    }
}

