/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.rdfserializer;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;
import org.wymiwyg.rdfserializer.PropertyDescriptor;
import org.wymiwyg.rdfserializer.PropertyDescriptorImpl;
import org.wymiwyg.rdfserializer.RDFSERIALIZER;
import org.wymiwyg.rdfserializer.StyleException;
import org.wymiwyg.rdfserializer.TypeDescriptor;
import org.wymiwyg.rdfserializer.TypeDescriptorImpl;

public class Style {
    Map prefixMap = new HashMap();
    Resource styleRes;

    public Style() {
    }

    public Style(Resource styleRes) {
        if (!styleRes.hasProperty(RDF.type, (RDFNode)RDFSERIALIZER.Style)) {
            throw new RuntimeException("the styleRes " + styleRes + " is not of type " + RDFSERIALIZER.Style);
        }
        this.styleRes = styleRes;
        this.loadPrefixMap();
    }

    private void loadPrefixMap() {
        StmtIterator propIter = this.styleRes.listProperties(RDFSERIALIZER.nameSpacePrefix);
        while (propIter.hasNext()) {
            Resource nsPrefix = propIter.nextStatement().getResource();
            String prefix = nsPrefix.getProperty(RDFSERIALIZER.prefix).getString();
            String url = nsPrefix.getProperty(RDFSERIALIZER.url).getString();
            this.prefixMap.put(url, prefix);
        }
    }

    public TypeDescriptor[] getTypeDescriptors() {
        Statement typeDescriptorStmt = this.styleRes.getProperty(RDFSERIALIZER.typeDescriptors);
        if (typeDescriptorStmt == null) {
            return new TypeDescriptor[0];
        }
        Seq descriptors = typeDescriptorStmt.getSeq();
        TypeDescriptor[] result = new TypeDescriptor[descriptors.size()];
        for (int i = 0; i < result.length; ++i) {
            Resource current = descriptors.getResource(i + 1);
            if (!current.hasProperty(RDF.type, (RDFNode)RDFSERIALIZER.TypeDescriptor)) {
                throw new StyleException("Resource " + current + " is not of type TypeDescriptor");
            }
            result[i] = new TypeDescriptorImpl(this, current);
        }
        return result;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        Statement propertyDescriptorStmt = this.styleRes.getProperty(RDFSERIALIZER.propertyDescriptors);
        if (propertyDescriptorStmt == null) {
            return new PropertyDescriptor[0];
        }
        Seq descriptors = propertyDescriptorStmt.getSeq();
        PropertyDescriptor[] result = new PropertyDescriptor[descriptors.size()];
        for (int i = 0; i < result.length; ++i) {
            Resource current = descriptors.getResource(i + 1);
            if (!current.hasProperty(RDF.type, (RDFNode)RDFSERIALIZER.PropertyDescriptor)) {
                throw new StyleException("Resource " + current + " is not of type PropertyDescriptor");
            }
            result[i] = new PropertyDescriptorImpl(this, current);
        }
        return result;
    }

    public String getNameSpacePrefix(String nameSpace) {
        return (String)this.prefixMap.get(nameSpace);
    }

    public int getAnonymousDeepness() {
        return this.styleRes.getProperty(RDFSERIALIZER.anonymousDeepness).getInt();
    }

    public int getNonAnonymousDeepness() {
        return this.styleRes.getProperty(RDFSERIALIZER.nonAnonymousDeepness).getInt();
    }
}

