/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.rdfserializer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.wymiwyg.rdfserializer.ContentProducer;
import org.wymiwyg.rdfserializer.DocumentTag;
import org.wymiwyg.rdfserializer.NameSpaceAlreadyBoundException;
import org.wymiwyg.rdfserializer.Style;
import org.wymiwyg.rdfserializer.XMLEncoder;

public class XMLTag
implements ContentProducer {
    private String localName;
    private String prefix;
    private Map variables;
    private Style style;
    private static ThreadLocal prefixNumber = new ThreadLocal();
    private StringBuffer attributes = new StringBuffer();
    private boolean closed = false;
    private boolean preserveSpaces = false;
    private static ThreadLocal indentationHolder = new ThreadLocal();

    public XMLTag(Style style, Map variables) {
        this.variables = variables;
        this.style = style;
    }

    public void write(Writer out) throws IOException {
        Integer indentation = (Integer)indentationHolder.get();
        if (indentation == null) {
            indentation = new Integer(0);
            indentationHolder.set(indentation);
        }
        out.write(10);
        int indentationInt = indentation;
        for (int i = 0; i < indentationInt; ++i) {
            out.write("  ");
        }
        out.write(60);
        out.write(this.prefix);
        out.write(58);
        out.write(this.localName);
        out.write(this.attributes.toString());
        if (this.closed) {
            out.write(47);
        } else {
            indentationHolder.set(new Integer(indentationInt + 1));
        }
        out.write(62);
    }

    public void addAttribute(String nameSpace, String localName, String value) {
        String attributePrefix = this.getPrefix(nameSpace);
        this.attributes.append(' ');
        this.attributes.append(attributePrefix);
        this.attributes.append(':');
        this.attributes.append(localName);
        this.attributes.append("=\"");
        this.attributes.append(XMLEncoder.encode(value));
        this.attributes.append("\" ");
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setNameSpace(String nameSpace) {
        this.prefix = this.getPrefix(nameSpace);
    }

    private String getPrefix(String nameSpace) {
        DocumentTag documentTag = (DocumentTag)this.variables.get(DocumentTag.class);
        String result = documentTag.getPrefixForNameSpace(nameSpace);
        if (result == null) {
            result = this.style.getNameSpacePrefix(nameSpace);
            if (result == null) {
                Integer prefixInteger = (Integer)prefixNumber.get();
                int prefixInt = prefixInteger != null ? prefixInteger : 0;
                result = "k." + prefixInt++;
                prefixNumber.set(new Integer(prefixInt));
            }
            try {
                documentTag.addNameSpace(result, nameSpace);
            }
            catch (NameSpaceAlreadyBoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    ContentProducer getClosingTag() {
        return new ContentProducer(){

            public void write(Writer out) throws IOException {
                Integer indentation = (Integer)indentationHolder.get();
                int indentationInt = indentation;
                --indentationInt;
                if (!XMLTag.this.preserveSpaces) {
                    out.write(10);
                    for (int i = 0; i < indentationInt; ++i) {
                        out.write("  ");
                    }
                }
                indentationHolder.set(new Integer(indentationInt));
                out.write("</");
                out.write(XMLTag.this.prefix);
                out.write(58);
                out.write(XMLTag.this.localName);
                out.write(62);
            }
        };
    }

    public void addXMLAttribute(String localName, String value) {
        this.attributes.append(" xml:");
        this.attributes.append(localName);
        this.attributes.append("=\"");
        this.attributes.append(value);
        this.attributes.append("\" ");
    }

    public void close() {
        this.closed = true;
    }

    public boolean isPreserveSpaces() {
        return this.preserveSpaces;
    }

    public void setPreserveSpaces(boolean preserveSpaces) {
        this.preserveSpaces = preserveSpaces;
    }
}

