/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.trixserializer;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.util.MalformedURIException;
import org.wymiwyg.commons.util.URI;
import org.wymiwyg.rdfserializer.XMLEncoder;

public class Serializer {
    Log log = LogFactory.getLog(Serializer.class);

    public void serialize(Model model, String base, Writer out) throws NoSuchElementException, IOException {
        PrintWriter pOut = new PrintWriter(out);
        this.printHeader(pOut);
        StmtIterator statements = model.listStatements();
        while (statements.hasNext()) {
            this.printStmt(statements.nextStatement(), base, pOut);
        }
        this.printFooter(pOut);
        pOut.flush();
    }

    private void printStmt(Statement statement, String base, PrintWriter out) throws IOException {
        out.println("      <triple>");
        this.printResource(statement.getSubject(), base, out);
        this.printResource((Resource)statement.getPredicate(), base, out);
        this.printNode(statement.getObject(), base, out);
        out.println("      </triple>");
    }

    private void printNode(RDFNode node, String base, PrintWriter out) throws IOException {
        if (node instanceof Resource) {
            this.printResource((Resource)node, base, out);
        } else {
            Literal literal = (Literal)node;
            this.printLiteral(literal, out);
        }
    }

    private void printLiteral(Literal literal, PrintWriter out) {
        String dataTypeURI = literal.getDatatypeURI();
        if (dataTypeURI == null) {
            this.printPlainLiteral(literal, out);
        } else {
            out.print("        <typedLiteral datatype=\"");
            out.print(dataTypeURI);
            out.print('\"');
            this.addLanguage(literal, out);
            out.print(">");
            out.print(XMLEncoder.encode(literal.getLexicalForm()));
            out.println("</typedLiteral>");
        }
    }

    private void printPlainLiteral(Literal literal, PrintWriter out) {
        out.print("        <plainLiteral");
        this.addLanguage(literal, out);
        out.print(">");
        out.print(XMLEncoder.encode(literal.getLexicalForm()));
        out.println("</plainLiteral>");
    }

    private void addLanguage(Literal literal, PrintWriter out) {
        String language = literal.getLanguage();
        if (language != null && !language.equals("")) {
            out.print(" xml:lang=\"" + language + "\"");
        }
    }

    private void printResource(Resource resource, String base, PrintWriter out) throws IOException {
        if (resource.isAnon()) {
            out.print("        <id>");
            out.print(resource.getId());
            out.println("</id>");
        } else {
            out.print("        <uri>");
            if (base == null) {
                out.print(XMLEncoder.encode(resource.getURI()));
            } else {
                try {
                    out.print(XMLEncoder.encode(new URI(base).relativize(resource.getURI(), 29)));
                }
                catch (MalformedURIException e) {
                    this.log.warn((Object)("Exception relativizing URI " + resource.getURI()), (Throwable)e);
                    out.print(resource.getURI());
                }
            }
            out.println("</uri>");
        }
    }

    private void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\"?>");
        out.println("  <graphset xmlns=\"http://www.w3.org/2004/03/trix/trix-1/\">");
        out.println("    <graph>");
    }

    private void printFooter(PrintWriter out) {
        out.println("    </graph>");
        out.println("  </graphset>");
    }
}

