/*
 * Copyright © 2023 Jacob Wysko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wysko.kmidi.event

/**
 * A [NoteOn] or a [NoteOff].
 *
 * @param note the note value
 */
sealed class MidiNoteEvent(
    override val time: Int,
    override val channel: Byte,
    open val note: Byte
) : MidiChannelEvent(time, channel) {

    /**
     * Signals a note should begin playing.
     *
     * @param velocity The non-zero velocity of the note.
     */
    data class NoteOn(
        override val time: Int,
        override val channel: Byte,
        override val note: Byte,
        val velocity: Byte
    ) : MidiNoteEvent(time, channel, note)

    /**
     * Signals that a note should stop playing.
     */
    data class NoteOff(
        override val time: Int,
        override val channel: Byte,
        override val note: Byte
    ) : MidiNoteEvent(time, channel, note)

}