/*
 * Copyright © 2023 Jacob Wysko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wysko.kmidi.event

/**
 * This message is most often sent by pressing down on the key after it "bottoms
 * out".
 *
 * @param note The key (note) number.
 * @param pressure The pressure value.
 */
data class MidiPolyphonicKeyPressureEvent(
    override val time: Int, override val channel: Byte, val note: Byte, val pressure: Byte
) : MidiChannelEvent(time, channel)