/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.midi.Arc;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.kmidi.midi.event.NoteEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile;", "", "header", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header;", "tracks", "", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "(Lorg/wysko/kmidi/midi/StandardMidiFile$Header;Ljava/util/List;)V", "getHeader", "()Lorg/wysko/kmidi/midi/StandardMidiFile$Header;", "tpq", "", "getTpq", "()S", "getTracks", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Header", "Track", "kmidi"})
public final class StandardMidiFile {
    @NotNull
    private final Header header;
    @NotNull
    private final List<Track> tracks;
    private final short tpq;

    public StandardMidiFile(@NotNull Header header, @NotNull List<Track> tracks) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
        this.header = header;
        this.tracks = tracks;
        if (!(this.tracks.size() == this.header.getTrackCount())) {
            boolean bl = false;
            String string = "Invalid track count: header specifies " + this.header.getTrackCount() + " tracks, but there are " + this.tracks.size() + " tracks";
            throw new IllegalStateException(string.toString());
        }
        this.tpq = this.header.getDivision().getTicksPerQuarterNote();
    }

    @NotNull
    public final Header getHeader() {
        return this.header;
    }

    @NotNull
    public final List<Track> getTracks() {
        return this.tracks;
    }

    public final short getTpq() {
        return this.tpq;
    }

    @NotNull
    public final Header component1() {
        return this.header;
    }

    @NotNull
    public final List<Track> component2() {
        return this.tracks;
    }

    @NotNull
    public final StandardMidiFile copy(@NotNull Header header, @NotNull List<Track> tracks) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
        return new StandardMidiFile(header, tracks);
    }

    public static /* synthetic */ StandardMidiFile copy$default(StandardMidiFile standardMidiFile, Header header, List list, int n, Object object) {
        if ((n & 1) != 0) {
            header = standardMidiFile.header;
        }
        if ((n & 2) != 0) {
            list = standardMidiFile.tracks;
        }
        return standardMidiFile.copy(header, list);
    }

    @NotNull
    public String toString() {
        return "StandardMidiFile(header=" + this.header + ", tracks=" + this.tracks + ')';
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = result * 31 + ((Object)this.tracks).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StandardMidiFile)) {
            return false;
        }
        StandardMidiFile standardMidiFile = (StandardMidiFile)other;
        if (!Intrinsics.areEqual((Object)this.header, (Object)standardMidiFile.header)) {
            return false;
        }
        return Intrinsics.areEqual(this.tracks, standardMidiFile.tracks);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Header;", "", "chunkType", "", "format", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;", "trackCount", "", "division", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "(Ljava/lang/String;Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;SLorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;)V", "getChunkType", "()Ljava/lang/String;", "getDivision", "()Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "getFormat", "()Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;", "getTrackCount", "()S", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Division", "Format", "kmidi"})
    public static final class Header {
        @NotNull
        private final String chunkType;
        @NotNull
        private final Format format;
        private final short trackCount;
        @NotNull
        private final Division division;

        public Header(@NotNull String chunkType, @NotNull Format format, short trackCount, @NotNull Division division) {
            Intrinsics.checkNotNullParameter((Object)chunkType, (String)"chunkType");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            Intrinsics.checkNotNullParameter((Object)division, (String)"division");
            this.chunkType = chunkType;
            this.format = format;
            this.trackCount = trackCount;
            this.division = division;
            if (!Intrinsics.areEqual((Object)this.chunkType, (Object)"MThd")) {
                boolean bl = false;
                String string = "Invalid header chunk type: " + this.chunkType;
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final String getChunkType() {
            return this.chunkType;
        }

        @NotNull
        public final Format getFormat() {
            return this.format;
        }

        public final short getTrackCount() {
            return this.trackCount;
        }

        @NotNull
        public final Division getDivision() {
            return this.division;
        }

        @NotNull
        public final String component1() {
            return this.chunkType;
        }

        @NotNull
        public final Format component2() {
            return this.format;
        }

        public final short component3() {
            return this.trackCount;
        }

        @NotNull
        public final Division component4() {
            return this.division;
        }

        @NotNull
        public final Header copy(@NotNull String chunkType, @NotNull Format format, short trackCount, @NotNull Division division) {
            Intrinsics.checkNotNullParameter((Object)chunkType, (String)"chunkType");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            Intrinsics.checkNotNullParameter((Object)division, (String)"division");
            return new Header(chunkType, format, trackCount, division);
        }

        public static /* synthetic */ Header copy$default(Header header, String string, Format format, short s, Division division, int n, Object object) {
            if ((n & 1) != 0) {
                string = header.chunkType;
            }
            if ((n & 2) != 0) {
                format = header.format;
            }
            if ((n & 4) != 0) {
                s = header.trackCount;
            }
            if ((n & 8) != 0) {
                division = header.division;
            }
            return header.copy(string, format, s, division);
        }

        @NotNull
        public String toString() {
            return "Header(chunkType=" + this.chunkType + ", format=" + (Object)((Object)this.format) + ", trackCount=" + this.trackCount + ", division=" + this.division + ')';
        }

        public int hashCode() {
            int result = this.chunkType.hashCode();
            result = result * 31 + this.format.hashCode();
            result = result * 31 + Short.hashCode(this.trackCount);
            result = result * 31 + this.division.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Header)) {
                return false;
            }
            Header header = (Header)other;
            if (!Intrinsics.areEqual((Object)this.chunkType, (Object)header.chunkType)) {
                return false;
            }
            if (this.format != header.format) {
                return false;
            }
            if (this.trackCount != header.trackCount) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.division, (Object)header.division);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "", "()V", "ticksPerQuarterNote", "", "getTicksPerQuarterNote", "()S", "MetricalTime", "TimecodeBasedTime", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division$MetricalTime;", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division$TimecodeBasedTime;", "kmidi"})
        public static abstract class Division {
            private Division() {
            }

            public abstract short getTicksPerQuarterNote();

            public /* synthetic */ Division(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division$MetricalTime;", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "ticksPerQuarterNote", "", "(S)V", "getTicksPerQuarterNote", "()S", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kmidi"})
            public static final class MetricalTime
            extends Division {
                private final short ticksPerQuarterNote;

                public MetricalTime(short ticksPerQuarterNote) {
                    super(null);
                    this.ticksPerQuarterNote = ticksPerQuarterNote;
                    short s = this.getTicksPerQuarterNote();
                    if (!(0 <= s ? s < 32768 : false)) {
                        boolean bl = false;
                        String string = "Invalid ticks per quarter note: " + this.getTicksPerQuarterNote();
                        throw new IllegalArgumentException(string.toString());
                    }
                }

                @Override
                public short getTicksPerQuarterNote() {
                    return this.ticksPerQuarterNote;
                }

                public final short component1() {
                    return this.ticksPerQuarterNote;
                }

                @NotNull
                public final MetricalTime copy(short ticksPerQuarterNote) {
                    return new MetricalTime(ticksPerQuarterNote);
                }

                public static /* synthetic */ MetricalTime copy$default(MetricalTime metricalTime, short s, int n, Object object) {
                    if ((n & 1) != 0) {
                        s = metricalTime.ticksPerQuarterNote;
                    }
                    return metricalTime.copy(s);
                }

                @NotNull
                public String toString() {
                    return "MetricalTime(ticksPerQuarterNote=" + this.ticksPerQuarterNote + ')';
                }

                public int hashCode() {
                    return Short.hashCode(this.ticksPerQuarterNote);
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof MetricalTime)) {
                        return false;
                    }
                    MetricalTime metricalTime = (MetricalTime)other;
                    return this.ticksPerQuarterNote == metricalTime.ticksPerQuarterNote;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division$TimecodeBasedTime;", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "framesPerSecond", "", "ticksPerFrame", "(SS)V", "getFramesPerSecond", "()S", "getTicksPerFrame", "ticksPerQuarterNote", "getTicksPerQuarterNote", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "kmidi"})
            @SourceDebugExtension(value={"SMAP\nStandardMidiFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardMidiFile.kt\norg/wysko/kmidi/midi/StandardMidiFile$Header$Division$TimecodeBasedTime\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1549#2:183\n1620#2,3:184\n*S KotlinDebug\n*F\n+ 1 StandardMidiFile.kt\norg/wysko/kmidi/midi/StandardMidiFile$Header$Division$TimecodeBasedTime\n*L\n148#1:183\n148#1:184,3\n*E\n"})
            public static final class TimecodeBasedTime
            extends Division {
                @NotNull
                private static final Companion Companion;
                private final short framesPerSecond;
                private final short ticksPerFrame;
                private final short ticksPerQuarterNote;
                @NotNull
                private static final Set<Short> validFramesPerSecond;

                public TimecodeBasedTime(short framesPerSecond, short ticksPerFrame) {
                    super(null);
                    this.framesPerSecond = framesPerSecond;
                    this.ticksPerFrame = ticksPerFrame;
                    if (!validFramesPerSecond.contains(this.framesPerSecond)) {
                        boolean bl = false;
                        String string = "Invalid frames per second: " + this.framesPerSecond;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.ticksPerQuarterNote = (short)(-1 * this.framesPerSecond * this.ticksPerFrame);
                }

                public final short getFramesPerSecond() {
                    return this.framesPerSecond;
                }

                public final short getTicksPerFrame() {
                    return this.ticksPerFrame;
                }

                @Override
                public short getTicksPerQuarterNote() {
                    return this.ticksPerQuarterNote;
                }

                public final short component1() {
                    return this.framesPerSecond;
                }

                public final short component2() {
                    return this.ticksPerFrame;
                }

                @NotNull
                public final TimecodeBasedTime copy(short framesPerSecond, short ticksPerFrame) {
                    return new TimecodeBasedTime(framesPerSecond, ticksPerFrame);
                }

                public static /* synthetic */ TimecodeBasedTime copy$default(TimecodeBasedTime timecodeBasedTime, short s, short s2, int n, Object object) {
                    if ((n & 1) != 0) {
                        s = timecodeBasedTime.framesPerSecond;
                    }
                    if ((n & 2) != 0) {
                        s2 = timecodeBasedTime.ticksPerFrame;
                    }
                    return timecodeBasedTime.copy(s, s2);
                }

                @NotNull
                public String toString() {
                    return "TimecodeBasedTime(framesPerSecond=" + this.framesPerSecond + ", ticksPerFrame=" + this.ticksPerFrame + ')';
                }

                public int hashCode() {
                    int result = Short.hashCode(this.framesPerSecond);
                    result = result * 31 + Short.hashCode(this.ticksPerFrame);
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof TimecodeBasedTime)) {
                        return false;
                    }
                    TimecodeBasedTime timecodeBasedTime = (TimecodeBasedTime)other;
                    if (this.framesPerSecond != timecodeBasedTime.framesPerSecond) {
                        return false;
                    }
                    return this.ticksPerFrame == timecodeBasedTime.ticksPerFrame;
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var3_3;
                    void $this$mapTo$iv$iv;
                    Companion = new Companion(null);
                    Object[] objectArray = new Integer[]{-24, -25, -29, -30};
                    Iterable $this$map$iv = SetsKt.setOf((Object[])objectArray);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        int n = ((Number)item$iv$iv).intValue();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((short)it);
                    }
                    validFramesPerSecond = CollectionsKt.toSet((Iterable)((List)var3_3));
                }

                @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\n\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division$TimecodeBasedTime$Companion;", "", "()V", "validFramesPerSecond", "", "", "getValidFramesPerSecond$annotations", "kmidi"})
                private static final class Companion {
                    private Companion() {
                    }

                    private static /* synthetic */ void getValidFramesPerSecond$annotations() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;", "", "value", "", "(Ljava/lang/String;II)V", "Format0", "Format1", "Format2", "Companion", "kmidi"})
        public static final class Format
        extends Enum<Format> {
            @NotNull
            public static final Companion Companion;
            private final int value;
            public static final /* enum */ Format Format0;
            public static final /* enum */ Format Format1;
            public static final /* enum */ Format Format2;
            private static final /* synthetic */ Format[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Format(int value) {
                this.value = value;
            }

            public static Format[] values() {
                return (Format[])$VALUES.clone();
            }

            public static Format valueOf(String value) {
                return Enum.valueOf(Format.class, value);
            }

            @NotNull
            public static EnumEntries<Format> getEntries() {
                return $ENTRIES;
            }

            static {
                Format0 = new Format(0);
                Format1 = new Format(1);
                Format2 = new Format(2);
                $VALUES = formatArray = new Format[]{Format.Format0, Format.Format1, Format.Format2};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format$Companion;", "", "()V", "fromValue", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;", "value", "", "kmidi"})
            @SourceDebugExtension(value={"SMAP\nStandardMidiFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardMidiFile.kt\norg/wysko/kmidi/midi/StandardMidiFile$Header$Format$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n288#2,2:183\n*S KotlinDebug\n*F\n+ 1 StandardMidiFile.kt\norg/wysko/kmidi/midi/StandardMidiFile$Header$Format$Companion\n*L\n93#1:183,2\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Format fromValue(short value) {
                    Object v0;
                    block2: {
                        Iterable $this$firstOrNull$iv = (Iterable)Format.getEntries();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Format it = (Format)((Object)element$iv);
                            boolean bl = false;
                            if (!(it.value == value)) continue;
                            v0 = element$iv;
                            break block2;
                        }
                        v0 = null;
                    }
                    Format format = v0;
                    if (format == null) {
                        throw new IllegalArgumentException("Invalid format value: " + value);
                    }
                    return format;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\fH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "", "events", "", "Lorg/wysko/kmidi/midi/event/Event;", "(Ljava/util/List;)V", "arcs", "Lorg/wysko/kmidi/midi/Arc;", "getArcs", "()Ljava/util/List;", "getEvents", "name", "", "getName", "()Ljava/lang/String;", "notes", "Lorg/wysko/kmidi/midi/event/NoteEvent;", "getNotes", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "kmidi"})
    @SourceDebugExtension(value={"SMAP\nStandardMidiFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardMidiFile.kt\norg/wysko/kmidi/midi/StandardMidiFile$Track\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n800#2,11:183\n800#2,11:194\n*S KotlinDebug\n*F\n+ 1 StandardMidiFile.kt\norg/wysko/kmidi/midi/StandardMidiFile$Track\n*L\n168#1:183,11\n174#1:194,11\n*E\n"})
    public static final class Track {
        @NotNull
        private final List<Event> events;
        @Nullable
        private final String name;

        /*
         * WARNING - void declaration
         */
        public Track(@NotNull List<? extends Event> events) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.events = events;
            Iterable iterable = this.events;
            Track track = this;
            boolean $i$f$filterIsInstance = false;
            void var4_5 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MetaEvent.SequenceTrackName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MetaEvent.SequenceTrackName sequenceTrackName = (MetaEvent.SequenceTrackName)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            track.name = sequenceTrackName != null ? sequenceTrackName.getText() : null;
        }

        @NotNull
        public final List<Event> getEvents() {
            return this.events;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<NoteEvent> getNotes() {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.events;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof NoteEvent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public final List<Arc> getArcs() {
            return Arc.Companion.fromNoteEvents(this.getNotes());
        }

        @NotNull
        public final List<Event> component1() {
            return this.events;
        }

        @NotNull
        public final Track copy(@NotNull List<? extends Event> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            return new Track(events);
        }

        public static /* synthetic */ Track copy$default(Track track, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = track.events;
            }
            return track.copy(list);
        }

        @NotNull
        public String toString() {
            return "Track(events=" + this.events + ')';
        }

        public int hashCode() {
            return ((Object)this.events).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Track)) {
                return false;
            }
            Track track = (Track)other;
            return Intrinsics.areEqual(this.events, track.events);
        }
    }
}

