/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.ArrayInputStream;
import org.wysko.kmidi.SmpteTimecode;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.event.ChannelPressureEvent;
import org.wysko.kmidi.midi.event.ControlChangeEvent;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.kmidi.midi.event.PitchWheelChangeEvent;
import org.wysko.kmidi.midi.event.PolyphonicKeyPressureEvent;
import org.wysko.kmidi.midi.event.ProgramEvent;
import org.wysko.kmidi.midi.event.SysexEvent;
import org.wysko.kmidi.util.BitwiseOperationsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader;", "", "()V", "readByteArray", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "bytes", "", "readDataByte", "", "data1", "stream", "Lorg/wysko/kmidi/ArrayInputStream;", "readHeader", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header;", "readMetaEvent", "Lorg/wysko/kmidi/midi/event/Event;", "time", "", "metaType", "readRemainingChunks", "", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "header", "readTwoDataBytes", "Lkotlin/Pair;", "kmidi"})
public final class StandardMidiFileReader {
    @NotNull
    public static final StandardMidiFileReader INSTANCE = new StandardMidiFileReader();

    private StandardMidiFileReader() {
    }

    @NotNull
    public final StandardMidiFile readByteArray(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ArrayInputStream stream = new ArrayInputStream(bytes);
        StandardMidiFile.Header header = this.readHeader(stream);
        List<StandardMidiFile.Track> tracks = this.readRemainingChunks(stream, header);
        return new StandardMidiFile(header, tracks);
    }

    private final StandardMidiFile.Header readHeader(ArrayInputStream stream) {
        String chunkType = StringsKt.decodeToString((byte[])stream.readNBytes(4));
        if (!Intrinsics.areEqual((Object)chunkType, (Object)"MThd")) {
            boolean $i$a$-require-StandardMidiFileReader$readHeader$42 = false;
            String $i$a$-require-StandardMidiFileReader$readHeader$42 = "Invalid header chunk type: " + chunkType;
            throw new IllegalArgumentException($i$a$-require-StandardMidiFileReader$readHeader$42.toString());
        }
        int length = stream.readDWord();
        if (!(length >= 6)) {
            boolean $i$a$-require-StandardMidiFileReader$readHeader$52 = false;
            String $i$a$-require-StandardMidiFileReader$readHeader$52 = "Invalid header length: " + length;
            throw new IllegalArgumentException($i$a$-require-StandardMidiFileReader$readHeader$52.toString());
        }
        short format = stream.readWord();
        short $i$a$-require-StandardMidiFileReader$readHeader$52 = format;
        if (!(0 <= $i$a$-require-StandardMidiFileReader$readHeader$52 ? $i$a$-require-StandardMidiFileReader$readHeader$52 < 3 : false)) {
            boolean $i$a$-require-StandardMidiFileReader$readHeader$62 = false;
            String $i$a$-require-StandardMidiFileReader$readHeader$62 = "Invalid SMF format value: " + format;
            throw new IllegalArgumentException($i$a$-require-StandardMidiFileReader$readHeader$62.toString());
        }
        short trackCount = stream.readWord();
        short timeDivision = stream.readWord();
        StandardMidiFile.Header.Division division = (short)(timeDivision & Short.MIN_VALUE) == 0 ? (StandardMidiFile.Header.Division)new StandardMidiFile.Header.Division.MetricalTime(timeDivision) : (StandardMidiFile.Header.Division)new StandardMidiFile.Header.Division.TimecodeBasedTime(BitwiseOperationsKt.shr((short)(timeDivision & 0x7F00), 8), (short)(timeDivision & 0xFF));
        stream.skip(length - 6);
        return new StandardMidiFile.Header(chunkType, StandardMidiFile.Header.Format.Companion.fromValue(format), trackCount, division);
    }

    private final List<StandardMidiFile.Track> readRemainingChunks(ArrayInputStream stream, StandardMidiFile.Header header) {
        List tracks = new ArrayList();
        int n = header.getTrackCount();
        for (int i = 0; i < n; ++i) {
            int startingPosition;
            int it = i;
            boolean bl = false;
            String trackType = StringsKt.decodeToString((byte[])stream.readNBytes(4));
            int trackLength = stream.readDWord();
            if (!Intrinsics.areEqual((Object)trackType, (Object)"MTrk")) {
                stream.skip(trackLength);
                continue;
            }
            int time = 0;
            byte prefix = 0;
            List events = new ArrayList();
            for (int bytesRead = 0; bytesRead < trackLength; bytesRead += stream.getPosition() - startingPosition) {
                startingPosition = stream.getPosition();
                byte data1 = -1;
                byte data2 = 0;
                int deltaTime = ((Number)stream.readVlq().component1()).intValue();
                time += deltaTime;
                byte statusByte = stream.read();
                if ((byte)(statusByte & 0xFFFFFF80) != 0) {
                    prefix = statusByte;
                } else {
                    data1 = statusByte;
                }
                byte status = (byte)(prefix & 0xFFFFFFF0);
                byte channel = (byte)(prefix & 0xF);
                if (status == -128) {
                    data1 = INSTANCE.readDataByte(data1, stream);
                    stream.read();
                    ((Collection)events).add(new NoteEvent.NoteOff(time, channel, data1));
                    continue;
                }
                if (status == -112) {
                    Pair<Byte, Byte> bytes = INSTANCE.readTwoDataBytes(data1, stream);
                    data1 = ((Number)bytes.getFirst()).byteValue();
                    data2 = ((Number)bytes.getSecond()).byteValue();
                    if (data2 == 0) {
                        ((Collection)events).add(new NoteEvent.NoteOff(time, channel, data1));
                        continue;
                    }
                    ((Collection)events).add(new NoteEvent.NoteOn(time, channel, data1, data2));
                    continue;
                }
                if (status == -96) {
                    Pair<Byte, Byte> bytes = INSTANCE.readTwoDataBytes(data1, stream);
                    data1 = ((Number)bytes.getFirst()).byteValue();
                    data2 = ((Number)bytes.getSecond()).byteValue();
                    ((Collection)events).add(new PolyphonicKeyPressureEvent(time, channel, data1, data2));
                    continue;
                }
                if (status == -80) {
                    Pair<Byte, Byte> bytes = INSTANCE.readTwoDataBytes(data1, stream);
                    data1 = ((Number)bytes.getFirst()).byteValue();
                    data2 = ((Number)bytes.getSecond()).byteValue();
                    ((Collection)events).add(new ControlChangeEvent(time, channel, data1, data2));
                    continue;
                }
                if (status == -64) {
                    data1 = INSTANCE.readDataByte(data1, stream);
                    ((Collection)events).add(new ProgramEvent(time, channel, data1));
                    continue;
                }
                if (status == -48) {
                    data1 = INSTANCE.readDataByte(data1, stream);
                    ((Collection)events).add(new ChannelPressureEvent(time, channel, data1));
                    continue;
                }
                if (status == -32) {
                    Pair<Byte, Byte> bytes = INSTANCE.readTwoDataBytes(data1, stream);
                    data1 = ((Number)bytes.getFirst()).byteValue();
                    data2 = ((Number)bytes.getSecond()).byteValue();
                    ((Collection)events).add(new PitchWheelChangeEvent(time, channel, (short)(BitwiseOperationsKt.shl((short)data2, 7) | (short)data1)));
                    continue;
                }
                if (status == -16 && (prefix == -16 || prefix == -9)) {
                    int length = ((Number)stream.readVlq().component1()).intValue();
                    byte[] message = stream.readNBytes(length);
                    ((Collection)events).add(new SysexEvent(time, message));
                    continue;
                }
                if (status != -16 || prefix != -1) continue;
                byte metaType = stream.read();
                Event metaEvent = INSTANCE.readMetaEvent(stream, time, metaType);
                ((Collection)events).add(metaEvent);
            }
            ((Collection)tracks).add(new StandardMidiFile.Track(events));
        }
        return tracks;
    }

    private final Pair<Byte, Byte> readTwoDataBytes(byte data1, ArrayInputStream stream) {
        return data1 == -1 ? new Pair((Object)stream.read(), (Object)stream.read()) : new Pair((Object)data1, (Object)stream.read());
    }

    private final byte readDataByte(byte data1, ArrayInputStream stream) {
        return data1 == -1 ? stream.read() : data1;
    }

    private final Event readMetaEvent(ArrayInputStream stream, int time, byte metaType) {
        Event event;
        byte by = metaType;
        if (by == 0) {
            stream.readVlq();
            byte high = stream.read();
            byte low = stream.read();
            short sequenceNumber = (short)((short)BitwiseOperationsKt.shl(high, 8) | (short)low);
            event = new MetaEvent.SequenceNumber(sequenceNumber);
        } else if (by == 1) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.Text(time, text);
        } else if (by == 2) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.CopyrightNotice(text);
        } else if (by == 3) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.SequenceTrackName(text);
        } else if (by == 4) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.InstrumentName(text);
        } else if (by == 5) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.Lyric(time, text);
        } else if (by == 6) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.Marker(time, text);
        } else if (by == 7) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.CuePoint(time, text);
        } else if (by == 32) {
            stream.readVlq();
            byte channel = stream.read();
            event = new MetaEvent.ChannelPrefix(time, channel);
        } else if (by == 47) {
            stream.readVlq();
            event = new MetaEvent.EndOfTrack(time);
        } else if (by == 81) {
            stream.readVlq();
            int tempo = stream.read24BitInt();
            event = new MetaEvent.SetTempo(time, tempo);
        } else if (by == 84) {
            stream.readVlq();
            byte hour = stream.read();
            byte minute = stream.read();
            byte second = stream.read();
            byte frame = stream.read();
            byte subFrame = stream.read();
            SmpteTimecode timecode = new SmpteTimecode(hour, minute, second, frame, subFrame);
            event = new MetaEvent.SmpteOffset(timecode);
        } else if (by == 89) {
            stream.readVlq();
            byte key = stream.read();
            byte scale = stream.read();
            event = new MetaEvent.KeySignature(time, MetaEvent.KeySignature.Key.Companion.fromValue(key), MetaEvent.KeySignature.Scale.Companion.fromValue(scale));
        } else if (by == 88) {
            stream.readVlq();
            byte numerator = stream.read();
            byte denominator = stream.read();
            byte clocksInMetronomeClick = stream.read();
            byte thirtySecondNotesInMidiQuarterNote = stream.read();
            event = new MetaEvent.TimeSignature(time, numerator, denominator, clocksInMetronomeClick, thirtySecondNotesInMidiQuarterNote);
        } else if (by == 127) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            byte[] data = stream.readNBytes(length);
            event = new MetaEvent.SequencerSpecific(time, data);
        } else {
            int length = ((Number)stream.readVlq().component1()).intValue();
            byte[] bytes = stream.readNBytes(length);
            event = new MetaEvent.Unknown(time, metaType, bytes);
        }
        return event;
    }
}

