/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.event.NoteEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J.\u0010\b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0014\u0010\f\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\r"}, d2={"Lorg/wysko/kmidi/midi/analysis/Polyphony;", "", "()V", "averagePolyphony", "", "noteEvents", "", "Lorg/wysko/kmidi/midi/event/NoteEvent;", "buildPolyphonyIndex", "", "Lkotlin/Pair;", "", "calculateMaximumPolyphony", "kmidi"})
@SourceDebugExtension(value={"SMAP\nPolyphony.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polyphony.kt\norg/wysko/kmidi/midi/analysis/Polyphony\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n125#2:61\n152#2,3:62\n1#3:65\n1045#4:66\n*S KotlinDebug\n*F\n+ 1 Polyphony.kt\norg/wysko/kmidi/midi/analysis/Polyphony\n*L\n34#1:61\n34#1:62,3\n43#1:66\n*E\n"})
public final class Polyphony {
    @NotNull
    public static final Polyphony INSTANCE = new Polyphony();

    private Polyphony() {
    }

    public final int calculateMaximumPolyphony(@NotNull List<? extends NoteEvent> noteEvents) {
        Intrinsics.checkNotNullParameter(noteEvents, (String)"noteEvents");
        Map<Pair<Integer, Integer>, Integer> polyphonyIndex = this.buildPolyphonyIndex(noteEvents);
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)polyphonyIndex.values());
        return n != null ? n : 0;
    }

    /*
     * WARNING - void declaration
     */
    public final double averagePolyphony(@NotNull List<? extends NoteEvent> noteEvents) {
        void $this$mapTo$iv$iv;
        Map<Pair<Integer, Integer>, Integer> polyphonyIndex;
        Intrinsics.checkNotNullParameter(noteEvents, (String)"noteEvents");
        Map<Pair<Integer, Integer>, Integer> $this$map$iv = polyphonyIndex = this.buildPolyphonyIndex(noteEvents);
        boolean $i$f$map = false;
        Map<Pair<Integer, Integer>, Integer> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Pair pair = $this$mapTo$iv$iv.entrySet().iterator();
        while (pair.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = pair.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair time = (Pair)entry.getKey();
            int polyphony = ((Number)entry.getValue()).intValue();
            int duration = ((Number)time.getSecond()).intValue() - ((Number)time.getFirst()).intValue();
            collection.add(polyphony * duration);
        }
        List polyphonyTicks = (List)destination$iv$iv;
        Iterable iterable = polyphonyIndex.keySet();
        int n = 0;
        for (Object t : iterable) {
            void it;
            pair = (Pair)t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((Number)it.getSecond()).intValue() - ((Number)it.getFirst()).intValue();
            n = n2 + n3;
        }
        int totalSeconds = n;
        return (double)CollectionsKt.sumOfInt((Iterable)polyphonyTicks) / (double)totalSeconds;
    }

    private final Map<Pair<Integer, Integer>, Integer> buildPolyphonyIndex(List<? extends NoteEvent> noteEvents) {
        Iterable $this$sortedBy$iv = noteEvents;
        boolean $i$f$sortedBy = false;
        List events = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NoteEvent it = (NoteEvent)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTick());
                it = (NoteEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTick()));
            }
        });
        Map polyphonyIndex = new LinkedHashMap();
        int polyphony = 0;
        int lastTime = ((NoteEvent)CollectionsKt.first((List)events)).getTick();
        for (NoteEvent event : events) {
            Integer n = polyphony;
            polyphonyIndex.put(TuplesKt.to((Object)lastTime, (Object)event.getTick()), n);
            NoteEvent noteEvent = event;
            if (noteEvent instanceof NoteEvent.NoteOn) {
                ++polyphony;
            } else if (noteEvent instanceof NoteEvent.NoteOff) {
                --polyphony;
            }
            lastTime = event.getTick();
        }
        return polyphonyIndex;
    }
}

