/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.ArrayInputStreamKt;
import org.wysko.kmidi.midi.reader.UnexpectedEndOfFileException;
import org.wysko.kmidi.util.BitwiseOperationsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/wysko/kmidi/ArrayInputStream;", "", "bytes", "", "([B)V", "available", "", "getAvailable", "()I", "<set-?>", "position", "getPosition", "read", "", "read24BitInt", "readDWord", "readNBytes", "n", "readVlq", "Lkotlin/Pair;", "readWord", "", "skip", "", "kmidi"})
public final class ArrayInputStream {
    @NotNull
    private final byte[] bytes;
    private int position;

    public ArrayInputStream(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    public final int getPosition() {
        return this.position;
    }

    public final int getAvailable() {
        return this.bytes.length - this.position;
    }

    public final byte read() {
        if (this.position >= this.bytes.length) {
            throw new UnexpectedEndOfFileException();
        }
        int n = this.position;
        this.position = n + 1;
        return this.bytes[n];
    }

    public final short readWord() {
        return ArrayInputStreamKt.access$or(BitwiseOperationsKt.shl((short)this.read(), 8), this.read());
    }

    public final int readDWord() {
        byte[] it = this.readNBytes(4);
        boolean bl = false;
        return (it[0] & 0xFF) << 24 | (it[1] & 0xFF) << 16 | (it[2] & 0xFF) << 8 | it[3] & 0xFF;
    }

    @NotNull
    public final byte[] readNBytes(int n) {
        byte[] array = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            array[it] = this.read();
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> readVlq() {
        int value = 0;
        byte by = 0;
        int start = this.position;
        do {
            by = this.read();
            value = value << 7 | (byte)(by & 0x7F);
        } while ((byte)(by & 0xFFFFFF80) != 0);
        return TuplesKt.to((Object)value, (Object)(this.position - start));
    }

    public final void skip(int n) {
        if (this.position + n > this.bytes.length) {
            throw new IndexOutOfBoundsException("Cannot skip " + n + " bytes: only " + (this.bytes.length - this.position) + " bytes remaining");
        }
        this.position += n;
    }

    public final int read24BitInt() {
        byte[] bytes = this.readNBytes(3);
        int i = (bytes[0] & 0xFF) << 16;
        int j = (bytes[1] & 0xFF) << 8;
        int k = bytes[2] & 0xFF;
        return i | j | k;
    }
}

