/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi.builder;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/wysko/kmidi/midi/builder/Note;", "", "note", "", "duration", "velocity", "(III)V", "getDuration", "()I", "getNote", "getVelocity", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "kmidi"})
public final class Note {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int note;
    private final int duration;
    private final int velocity;
    @NotNull
    private static final Map<String, Integer> notes;
    @NotNull
    private static final Regex noteRegex;

    public Note(int note, int duration, int velocity) {
        this.note = note;
        this.duration = duration;
        this.velocity = velocity;
    }

    public /* synthetic */ Note(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n3 = 100;
        }
        this(n, n2, n3);
    }

    public final int getNote() {
        return this.note;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getVelocity() {
        return this.velocity;
    }

    public final int component1() {
        return this.note;
    }

    public final int component2() {
        return this.duration;
    }

    public final int component3() {
        return this.velocity;
    }

    @NotNull
    public final Note copy(int note, int duration, int velocity) {
        return new Note(note, duration, velocity);
    }

    public static /* synthetic */ Note copy$default(Note note, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = note.note;
        }
        if ((n4 & 2) != 0) {
            n2 = note.duration;
        }
        if ((n4 & 4) != 0) {
            n3 = note.velocity;
        }
        return note.copy(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "Note(note=" + this.note + ", duration=" + this.duration + ", velocity=" + this.velocity + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.note);
        result = result * 31 + Integer.hashCode(this.duration);
        result = result * 31 + Integer.hashCode(this.velocity);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Note)) {
            return false;
        }
        Note note = (Note)other;
        if (this.note != note.note) {
            return false;
        }
        if (this.duration != note.duration) {
            return false;
        }
        return this.velocity == note.velocity;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"C", (Object)0), TuplesKt.to((Object)"D", (Object)2), TuplesKt.to((Object)"E", (Object)4), TuplesKt.to((Object)"F", (Object)5), TuplesKt.to((Object)"G", (Object)7), TuplesKt.to((Object)"A", (Object)9), TuplesKt.to((Object)"B", (Object)11)};
        notes = MapsKt.mapOf((Pair[])pairArray);
        noteRegex = new Regex("([A-G])([#b]?)(-?\\d)");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/builder/Note$Companion;", "", "()V", "noteRegex", "Lkotlin/text/Regex;", "notes", "", "", "", "get", "note", "kmidi"})
    @SourceDebugExtension(value={"SMAP\nNote.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Note.kt\norg/wysko/kmidi/midi/builder/Note$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int get(@NotNull String note) {
            int octaveValue;
            String string;
            int accidentalValue;
            Intrinsics.checkNotNullParameter((Object)note, (String)"note");
            MatchResult matchResult = noteRegex.matchEntire((CharSequence)note);
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid note: " + note);
            }
            MatchResult match = matchResult;
            MatchResult.Destructured destructured = match.getDestructured();
            String letter = (String)destructured.getMatch().getGroupValues().get(1);
            String accidental = (String)destructured.getMatch().getGroupValues().get(2);
            String octave = (String)destructured.getMatch().getGroupValues().get(3);
            int noteValue = ((Number)MapsKt.getValue((Map)notes, (Object)letter)).intValue();
            int midiNote = noteValue + (accidentalValue = Intrinsics.areEqual((Object)(string = accidental), (Object)"#") ? 1 : (Intrinsics.areEqual((Object)string, (Object)"b") ? -1 : 0)) + (octaveValue = Integer.parseInt(octave) * 12);
            if (!(0 <= midiNote ? midiNote < 128 : false)) {
                boolean bl = false;
                String string2 = "Invalid MIDI note: " + note + " (" + midiNote + ')';
                throw new IllegalArgumentException(string2.toString());
            }
            return midiNote;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

