/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi.reader;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.ArrayInputStream;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.reader.HeaderDetails;
import org.wysko.kmidi.midi.reader.InvalidHeaderException;
import org.wysko.kmidi.util.BitwiseOperationsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0006J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileHeaderReader;", "", "stream", "Lorg/wysko/kmidi/ArrayInputStream;", "(Lorg/wysko/kmidi/ArrayInputStream;)V", "buildHeader", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header;", "chunkType", "", "format", "", "trackCount", "division", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "determineTimeDivision", "timeDivision", "parseMidiFileHeader", "Lorg/wysko/kmidi/midi/reader/HeaderDetails;", "readHeader", "validateHeader", "", "length", "", "kmidi"})
public final class StandardMidiFileHeaderReader {
    @NotNull
    private final ArrayInputStream stream;

    public StandardMidiFileHeaderReader(@NotNull ArrayInputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
    }

    @NotNull
    public final StandardMidiFile.Header readHeader() {
        HeaderDetails $this$readHeader_u24lambda_u240 = this.parseMidiFileHeader();
        boolean bl = false;
        this.validateHeader($this$readHeader_u24lambda_u240.getChunkType(), $this$readHeader_u24lambda_u240.getLength(), $this$readHeader_u24lambda_u240.getFormat());
        StandardMidiFile.Header.Division division = this.determineTimeDivision($this$readHeader_u24lambda_u240.getTimeDivision());
        this.stream.skip($this$readHeader_u24lambda_u240.getLength() - 6);
        return this.buildHeader($this$readHeader_u24lambda_u240.getChunkType(), $this$readHeader_u24lambda_u240.getFormat(), $this$readHeader_u24lambda_u240.getTrackCount(), division);
    }

    private final HeaderDetails parseMidiFileHeader() {
        String chunkType = StringsKt.decodeToString((byte[])this.stream.readNBytes(4));
        int length = this.stream.readDWord();
        short format = this.stream.readWord();
        short trackCount = this.stream.readWord();
        short timeDivision = this.stream.readWord();
        return new HeaderDetails(chunkType, length, format, trackCount, timeDivision);
    }

    private final void validateHeader(String chunkType, int length, short format) {
        if (!Intrinsics.areEqual((Object)chunkType, (Object)"MThd")) {
            throw new InvalidHeaderException(InvalidHeaderException.HeaderExceptionType.MissingHeader.INSTANCE);
        }
        if (length < 6) {
            throw new InvalidHeaderException(new InvalidHeaderException.HeaderExceptionType.InvalidHeaderLength(length));
        }
        short s = format;
        if (!(0 <= s ? s < 3 : false)) {
            throw new InvalidHeaderException(new InvalidHeaderException.HeaderExceptionType.InvalidFormat(format));
        }
    }

    private final StandardMidiFile.Header.Division determineTimeDivision(short timeDivision) {
        return (short)(timeDivision & Short.MIN_VALUE) == 0 ? (StandardMidiFile.Header.Division)new StandardMidiFile.Header.Division.MetricalTime(timeDivision) : (StandardMidiFile.Header.Division)new StandardMidiFile.Header.Division.TimecodeBasedTime(BitwiseOperationsKt.shr((short)(timeDivision & 0xFFFFFF00), 8), (short)(timeDivision & 0xFF));
    }

    private final StandardMidiFile.Header buildHeader(String chunkType, short format, short trackCount, StandardMidiFile.Header.Division division) {
        return new StandardMidiFile.Header(chunkType, StandardMidiFile.Header.Format.Companion.fromValue(format), trackCount, division);
    }
}

