/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.event.ChannelPressureEvent;
import org.wysko.kmidi.midi.event.ControlChangeEvent;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.kmidi.midi.event.PitchWheelChangeEvent;
import org.wysko.kmidi.midi.event.PolyphonicKeyPressureEvent;
import org.wysko.kmidi.midi.event.ProgramEvent;
import org.wysko.kmidi.midi.event.SysexEvent;
import org.wysko.kmidi.util.BitwiseOperationsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileWriter;", "", "()V", "buildChunk", "", "", "chunkType", "", "data", "int24ToBytes", "value", "", "int32ToBytes", "intToVlq", "short16ToBytes", "", "write", "", "smf", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "writeHeader", "writeMetaEvent", "event", "Lorg/wysko/kmidi/midi/event/MetaEvent;", "writeSysexEvent", "Lorg/wysko/kmidi/midi/event/SysexEvent;", "writeTrack", "track", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "kmidi"})
@SourceDebugExtension(value={"SMAP\nStandardMidiFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardMidiFileWriter.kt\norg/wysko/kmidi/midi/StandardMidiFileWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n1855#2,2:257\n*S KotlinDebug\n*F\n+ 1 StandardMidiFileWriter.kt\norg/wysko/kmidi/midi/StandardMidiFileWriter\n*L\n39#1:257,2\n*E\n"})
public final class StandardMidiFileWriter {
    @NotNull
    public final byte[] write(@NotNull StandardMidiFile smf) {
        List list;
        Intrinsics.checkNotNullParameter((Object)smf, (String)"smf");
        List $this$write_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$write_u24lambda_u241.addAll((Collection)this.writeHeader(smf));
        Iterable $this$forEach$iv = smf.getTracks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StandardMidiFile.Track it = (StandardMidiFile.Track)element$iv;
            boolean bl2 = false;
            $this$write_u24lambda_u241.addAll((Collection)this.writeTrack(it));
        }
        return CollectionsKt.toByteArray((Collection)CollectionsKt.build((List)list));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Byte> writeHeader(StandardMidiFile smf) {
        List<Byte> list;
        void $this$writeHeader_u24lambda_u243;
        List list2;
        List list3 = list2 = CollectionsKt.createListBuilder();
        String string = smf.getHeader().getChunkType();
        StandardMidiFileWriter standardMidiFileWriter = this;
        boolean bl = false;
        $this$writeHeader_u24lambda_u243.addAll((Collection)this.short16ToBytes(switch (WhenMappings.$EnumSwitchMapping$0[smf.getHeader().getFormat().ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            default -> throw new NoWhenBranchMatchedException();
        }));
        $this$writeHeader_u24lambda_u243.addAll((Collection)this.short16ToBytes(smf.getHeader().getTrackCount()));
        StandardMidiFile.Header.Division $this$writeHeader_u24lambda_u243_u24lambda_u242 = smf.getHeader().getDivision();
        boolean bl2 = false;
        StandardMidiFile.Header.Division division = $this$writeHeader_u24lambda_u243_u24lambda_u242;
        if (division instanceof StandardMidiFile.Header.Division.MetricalTime) {
            list = this.short16ToBytes($this$writeHeader_u24lambda_u243_u24lambda_u242.getTicksPerQuarterNote());
        } else if (division instanceof StandardMidiFile.Header.Division.TimecodeBasedTime) {
            list = this.short16ToBytes((short)(BitwiseOperationsKt.shl(((StandardMidiFile.Header.Division.TimecodeBasedTime)$this$writeHeader_u24lambda_u243_u24lambda_u242).getFramesPerSecond(), 8) & ((StandardMidiFile.Header.Division.TimecodeBasedTime)$this$writeHeader_u24lambda_u243_u24lambda_u242).getTicksPerFrame()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$writeHeader_u24lambda_u243.addAll((Collection)list);
        Unit unit = Unit.INSTANCE;
        return standardMidiFileWriter.buildChunk(string, CollectionsKt.build((List)list2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Byte> writeTrack(StandardMidiFile.Track track) {
        List list;
        List list2 = list = CollectionsKt.createListBuilder();
        String string = "MTrk";
        StandardMidiFileWriter standardMidiFileWriter = this;
        boolean bl = false;
        Ref.ByteRef runningStatus = new Ref.ByteRef();
        int lastTick = 0;
        for (Event event : track.getEvents()) {
            void $this$writeTrack_u24lambda_u244;
            $this$writeTrack_u24lambda_u244.addAll((Collection)this.intToVlq(event.getTick() - lastTick));
            Event event2 = event;
            if (event2 instanceof MetaEvent) {
                $this$writeTrack_u24lambda_u244.addAll((Collection)this.writeMetaEvent((MetaEvent)event));
                runningStatus.element = 0;
            } else if (event2 instanceof SysexEvent) {
                $this$writeTrack_u24lambda_u244.addAll((Collection)this.writeSysexEvent((SysexEvent)event));
                runningStatus.element = 0;
            } else if (event2 instanceof ChannelPressureEvent) {
                StandardMidiFileWriter.writeTrack$lambda$4$writeWithRunningStatus(runningStatus, (List<Byte>)$this$writeTrack_u24lambda_u244, (byte)(0xFFFFFFD0 | ((ChannelPressureEvent)event).getChannel()), (Function0<Unit>)((Function0)new Function0<Unit>((List<Byte>)$this$writeTrack_u24lambda_u244, event){
                    final /* synthetic */ List<Byte> $this_buildList;
                    final /* synthetic */ Event $event;
                    {
                        this.$this_buildList = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_buildList.add(((ChannelPressureEvent)this.$event).getPressure());
                    }
                }));
            } else if (event2 instanceof ControlChangeEvent) {
                StandardMidiFileWriter.writeTrack$lambda$4$writeWithRunningStatus(runningStatus, (List<Byte>)$this$writeTrack_u24lambda_u244, (byte)(0xFFFFFFB0 | ((ControlChangeEvent)event).getChannel()), (Function0<Unit>)((Function0)new Function0<Unit>((List<Byte>)$this$writeTrack_u24lambda_u244, event){
                    final /* synthetic */ List<Byte> $this_buildList;
                    final /* synthetic */ Event $event;
                    {
                        this.$this_buildList = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_buildList.add(((ControlChangeEvent)this.$event).getController());
                        this.$this_buildList.add(((ControlChangeEvent)this.$event).getValue());
                    }
                }));
            } else if (event2 instanceof NoteEvent.NoteOff) {
                StandardMidiFileWriter.writeTrack$lambda$4$writeWithRunningStatus(runningStatus, (List<Byte>)$this$writeTrack_u24lambda_u244, (byte)(0xFFFFFF80 | ((NoteEvent.NoteOff)event).getChannel()), (Function0<Unit>)((Function0)new Function0<Unit>((List<Byte>)$this$writeTrack_u24lambda_u244, event){
                    final /* synthetic */ List<Byte> $this_buildList;
                    final /* synthetic */ Event $event;
                    {
                        this.$this_buildList = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_buildList.add(((NoteEvent.NoteOff)this.$event).getNote());
                        this.$this_buildList.add(((NoteEvent.NoteOff)this.$event).getVelocity());
                    }
                }));
            } else if (event2 instanceof NoteEvent.NoteOn) {
                StandardMidiFileWriter.writeTrack$lambda$4$writeWithRunningStatus(runningStatus, (List<Byte>)$this$writeTrack_u24lambda_u244, (byte)(0xFFFFFF90 | ((NoteEvent.NoteOn)event).getChannel()), (Function0<Unit>)((Function0)new Function0<Unit>((List<Byte>)$this$writeTrack_u24lambda_u244, event){
                    final /* synthetic */ List<Byte> $this_buildList;
                    final /* synthetic */ Event $event;
                    {
                        this.$this_buildList = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_buildList.add(((NoteEvent.NoteOn)this.$event).getNote());
                        this.$this_buildList.add(((NoteEvent.NoteOn)this.$event).getVelocity());
                    }
                }));
            } else if (event2 instanceof PitchWheelChangeEvent) {
                StandardMidiFileWriter.writeTrack$lambda$4$writeWithRunningStatus(runningStatus, (List<Byte>)$this$writeTrack_u24lambda_u244, (byte)(0xFFFFFFE0 | ((PitchWheelChangeEvent)event).getChannel()), (Function0<Unit>)((Function0)new Function0<Unit>((List<Byte>)$this$writeTrack_u24lambda_u244, event){
                    final /* synthetic */ List<Byte> $this_buildList;
                    final /* synthetic */ Event $event;
                    {
                        this.$this_buildList = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_buildList.add((byte)(((PitchWheelChangeEvent)this.$event).getValue() & 0x7F));
                        this.$this_buildList.add((byte)(BitwiseOperationsKt.shr(((PitchWheelChangeEvent)this.$event).getValue(), 7) & 0x7F));
                    }
                }));
            } else if (event2 instanceof PolyphonicKeyPressureEvent) {
                StandardMidiFileWriter.writeTrack$lambda$4$writeWithRunningStatus(runningStatus, (List<Byte>)$this$writeTrack_u24lambda_u244, (byte)(0xFFFFFFA0 | ((PolyphonicKeyPressureEvent)event).getChannel()), (Function0<Unit>)((Function0)new Function0<Unit>((List<Byte>)$this$writeTrack_u24lambda_u244, event){
                    final /* synthetic */ List<Byte> $this_buildList;
                    final /* synthetic */ Event $event;
                    {
                        this.$this_buildList = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_buildList.add(((PolyphonicKeyPressureEvent)this.$event).getNote());
                        this.$this_buildList.add(((PolyphonicKeyPressureEvent)this.$event).getPressure());
                    }
                }));
            } else if (event2 instanceof ProgramEvent) {
                StandardMidiFileWriter.writeTrack$lambda$4$writeWithRunningStatus(runningStatus, (List<Byte>)$this$writeTrack_u24lambda_u244, (byte)(0xFFFFFFC0 | ((ProgramEvent)event).getChannel()), (Function0<Unit>)((Function0)new Function0<Unit>((List<Byte>)$this$writeTrack_u24lambda_u244, event){
                    final /* synthetic */ List<Byte> $this_buildList;
                    final /* synthetic */ Event $event;
                    {
                        this.$this_buildList = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_buildList.add(((ProgramEvent)this.$event).getProgram());
                    }
                }));
            }
            lastTick = event.getTick();
        }
        Unit unit = Unit.INSTANCE;
        return standardMidiFileWriter.buildChunk(string, CollectionsKt.build((List)list));
    }

    private final List<Byte> writeSysexEvent(SysexEvent event) {
        List list;
        List $this$writeSysexEvent_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$writeSysexEvent_u24lambda_u245.add((byte)-16);
        $this$writeSysexEvent_u24lambda_u245.addAll((Collection)this.intToVlq(event.getData().length));
        $this$writeSysexEvent_u24lambda_u245.addAll(ArraysKt.toList((byte[])event.getData()));
        return CollectionsKt.build((List)list);
    }

    private final List<Byte> writeMetaEvent(MetaEvent event) {
        Object[] objectArray;
        Object[] $this$writeMetaEvent_u24lambda_u246 = objectArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        MetaEvent metaEvent = event;
        if (metaEvent instanceof MetaEvent.Textual) {
            StandardMidiFileWriter.writeMetaEvent$lambda$6$writeTextualEvent((List<Byte>)$this$writeMetaEvent_u24lambda_u246, (MetaEvent.Textual)event);
        } else if (metaEvent instanceof MetaEvent.ChannelPrefix) {
            $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.ChannelPrefix)event).getChannel());
        } else if (!(metaEvent instanceof MetaEvent.EndOfTrack)) {
            if (metaEvent instanceof MetaEvent.KeySignature) {
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.KeySignature)event).getKey().getValue$kmidi());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.KeySignature)event).getScale().getValue$kmidi());
            } else if (metaEvent instanceof MetaEvent.SequenceNumber) {
                $this$writeMetaEvent_u24lambda_u246.addAll((Collection)this.short16ToBytes(((MetaEvent.SequenceNumber)event).getNumber()));
            } else if (metaEvent instanceof MetaEvent.SequencerSpecific) {
                $this$writeMetaEvent_u24lambda_u246.addAll((Collection)this.intToVlq(((MetaEvent.SequencerSpecific)event).getData().length));
                $this$writeMetaEvent_u24lambda_u246.addAll(ArraysKt.toList((byte[])((MetaEvent.SequencerSpecific)event).getData()));
            } else if (metaEvent instanceof MetaEvent.SetTempo) {
                $this$writeMetaEvent_u24lambda_u246.addAll((Collection)this.int24ToBytes(((MetaEvent.SetTempo)event).getTempo()));
            } else if (metaEvent instanceof MetaEvent.SmpteOffset) {
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.SmpteOffset)event).getTimecode().getHours());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.SmpteOffset)event).getTimecode().getMinutes());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.SmpteOffset)event).getTimecode().getSeconds());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.SmpteOffset)event).getTimecode().getFrames());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.SmpteOffset)event).getTimecode().getSubFrames());
            } else if (metaEvent instanceof MetaEvent.TimeSignature) {
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.TimeSignature)event).getNumerator());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.TimeSignature)event).getDenominator());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.TimeSignature)event).getClocksInMetronomeClick());
                $this$writeMetaEvent_u24lambda_u246.add(((MetaEvent.TimeSignature)event).getThirtySecondNotesInMidiQuarterNote());
            } else if (metaEvent instanceof MetaEvent.Unknown) {
                $this$writeMetaEvent_u24lambda_u246.addAll((Collection)this.intToVlq(((MetaEvent.Unknown)event).getData().length));
                $this$writeMetaEvent_u24lambda_u246.addAll(ArraysKt.toList((byte[])((MetaEvent.Unknown)event).getData()));
            }
        }
        List eventData = CollectionsKt.build((List)objectArray);
        objectArray = new Byte[]{(byte)-1, event.getType$kmidi()};
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)this.intToVlq(eventData.size())), (Iterable)eventData);
    }

    private final List<Byte> buildChunk(String chunkType, List<Byte> data) {
        String string = chunkType;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ArraysKt.toList((byte[])byArray), (Iterable)this.int32ToBytes(data.size())), (Iterable)data);
    }

    private final List<Byte> int24ToBytes(int value) {
        List bytes = new ArrayList();
        ((Collection)bytes).add((byte)(value >> 16));
        ((Collection)bytes).add((byte)(value >> 8));
        ((Collection)bytes).add((byte)value);
        return bytes;
    }

    private final List<Byte> int32ToBytes(int value) {
        List bytes = new ArrayList();
        ((Collection)bytes).add((byte)(value >> 24));
        ((Collection)bytes).add((byte)(value >> 16));
        ((Collection)bytes).add((byte)(value >> 8));
        ((Collection)bytes).add((byte)value);
        return bytes;
    }

    private final List<Byte> short16ToBytes(short value) {
        List bytes = new ArrayList();
        ((Collection)bytes).add((byte)BitwiseOperationsKt.shr(value, 8));
        ((Collection)bytes).add((byte)value);
        return bytes;
    }

    private final List<Byte> intToVlq(int value) {
        int buffer = value & 0x7F;
        List result = new ArrayList();
        for (int shiftValue = value >>> 7; shiftValue > 0; shiftValue >>>= 7) {
            buffer = buffer << 8 | 0x80;
            buffer += shiftValue & 0x7F;
        }
        while (true) {
            result.add((byte)(buffer & 0xFF));
            if ((buffer & 0x80) == 0) break;
            buffer >>>= 8;
        }
        return result;
    }

    private static final void writeTrack$lambda$4$writeWithRunningStatus(Ref.ByteRef runningStatus, List<Byte> $this_buildList, byte prefix, Function0<Unit> writeEventData) {
        if (prefix == runningStatus.element) {
            writeEventData.invoke();
        } else {
            $this_buildList.add(prefix);
            writeEventData.invoke();
            runningStatus.element = prefix;
        }
    }

    private static final boolean writeMetaEvent$lambda$6$writeTextualEvent(List<Byte> $this_buildList, MetaEvent.Textual event) {
        String string = event.getText();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return $this_buildList.addAll(ArraysKt.toList((byte[])byArray));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StandardMidiFile.Header.Format.values().length];
            try {
                nArray[StandardMidiFile.Header.Format.Format0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardMidiFile.Header.Format.Format1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardMidiFile.Header.Format.Format2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

