/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.SmpteTimecode;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.builder.Builder;
import org.wysko.kmidi.midi.builder.Note;
import org.wysko.kmidi.midi.event.ChannelPressureEvent;
import org.wysko.kmidi.midi.event.ControlChangeEvent;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.kmidi.midi.event.PitchWheelChangeEvent;
import org.wysko.kmidi.midi.event.PolyphonicKeyPressureEvent;
import org.wysko.kmidi.midi.event.ProgramEvent;
import org.wysko.kmidi.midi.event.SysexEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J!\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0002H\u0016J'\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u0016\u00a2\u0006\u0002\b\u0017J+\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0019J3\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J+\u0010!\u001a\u00020\f2\u0006\u0010!\u001a\u00020 2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\"J3\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\f2\u0006\u0010(\u001a\u00020 J3\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001eJ3\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010/J+\u00100\u001a\u00020\f2\u0006\u00100\u001a\u00020 2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\"J+\u00101\u001a\u00020\f2\u0006\u00101\u001a\u00020 2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\"J=\u0010\r\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\b\b\u0002\u00103\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00104J=\u0010\r\u001a\u00020\f2\u0006\u0010\r\u001a\u00020 2\u0006\u00102\u001a\u00020\u00072\b\b\u0002\u00103\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00105J+\u0010\r\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00106J1\u00107\u001a\u00020\f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000e082\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00109J+\u0010:\u001a\u00020\f2\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010<J+\u0010=\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u0007J+\u0010@\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010AJ\u000e\u0010B\u001a\u00020\f2\u0006\u0010B\u001a\u00020CJ+\u0010D\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010AJ+\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020G2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010HJ+\u0010I\u001a\u00020\f2\u0006\u0010I\u001a\u00020 2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\"JG\u0010J\u001a\u00020\f2\u0006\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u00072\n\b\u0002\u0010N\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010OR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/wysko/kmidi/midi/builder/TrackBuilder;", "Lorg/wysko/kmidi/midi/builder/Builder;", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "()V", "currentChannel", "", "currentTick", "", "events", "", "Lorg/wysko/kmidi/midi/event/Event;", "addNote", "", "note", "Lorg/wysko/kmidi/midi/builder/Note;", "adjustTime", "deltaTime", "absoluteTime", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "build", "channel", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "channelPrefix", "(ILjava/lang/Integer;Ljava/lang/Integer;)V", "channelPressure", "pressure", "controller", "value", "(IILjava/lang/Integer;Ljava/lang/Integer;)V", "copyrightNotice", "", "cuePoint", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "customMeta", "type", "data", "", "(I[BLjava/lang/Integer;Ljava/lang/Integer;)V", "instrumentName", "keyPressure", "keySignature", "key", "Lorg/wysko/kmidi/midi/event/MetaEvent$KeySignature$Key;", "scale", "Lorg/wysko/kmidi/midi/event/MetaEvent$KeySignature$Scale;", "(Lorg/wysko/kmidi/midi/event/MetaEvent$KeySignature$Key;Lorg/wysko/kmidi/midi/event/MetaEvent$KeySignature$Scale;Ljava/lang/Integer;Ljava/lang/Integer;)V", "lyric", "marker", "duration", "velocity", "(IIILjava/lang/Integer;Ljava/lang/Integer;)V", "(Ljava/lang/String;IILjava/lang/Integer;Ljava/lang/Integer;)V", "(Lorg/wysko/kmidi/midi/builder/Note;Ljava/lang/Integer;Ljava/lang/Integer;)V", "notes", "", "(Ljava/util/Set;Ljava/lang/Integer;Ljava/lang/Integer;)V", "pitch", "", "(DLjava/lang/Integer;Ljava/lang/Integer;)V", "program", "sequenceNumber", "number", "sequencerSpecific", "([BLjava/lang/Integer;Ljava/lang/Integer;)V", "smpteOffset", "Lorg/wysko/kmidi/SmpteTimecode;", "sysex", "tempo", "beatsPerMinute", "", "(Ljava/lang/Number;Ljava/lang/Integer;Ljava/lang/Integer;)V", "text", "timeSignature", "numerator", "denominator", "metronome", "thirtySeconds", "(IIILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "kmidi"})
@SourceDebugExtension(value={"SMAP\nTrackBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackBuilder.kt\norg/wysko/kmidi/midi/builder/TrackBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,670:1\n1#2:671\n1855#3,2:672\n*S KotlinDebug\n*F\n+ 1 TrackBuilder.kt\norg/wysko/kmidi/midi/builder/TrackBuilder\n*L\n135#1:672,2\n*E\n"})
public final class TrackBuilder
implements Builder<StandardMidiFile.Track> {
    @NotNull
    private final List<Event> events = new ArrayList();
    private byte currentChannel;
    private int currentTick;

    @Override
    @NotNull
    public StandardMidiFile.Track build() {
        int n;
        Iterable iterable = this.events;
        Collection collection = this.events;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Event it = (Event)iterator.next();
        boolean bl = false;
        int n2 = it.getTick();
        while (iterator.hasNext()) {
            Event it2 = (Event)iterator.next();
            $i$a$-maxOf-TrackBuilder$build$1 = false;
            int n3 = it2.getTick();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        int n4 = n = n2;
        List list = CollectionsKt.plus((Collection)collection, (Object)new MetaEvent.EndOfTrack(n4));
        return new StandardMidiFile.Track(list);
    }

    public final void note(int note, int duration, int velocity, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        this.addNote(new Note(note, duration, velocity));
    }

    public static /* synthetic */ void note$default(TrackBuilder trackBuilder, int n, int n2, int n3, Integer n4, Integer n5, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n3 = 100;
        }
        if ((n6 & 8) != 0) {
            n4 = null;
        }
        if ((n6 & 0x10) != 0) {
            n5 = null;
        }
        trackBuilder.note(n, n2, n3, n4, n5);
    }

    public final void note(@NotNull String note, int duration, int velocity, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        this.adjustTime(deltaTime, absoluteTime);
        this.addNote(new Note(Note.Companion.get(note), duration, velocity));
    }

    public static /* synthetic */ void note$default(TrackBuilder trackBuilder, String string, int n, int n2, Integer n3, Integer n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n2 = 100;
        }
        if ((n5 & 8) != 0) {
            n3 = null;
        }
        if ((n5 & 0x10) != 0) {
            n4 = null;
        }
        trackBuilder.note(string, n, n2, n3, n4);
    }

    public final void note(@NotNull Note note, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        this.adjustTime(deltaTime, absoluteTime);
        this.addNote(note);
    }

    public static /* synthetic */ void note$default(TrackBuilder trackBuilder, Note note, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.note(note, n, n2);
    }

    public final void notes(@NotNull Set<Note> notes, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter(notes, (String)"notes");
        this.adjustTime(deltaTime, absoluteTime);
        Iterable $this$forEach$iv = notes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Note it = (Note)element$iv;
            boolean bl = false;
            this.addNote(it);
        }
    }

    public static /* synthetic */ void notes$default(TrackBuilder trackBuilder, Set set, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.notes(set, n, n2);
    }

    public final void channel(int channel, @NotNull Function1<? super TrackBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        byte previousChannel = this.currentChannel;
        this.currentChannel = (byte)channel;
        init.invoke((Object)this);
        this.currentChannel = previousChannel;
    }

    public final void tempo(@NotNull Number beatsPerMinute, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)beatsPerMinute, (String)"beatsPerMinute");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.SetTempo(this.currentTick, (int)((double)60000000 / beatsPerMinute.doubleValue())));
    }

    public static /* synthetic */ void tempo$default(TrackBuilder trackBuilder, Number number, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.tempo(number, n, n2);
    }

    public final void program(int program, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new ProgramEvent(this.currentTick, this.currentChannel, (byte)program));
    }

    public static /* synthetic */ void program$default(TrackBuilder trackBuilder, int n, Integer n2, Integer n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = null;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        trackBuilder.program(n, n2, n3);
    }

    public final void channelPressure(int pressure, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new ChannelPressureEvent(this.currentTick, this.currentChannel, (byte)pressure));
    }

    public static /* synthetic */ void channelPressure$default(TrackBuilder trackBuilder, int n, Integer n2, Integer n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = null;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        trackBuilder.channelPressure(n, n2, n3);
    }

    public final void controller(int controller, int value, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new ControlChangeEvent(this.currentTick, this.currentChannel, (byte)controller, (byte)value));
    }

    public static /* synthetic */ void controller$default(TrackBuilder trackBuilder, int n, int n2, Integer n3, Integer n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n3 = null;
        }
        if ((n5 & 8) != 0) {
            n4 = null;
        }
        trackBuilder.controller(n, n2, n3, n4);
    }

    public final void pitch(double pitch, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new PitchWheelChangeEvent(this.currentTick, this.currentChannel, (short)(pitch * 8192.0 + 8192.0)));
    }

    public static /* synthetic */ void pitch$default(TrackBuilder trackBuilder, double d, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.pitch(d, n, n2);
    }

    public final void keyPressure(int note, int pressure, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new PolyphonicKeyPressureEvent(this.currentTick, this.currentChannel, (byte)note, (byte)pressure));
    }

    public static /* synthetic */ void keyPressure$default(TrackBuilder trackBuilder, int n, int n2, Integer n3, Integer n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n3 = null;
        }
        if ((n5 & 8) != 0) {
            n4 = null;
        }
        trackBuilder.keyPressure(n, n2, n3, n4);
    }

    public final void sysex(@NotNull byte[] data, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new SysexEvent(this.currentTick, data));
    }

    public static /* synthetic */ void sysex$default(TrackBuilder trackBuilder, byte[] byArray, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.sysex(byArray, n, n2);
    }

    public final void sequenceNumber(int number) {
        if (!(this.currentTick == 0)) {
            boolean bl = false;
            String string = "Sequence number must occur at the beginning of the track";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.events).add(new MetaEvent.SequenceNumber((short)number));
    }

    public final void copyrightNotice(@NotNull String copyrightNotice) {
        Intrinsics.checkNotNullParameter((Object)copyrightNotice, (String)"copyrightNotice");
        if (!(this.currentTick == 0)) {
            boolean bl = false;
            String string = "Copyright notice must occur at the beginning of the track";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.events).add(new MetaEvent.CopyrightNotice(copyrightNotice));
    }

    public final void instrumentName(@NotNull String instrumentName) {
        Intrinsics.checkNotNullParameter((Object)instrumentName, (String)"instrumentName");
        if (!(this.currentTick == 0)) {
            boolean bl = false;
            String string = "Instrument name must occur at the beginning of the track";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.events).add(new MetaEvent.InstrumentName(instrumentName));
    }

    public final void smpteOffset(@NotNull SmpteTimecode smpteOffset) {
        Intrinsics.checkNotNullParameter((Object)smpteOffset, (String)"smpteOffset");
        if (!(this.currentTick == 0)) {
            boolean bl = false;
            String string = "SMPTE offset must occur at the beginning of the track";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.events).add(new MetaEvent.SmpteOffset(smpteOffset));
    }

    public final void lyric(@NotNull String lyric, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)lyric, (String)"lyric");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.Lyric(this.currentTick, lyric));
    }

    public static /* synthetic */ void lyric$default(TrackBuilder trackBuilder, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.lyric(string, n, n2);
    }

    public final void marker(@NotNull String marker, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.Marker(this.currentTick, marker));
    }

    public static /* synthetic */ void marker$default(TrackBuilder trackBuilder, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.marker(string, n, n2);
    }

    public final void cuePoint(@NotNull String cuePoint, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)cuePoint, (String)"cuePoint");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.CuePoint(this.currentTick, cuePoint));
    }

    public static /* synthetic */ void cuePoint$default(TrackBuilder trackBuilder, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.cuePoint(string, n, n2);
    }

    public final void channelPrefix(int channel, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.ChannelPrefix(this.currentTick, (byte)channel));
    }

    public static /* synthetic */ void channelPrefix$default(TrackBuilder trackBuilder, int n, Integer n2, Integer n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = null;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        trackBuilder.channelPrefix(n, n2, n3);
    }

    public final void text(@NotNull String text, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.Text(this.currentTick, text));
    }

    public static /* synthetic */ void text$default(TrackBuilder trackBuilder, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.text(string, n, n2);
    }

    public final void timeSignature(int numerator, int denominator, int metronome, @Nullable Integer thirtySeconds, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        this.adjustTime(deltaTime, absoluteTime);
        Integer n = thirtySeconds;
        ((Collection)this.events).add(new MetaEvent.TimeSignature(this.currentTick, (byte)numerator, (byte)denominator, (byte)metronome, (byte)(n != null ? n : 8)));
    }

    public static /* synthetic */ void timeSignature$default(TrackBuilder trackBuilder, int n, int n2, int n3, Integer n4, Integer n5, Integer n6, int n7, Object object) {
        if ((n7 & 8) != 0) {
            n4 = 8;
        }
        if ((n7 & 0x10) != 0) {
            n5 = null;
        }
        if ((n7 & 0x20) != 0) {
            n6 = null;
        }
        trackBuilder.timeSignature(n, n2, n3, n4, n5, n6);
    }

    public final void keySignature(@NotNull MetaEvent.KeySignature.Key key, @NotNull MetaEvent.KeySignature.Scale scale, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.KeySignature(this.currentTick, key, scale));
    }

    public static /* synthetic */ void keySignature$default(TrackBuilder trackBuilder, MetaEvent.KeySignature.Key key, MetaEvent.KeySignature.Scale scale, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        trackBuilder.keySignature(key, scale, n, n2);
    }

    public final void sequencerSpecific(@NotNull byte[] data, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.SequencerSpecific(this.currentTick, data));
    }

    public static /* synthetic */ void sequencerSpecific$default(TrackBuilder trackBuilder, byte[] byArray, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        trackBuilder.sequencerSpecific(byArray, n, n2);
    }

    public final void customMeta(int type, @NotNull byte[] data, @Nullable Integer deltaTime, @Nullable Integer absoluteTime) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.adjustTime(deltaTime, absoluteTime);
        ((Collection)this.events).add(new MetaEvent.Unknown(this.currentTick, (byte)type, data));
    }

    public static /* synthetic */ void customMeta$default(TrackBuilder trackBuilder, int n, byte[] byArray, Integer n2, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = null;
        }
        if ((n4 & 8) != 0) {
            n3 = null;
        }
        trackBuilder.customMeta(n, byArray, n2, n3);
    }

    private final void addNote(Note note) {
        ((Collection)this.events).add(new NoteEvent.NoteOn(this.currentTick, this.currentChannel, (byte)note.getNote(), (byte)note.getVelocity()));
        this.currentTick += note.getDuration();
        ((Collection)this.events).add(new NoteEvent.NoteOff(this.currentTick, this.currentChannel, (byte)note.getNote(), 0));
    }

    private final void adjustTime(Integer deltaTime, Integer absoluteTime) {
        if (!(deltaTime == null || absoluteTime == null)) {
            boolean bl = false;
            String string = "Only one of deltaTime and absoluteTime can be specified";
            throw new IllegalArgumentException(string.toString());
        }
        if (deltaTime == null ^ absoluteTime == null) {
            if (deltaTime != null) {
                this.currentTick += deltaTime.intValue();
            } else if (absoluteTime != null) {
                this.currentTick = absoluteTime;
            }
        }
    }
}

