/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.ArrayInputStream;
import org.wysko.kmidi.SmpteTimecode;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.event.ChannelPressureEvent;
import org.wysko.kmidi.midi.event.ControlChangeEvent;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.kmidi.midi.event.PitchWheelChangeEvent;
import org.wysko.kmidi.midi.event.PolyphonicKeyPressureEvent;
import org.wysko.kmidi.midi.event.ProgramEvent;
import org.wysko.kmidi.midi.event.SysexEvent;
import org.wysko.kmidi.midi.reader.IncompleteMetaEventException;
import org.wysko.kmidi.midi.reader.StandardMidiFileReader;
import org.wysko.kmidi.midi.reader.StandardMidiFileReaderKt;
import org.wysko.kmidi.midi.reader.UnexpectedEndOfFileException;
import org.wysko.kmidi.util.BitwiseOperationsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileTracksReader;", "", "policies", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies;", "(Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies;)V", "readDataByte", "", "data1", "stream", "Lorg/wysko/kmidi/ArrayInputStream;", "readKeySignature", "Lorg/wysko/kmidi/midi/event/MetaEvent$KeySignature;", "time", "", "readMetaEvent", "Lorg/wysko/kmidi/midi/event/Event;", "metaType", "readMidiChannelPrefix", "Lorg/wysko/kmidi/midi/event/MetaEvent$ChannelPrefix;", "readRemainingChunks", "", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "header", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header;", "readRemainingChunks$kmidi", "readSequenceNumber", "Lorg/wysko/kmidi/midi/event/MetaEvent$SequenceNumber;", "readSmpteOffset", "Lorg/wysko/kmidi/midi/event/MetaEvent$SmpteOffset;", "readTempo", "Lorg/wysko/kmidi/midi/event/MetaEvent$SetTempo;", "readTimeSignature", "Lorg/wysko/kmidi/midi/event/MetaEvent$TimeSignature;", "readTwoDataBytes", "Lkotlin/Pair;", "kmidi"})
@SourceDebugExtension(value={"SMAP\nStandardMidiFileTracksReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardMidiFileTracksReader.kt\norg/wysko/kmidi/midi/reader/StandardMidiFileTracksReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n1#2:454\n*E\n"})
public final class StandardMidiFileTracksReader {
    @NotNull
    private final StandardMidiFileReader.Policies policies;

    public StandardMidiFileTracksReader(@NotNull StandardMidiFileReader.Policies policies) {
        Intrinsics.checkNotNullParameter((Object)policies, (String)"policies");
        this.policies = policies;
    }

    @NotNull
    public final List<StandardMidiFile.Track> readRemainingChunks$kmidi(@NotNull ArrayInputStream stream, @NotNull StandardMidiFile.Header header) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        List tracks = new ArrayList();
        int n = header.getTrackCount();
        for (int i = 0; i < n; ++i) {
            int time = 0;
            byte prefix = 0;
            List events = new ArrayList();
            try {
                int startingPosition;
                String trackType = StringsKt.decodeToString((byte[])stream.readNBytes(4));
                int trackLength = stream.readDWord();
                if (!Intrinsics.areEqual((Object)trackType, (Object)"MTrk")) {
                    stream.skip(trackLength);
                    continue;
                }
                for (int bytesRead = 0; bytesRead < trackLength; bytesRead += stream.getPosition() - startingPosition) {
                    boolean noMoreEventsAndPolicyAllows;
                    boolean isTrailingNullByte = trackLength - bytesRead == 1 && stream.read() == 0;
                    boolean bl = noMoreEventsAndPolicyAllows = stream.getAvailable() == 0 && Intrinsics.areEqual((Object)this.policies.getUnexpectedEndOfFilePolicy(), (Object)StandardMidiFileReader.Policies.UnexpectedEndOfFileExceptionPolicy.AllowClean.INSTANCE);
                    if (isTrailingNullByte || noMoreEventsAndPolicyAllows) break;
                    startingPosition = stream.getPosition();
                    byte data1 = -1;
                    byte data2 = 0;
                    int deltaTime = ((Number)stream.readVlq().component1()).intValue();
                    time += deltaTime;
                    byte lastPrefix = prefix;
                    byte statusByte = stream.read();
                    if ((byte)(statusByte & 0xFFFFFF80) != 0) {
                        prefix = statusByte;
                    } else {
                        data1 = statusByte;
                    }
                    byte status = (byte)(prefix & 0xFFFFFFF0);
                    byte channel = (byte)(prefix & 0xF);
                    if (status == -128) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        ((Collection)events).add(new NoteEvent.NoteOff(time, channel, data1, data2));
                        continue;
                    }
                    if (status == -112) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        if (this.policies.getCoerceVelocityToRange()) {
                            data2 = (byte)RangesKt.coerceIn((int)(UByte.constructor-impl((byte)data2) & 0xFF), (ClosedRange)((ClosedRange)StandardMidiFileReaderKt.getSEVEN_BIT_RANGE()));
                        }
                        if (data2 == 0) {
                            ((Collection)events).add(new NoteEvent.NoteOff(time, channel, data1, 0));
                            continue;
                        }
                        ((Collection)events).add(new NoteEvent.NoteOn(time, channel, data1, data2));
                        continue;
                    }
                    if (status == -96) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        ((Collection)events).add(new PolyphonicKeyPressureEvent(time, channel, data1, data2));
                        continue;
                    }
                    if (status == -80) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        ((Collection)events).add(new ControlChangeEvent(time, channel, data1, data2));
                        continue;
                    }
                    if (status == -64) {
                        data1 = this.readDataByte(data1, stream);
                        ((Collection)events).add(new ProgramEvent(time, channel, data1));
                        continue;
                    }
                    if (status == -48) {
                        data1 = this.readDataByte(data1, stream);
                        ((Collection)events).add(new ChannelPressureEvent(time, channel, data1));
                        continue;
                    }
                    if (status == -32) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        ((Collection)events).add(new PitchWheelChangeEvent(time, channel, (short)(BitwiseOperationsKt.shl((short)data2, 7) | (short)data1)));
                        continue;
                    }
                    if (status == -16 && (prefix == -16 || prefix == -9)) {
                        int length = ((Number)stream.readVlq().component1()).intValue();
                        byte[] message = stream.readNBytes(length);
                        ((Collection)events).add(new SysexEvent(time, message));
                        if (!this.policies.getAllowRunningStatusAcrossNonMidiEvents()) continue;
                        prefix = lastPrefix;
                        continue;
                    }
                    if (status != -16 || prefix != -1) continue;
                    byte metaType = stream.read();
                    if (this.readMetaEvent(stream, time, metaType) != null) {
                        Event it;
                        boolean bl2 = false;
                        ((Collection)events).add(it);
                    }
                    if (!this.policies.getAllowRunningStatusAcrossNonMidiEvents()) continue;
                    prefix = lastPrefix;
                }
                ((Collection)tracks).add(new StandardMidiFile.Track(events));
                continue;
            }
            catch (UnexpectedEndOfFileException e) {
                if (Intrinsics.areEqual((Object)this.policies.getUnexpectedEndOfFilePolicy(), (Object)StandardMidiFileReader.Policies.UnexpectedEndOfFileExceptionPolicy.AllowDirty.INSTANCE)) {
                    ((Collection)tracks).add(new StandardMidiFile.Track(events));
                    break;
                }
                throw e;
            }
        }
        if (this.policies.getAllowTrackCountDiscrepancy()) {
            int n2 = header.getTrackCount() - tracks.size();
            n = 0;
            while (n < n2) {
                int it = n++;
                boolean bl = false;
                ((Collection)tracks).add(new StandardMidiFile.Track(CollectionsKt.emptyList()));
            }
        }
        return tracks;
    }

    private final Event readMetaEvent(ArrayInputStream stream, int time, byte metaType) {
        Event event;
        byte by = metaType;
        if (by == 0) {
            event = this.readSequenceNumber(stream);
        } else if (by == 1) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.Text(time, text);
        } else if (by == 2) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.CopyrightNotice(text);
        } else if (by == 3) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.SequenceTrackName(text);
        } else if (by == 4) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.InstrumentName(text);
        } else if (by == 5) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.Lyric(time, text);
        } else if (by == 6) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.Marker(time, text);
        } else if (by == 7) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text = StringsKt.decodeToString((byte[])stream.readNBytes(length));
            event = new MetaEvent.CuePoint(time, text);
        } else if (by == 32) {
            event = this.readMidiChannelPrefix(stream, time);
        } else if (by == 47) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            stream.skip(length);
            event = new MetaEvent.EndOfTrack(time);
        } else if (by == 81) {
            event = this.readTempo(stream, time);
        } else if (by == 84) {
            event = this.readSmpteOffset(stream);
        } else if (by == 89) {
            event = this.readKeySignature(stream, time);
        } else if (by == 88) {
            event = this.readTimeSignature(stream, time);
        } else if (by == 127) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            byte[] data = stream.readNBytes(length);
            event = new MetaEvent.SequencerSpecific(time, data);
        } else {
            int length = ((Number)stream.readVlq().component1()).intValue();
            byte[] bytes = stream.readNBytes(length);
            event = new MetaEvent.Unknown(time, metaType, bytes);
        }
        return event;
    }

    private final MetaEvent.TimeSignature readTimeSignature(ArrayInputStream stream, int time) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 4) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException((KClass<? extends MetaEvent>)Reflection.getOrCreateKotlinClass(MetaEvent.TimeSignature.class));
        }
        byte numerator = stream.read();
        byte denominator = stream.read();
        byte clocksInMetronomeClick = stream.read();
        byte thirtySecondNotesInMidiQuarterNote = stream.read();
        stream.skip(length - 4);
        return new MetaEvent.TimeSignature(time, numerator, denominator, clocksInMetronomeClick, thirtySecondNotesInMidiQuarterNote);
    }

    private final MetaEvent.KeySignature readKeySignature(ArrayInputStream stream, int time) {
        MetaEvent.KeySignature keySignature;
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 2) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException((KClass<? extends MetaEvent>)Reflection.getOrCreateKotlinClass(MetaEvent.KeySignature.class));
        }
        byte key = stream.read();
        byte scale = stream.read();
        stream.skip(length - 2);
        try {
            keySignature = new MetaEvent.KeySignature(time, MetaEvent.KeySignature.Key.Companion.fromValue(key), MetaEvent.KeySignature.Scale.Companion.fromValue(scale));
        }
        catch (IllegalArgumentException e) {
            if (!this.policies.getIgnoreBadKeySignatures()) {
                throw e;
            }
            keySignature = null;
        }
        return keySignature;
    }

    private final MetaEvent.SmpteOffset readSmpteOffset(ArrayInputStream stream) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 5) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException((KClass<? extends MetaEvent>)Reflection.getOrCreateKotlinClass(MetaEvent.SmpteOffset.class));
        }
        byte hour = stream.read();
        byte minute = stream.read();
        byte second = stream.read();
        byte frame = stream.read();
        byte subFrame = stream.read();
        stream.skip(length - 5);
        return new MetaEvent.SmpteOffset(new SmpteTimecode(hour, minute, second, frame, subFrame));
    }

    private final MetaEvent.SetTempo readTempo(ArrayInputStream stream, int time) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 3) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException((KClass<? extends MetaEvent>)Reflection.getOrCreateKotlinClass(MetaEvent.SetTempo.class));
        }
        int tempo = stream.read24BitInt();
        stream.skip(length - 3);
        return new MetaEvent.SetTempo(time, tempo);
    }

    private final MetaEvent.ChannelPrefix readMidiChannelPrefix(ArrayInputStream stream, int time) {
        MetaEvent.ChannelPrefix channelPrefix;
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 1) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException((KClass<? extends MetaEvent>)Reflection.getOrCreateKotlinClass(MetaEvent.ChannelPrefix.class));
        }
        byte channel = stream.read();
        stream.skip(length - 1);
        try {
            channelPrefix = new MetaEvent.ChannelPrefix(time, channel);
        }
        catch (IllegalArgumentException e) {
            if (!this.policies.getIgnoreBadChannelPrefixes()) {
                throw e;
            }
            channelPrefix = null;
        }
        return channelPrefix;
    }

    private final MetaEvent.SequenceNumber readSequenceNumber(ArrayInputStream stream) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 2) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException((KClass<? extends MetaEvent>)Reflection.getOrCreateKotlinClass(MetaEvent.SequenceNumber.class));
        }
        byte high = stream.read();
        byte low = stream.read();
        stream.skip(length - 2);
        return new MetaEvent.SequenceNumber((short)((short)BitwiseOperationsKt.shl(high, 8) | (short)low));
    }

    private final byte readDataByte(byte data1, ArrayInputStream stream) {
        return data1 == -1 ? stream.read() : data1;
    }

    private final Pair<Byte, Byte> readTwoDataBytes(byte data1, ArrayInputStream stream) {
        return data1 == -1 ? new Pair((Object)stream.read(), (Object)stream.read()) : new Pair((Object)data1, (Object)stream.read());
    }
}

