/*
 * Copyright © 2024 Jacob Wysko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wysko.kmidi.midi.event

private const val PITCH_CENTER_RANGE = 8192.0

/**
 * Indicates the channel's pitch is to change.
 *
 * @property value The new pitch value.
 */
public data class PitchWheelChangeEvent(
    override val tick: Int,
    override val channel: Byte,
    val value: Short,
) : MidiEvent(tick, channel) {
    /**
     * The value in semitones.
     */
    public val semitones: Double
        get() = (value.toDouble() - PITCH_CENTER_RANGE) / PITCH_CENTER_RANGE
}
