/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.midi.Arc;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.kmidi.midi.event.NoteEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u001b\u0010#\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%J\u001b\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\f\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010)J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\f\u0010-\u001a\u00020.*\u00020\u001dH\u0002J\f\u0010/\u001a\u00020\u0018*\u00020\u001aH\u0002R\u0019\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\u0004\u0018\u00010\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00061"}, d2={"Lorg/wysko/kmidi/midi/TimeBasedSequence;", "", "smf", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "(Lorg/wysko/kmidi/midi/StandardMidiFile;)V", "duration", "Lkotlin/time/Duration;", "getDuration-UwyO8pc", "()J", "J", "eventTimes", "", "Lorg/wysko/kmidi/midi/event/Event;", "firstNoteOnTime", "getFirstNoteOnTime-FghU774", "()Lkotlin/time/Duration;", "getSmf", "()Lorg/wysko/kmidi/midi/StandardMidiFile;", "tempos", "", "Lorg/wysko/kmidi/midi/event/MetaEvent$SetTempo;", "getTempos", "()Ljava/util/List;", "convertArcsToTimedArcs", "Lorg/wysko/kmidi/midi/TimedArc;", "arcs", "Lorg/wysko/kmidi/midi/Arc;", "getTempoAtTick", "tick", "", "getTempoAtTime", "time", "getTempoAtTime-LRDsOJo", "(J)Lorg/wysko/kmidi/midi/event/MetaEvent$SetTempo;", "getTempoBeforeTick", "getTimeAtTick", "getTimeAtTick-5sfh64U", "(I)J", "getTimeOf", "event", "getTimeOf-5sfh64U", "(Lorg/wysko/kmidi/midi/event/Event;)J", "registerEvents", "", "events", "toBeats", "", "toTimedArc", "Companion", "kmidi"})
@SourceDebugExtension(value={"SMAP\nTimeBasedSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeBasedSequence.kt\norg/wysko/kmidi/midi/TimeBasedSequence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,186:1\n1360#2:187\n1446#2,5:188\n800#2,11:193\n1045#2:204\n1655#2,8:205\n1360#2:213\n1446#2,5:214\n1271#2,2:219\n1285#2,4:221\n1855#2,2:233\n766#2:235\n857#2,2:236\n1804#2,4:238\n451#2,6:242\n451#2,6:248\n451#2,6:254\n1549#2:260\n1620#2,3:261\n1#3:225\n478#4,7:226\n*S KotlinDebug\n*F\n+ 1 TimeBasedSequence.kt\norg/wysko/kmidi/midi/TimeBasedSequence\n*L\n48#1:187\n48#1:188,5\n49#1:193,11\n52#1:204\n54#1:205,8\n65#1:213\n65#1:214,5\n66#1:219,2\n66#1:221,4\n99#1:233,2\n114#1:235\n114#1:236,2\n115#1:238,4\n135#1:242,6\n146#1:248,6\n158#1:254,6\n167#1:260\n167#1:261,3\n79#1:226,7\n*E\n"})
public final class TimeBasedSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StandardMidiFile smf;
    @NotNull
    private final List<MetaEvent.SetTempo> tempos;
    @NotNull
    private final Map<Event, Duration> eventTimes;
    private final long duration;
    @Nullable
    private final Duration firstNoteOnTime;

    /*
     * WARNING - void declaration
     */
    private TimeBasedSequence(StandardMidiFile smf) {
        void $this$filterKeys$iv;
        Map<Event, Duration> $this$associateWith$iv;
        void it;
        Iterable $this$distinctBy$iv;
        Collection collection;
        void $this$filterIsInstanceTo$iv$iv;
        Collection $this$filterIsInstance$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        this.smf = smf;
        Iterable iterable = this.smf.getTracks();
        TimeBasedSequence timeBasedSequence = this;
        boolean $i$f$flatMap = false;
        void var4_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StandardMidiFile.Track it2 = (StandardMidiFile.Track)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getEvents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MetaEvent.SetTempo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TimeBasedSequence timeBasedSequence2 = timeBasedSequence;
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        if ($this$filterIsInstance$iv.isEmpty()) {
            timeBasedSequence = timeBasedSequence2;
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)new MetaEvent.SetTempo(0, 500000));
            timeBasedSequence2 = timeBasedSequence;
        } else {
            collection = $this$filterIsInstance$iv;
        }
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.asReversed((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MetaEvent.SetTempo it = (MetaEvent.SetTempo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTick());
                it = (MetaEvent.SetTempo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTick()));
            }
        }));
        timeBasedSequence = timeBasedSequence2;
        boolean $i$f$distinctBy22 = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            MetaEvent.SetTempo it3 = (MetaEvent.SetTempo)e$iv;
            boolean bl = false;
            Integer key$iv = it3.getTick();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List $i$f$distinctBy22 = $this$distinctBy$iv = CollectionsKt.toMutableList((Collection)CollectionsKt.asReversed((List)list$iv));
        boolean $i$a$-also-TimeBasedSequence$tempos$62 = false;
        if (((MetaEvent.SetTempo)CollectionsKt.first((List)it)).getTick() != 0) {
            it.add(0, new MetaEvent.SetTempo(0, 500000));
        }
        timeBasedSequence.tempos = $this$distinctBy$iv;
        $this$distinctBy$iv = this.smf.getTracks();
        timeBasedSequence = this;
        $i$f$flatMap = false;
        Iterable $i$a$-also-TimeBasedSequence$tempos$62 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StandardMidiFile.Track it4 = (StandardMidiFile.Track)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it4.getEvents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it5;
            Event list$iv$iv = (Event)element$iv$iv;
            Object object = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Duration duration = Duration.box-impl((long)this.getTimeAtTick-5sfh64U(it5.getTick()));
            map.put(object, duration);
        }
        timeBasedSequence.eventTimes = MapsKt.toMutableMap((Map)result$iv);
        $this$associateWith$iv = this.eventTimes;
        timeBasedSequence = this;
        Iterator $i$f$associateWith22 = ((Iterable)$this$associateWith$iv.entrySet()).iterator();
        if (!$i$f$associateWith22.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it6 = (Map.Entry)$i$f$associateWith22.next();
        boolean bl = false;
        it6 = (Comparable)Duration.box-impl((long)((Duration)it6.getValue()).unbox-impl());
        while ($i$f$associateWith22.hasNext()) {
            Map.Entry it7 = (Map.Entry)$i$f$associateWith22.next();
            $i$a$-maxOf-TimeBasedSequence$duration$1 = false;
            Comparable comparable = (Comparable)Duration.box-impl((long)((Duration)it7.getValue()).unbox-impl());
            if (it6.compareTo(comparable) >= 0) continue;
            it6 = comparable;
        }
        timeBasedSequence.duration = ((Duration)it6).unbox-impl();
        $this$associateWith$iv = this.eventTimes;
        timeBasedSequence = this;
        boolean $i$f$filterKeys = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            Event it8 = (Event)entry$iv.getKey();
            boolean bl2 = false;
            if (!(it8 instanceof NoteEvent.NoteOn)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        timeBasedSequence.firstNoteOnTime = (Duration)CollectionsKt.minOrNull((Iterable)((Map)result$iv).values());
    }

    @NotNull
    public final StandardMidiFile getSmf() {
        return this.smf;
    }

    @NotNull
    public final List<MetaEvent.SetTempo> getTempos() {
        return this.tempos;
    }

    public final long getDuration-UwyO8pc() {
        return this.duration;
    }

    @Nullable
    public final Duration getFirstNoteOnTime-FghU774() {
        return this.firstNoteOnTime;
    }

    public final long getTimeOf-5sfh64U(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Duration duration = this.eventTimes.get(event);
        Intrinsics.checkNotNull((Object)duration);
        return duration.unbox-impl();
    }

    public final void registerEvents(@NotNull List<? extends Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Event it = (Event)element$iv;
            boolean bl = false;
            this.eventTimes.put(it, Duration.box-impl((long)this.getTimeAtTick-5sfh64U(it.getTick())));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long getTimeAtTick-5sfh64U(int tick) {
        void $this$foldIndexed$iv;
        void $this$filterTo$iv$iv;
        if (this.tempos.size() == 1 || tick < 0) {
            return DurationKt.toDuration((double)(((MetaEvent.SetTempo)CollectionsKt.first(this.tempos)).getSecondsPerBeat() * this.toBeats(tick)), (DurationUnit)DurationUnit.SECONDS);
        }
        Iterable $this$filter$iv = this.tempos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MetaEvent.SetTempo it = (MetaEvent.SetTempo)element$iv$iv;
            boolean bl = false;
            if (!(it.getTick() < tick)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        double initial$iv = 0.0;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void acc;
            void tempo;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MetaEvent.SetTempo bl = (MetaEvent.SetTempo)element$iv;
            double d = accumulator$iv;
            int index = n;
            boolean bl2 = false;
            int n2 = this.tempos.size();
            int n3 = index + 1;
            int remainingTime = ((0 <= n3 ? n3 < n2 : false) ? RangesKt.coerceAtMost((int)this.tempos.get(index + 1).getTick(), (int)tick) : tick) - tempo.getTick();
            accumulator$iv = acc + this.toBeats(remainingTime) * tempo.getSecondsPerBeat();
        }
        return DurationKt.toDuration((double)accumulator$iv, (DurationUnit)DurationUnit.SECONDS);
    }

    @NotNull
    public final MetaEvent.SetTempo getTempoBeforeTick(int tick) {
        MetaEvent.SetTempo setTempo;
        if (this.tempos.size() == 1 || tick <= 0) {
            setTempo = (MetaEvent.SetTempo)CollectionsKt.first(this.tempos);
        } else {
            MetaEvent.SetTempo element$iv;
            block3: {
                List<MetaEvent.SetTempo> $this$last$iv = this.tempos;
                boolean $i$f$last = false;
                ListIterator<MetaEvent.SetTempo> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    MetaEvent.SetTempo it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it.getTick() < tick)) continue;
                    break block3;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            setTempo = element$iv;
        }
        return setTempo;
    }

    @NotNull
    public final MetaEvent.SetTempo getTempoAtTick(int tick) {
        MetaEvent.SetTempo setTempo;
        if (this.tempos.size() == 1 || tick < 0) {
            setTempo = (MetaEvent.SetTempo)CollectionsKt.first(this.tempos);
        } else {
            MetaEvent.SetTempo element$iv;
            block3: {
                List<MetaEvent.SetTempo> $this$last$iv = this.tempos;
                boolean $i$f$last = false;
                ListIterator<MetaEvent.SetTempo> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    MetaEvent.SetTempo it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it.getTick() <= tick)) continue;
                    break block3;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            setTempo = element$iv;
        }
        return setTempo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final MetaEvent.SetTempo getTempoAtTime-LRDsOJo(long time) {
        MetaEvent.SetTempo element$iv;
        MetaEvent.SetTempo setTempo;
        block2: {
            block4: {
                block3: {
                    if (this.tempos.size() == 1) break block3;
                    if (Duration.compareTo-LRDsOJo((long)time, (long)DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS)) >= 0) break block4;
                }
                setTempo = (MetaEvent.SetTempo)CollectionsKt.first(this.tempos);
                return setTempo;
            }
            List<MetaEvent.SetTempo> $this$last$iv = this.tempos;
            boolean $i$f$last = false;
            ListIterator<MetaEvent.SetTempo> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                MetaEvent.SetTempo it = element$iv = iterator$iv.previous();
                boolean bl = false;
                Duration duration = this.eventTimes.get(it);
                Intrinsics.checkNotNull((Object)duration);
                if (!(Duration.compareTo-LRDsOJo((long)duration.unbox-impl(), (long)time) <= 0)) continue;
                break block2;
            }
            throw new NoSuchElementException("List contains no element matching the predicate.");
        }
        setTempo = element$iv;
        return setTempo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TimedArc> convertArcsToTimedArcs(@NotNull List<? extends Arc> arcs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(arcs, (String)"arcs");
        Iterable $this$map$iv = arcs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Arc arc = (Arc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toTimedArc((Arc)it));
        }
        return (List)destination$iv$iv;
    }

    private final double toBeats(int $this$toBeats) {
        return (double)$this$toBeats / (double)this.smf.getHeader().getDivision().getTicksPerQuarterNote();
    }

    private final TimedArc toTimedArc(Arc $this$toTimedArc) {
        long startTime = this.getTimeAtTick-5sfh64U($this$toTimedArc.getNoteOn$kmidi().getTick());
        long endTime = this.getTimeAtTick-5sfh64U($this$toTimedArc.getNoteOff$kmidi().getTick());
        return new TimedArc($this$toTimedArc.getNoteOn$kmidi(), $this$toTimedArc.getNoteOff$kmidi(), startTime, endTime, null);
    }

    public /* synthetic */ TimeBasedSequence(StandardMidiFile smf, DefaultConstructorMarker $constructor_marker) {
        this(smf);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/wysko/kmidi/midi/TimeBasedSequence$Companion;", "", "()V", "toTimeBasedSequence", "Lorg/wysko/kmidi/midi/TimeBasedSequence;", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "kmidi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeBasedSequence toTimeBasedSequence(@NotNull StandardMidiFile $this$toTimeBasedSequence) {
            Intrinsics.checkNotNullParameter((Object)$this$toTimeBasedSequence, (String)"<this>");
            return new TimeBasedSequence($this$toTimeBasedSequence, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

