/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.builder.Builder;
import org.wysko.kmidi.midi.builder.TrackBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010)\u001a\u00020\u0002H\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010*\u001a\u00020\u0014J\u001f\u0010,\u001a\u00020\u00122\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.\u00a2\u0006\u0002\b1R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\u0017\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0015\u0010\u0019\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0015\u0010\u001b\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0015\u0010\u001d\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0015\u0010\u001f\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u0015\u0010!\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016R\u0015\u0010#\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016R\u0015\u0010%\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0016R\u0015\u0010'\u001a\u00020\u0014*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0016\u00a8\u00062"}, d2={"Lorg/wysko/kmidi/midi/builder/StandardMidiFileBuilder;", "Lorg/wysko/kmidi/midi/builder/Builder;", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "()V", "division", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "getDivision", "()Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;", "setDivision", "(Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division;)V", "format", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;", "getFormat", "()Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;", "setFormat", "(Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Format;)V", "tracks", "", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "eighth", "", "getEighth", "(I)I", "eighthTriplet", "getEighthTriplet", "half", "getHalf", "quarter", "getQuarter", "quarterTriplet", "getQuarterTriplet", "sixteenth", "getSixteenth", "sixteenthTriplet", "getSixteenthTriplet", "thirtySecond", "getThirtySecond", "thirtySecondTriplet", "getThirtySecondTriplet", "whole", "getWhole", "build", "tpq", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header$Division$MetricalTime;", "track", "block", "Lkotlin/Function1;", "Lorg/wysko/kmidi/midi/builder/TrackBuilder;", "", "Lkotlin/ExtensionFunctionType;", "kmidi"})
@SourceDebugExtension(value={"SMAP\nStandardMidiFileBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardMidiFileBuilder.kt\norg/wysko/kmidi/midi/builder/StandardMidiFileBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class StandardMidiFileBuilder
implements Builder<StandardMidiFile> {
    @NotNull
    private final List<StandardMidiFile.Track> tracks = new ArrayList();
    public StandardMidiFile.Header.Format format;
    public StandardMidiFile.Header.Division division;

    @NotNull
    public final StandardMidiFile.Header.Format getFormat() {
        StandardMidiFile.Header.Format format = this.format;
        if (format != null) {
            return format;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"format");
        return null;
    }

    public final void setFormat(@NotNull StandardMidiFile.Header.Format format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"<set-?>");
        this.format = format;
    }

    @NotNull
    public final StandardMidiFile.Header.Division getDivision() {
        StandardMidiFile.Header.Division division = this.division;
        if (division != null) {
            return division;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"division");
        return null;
    }

    public final void setDivision(@NotNull StandardMidiFile.Header.Division division) {
        Intrinsics.checkNotNullParameter((Object)division, (String)"<set-?>");
        this.division = division;
    }

    public final int getWhole(int $this$whole) {
        return $this$whole * this.getDivision().getTicksPerQuarterNote() * 4;
    }

    public final int getHalf(int $this$half) {
        return $this$half * this.getDivision().getTicksPerQuarterNote() * 2;
    }

    public final int getQuarter(int $this$quarter) {
        return $this$quarter * this.getDivision().getTicksPerQuarterNote();
    }

    public final int getEighth(int $this$eighth) {
        return $this$eighth * this.getDivision().getTicksPerQuarterNote() / 2;
    }

    public final int getSixteenth(int $this$sixteenth) {
        return $this$sixteenth * this.getDivision().getTicksPerQuarterNote() / 4;
    }

    public final int getThirtySecond(int $this$thirtySecond) {
        return $this$thirtySecond * this.getDivision().getTicksPerQuarterNote() / 8;
    }

    public final int getQuarterTriplet(int $this$quarterTriplet) {
        return $this$quarterTriplet * this.getDivision().getTicksPerQuarterNote() / 3 * 2;
    }

    public final int getEighthTriplet(int $this$eighthTriplet) {
        return $this$eighthTriplet * this.getDivision().getTicksPerQuarterNote() / 3;
    }

    public final int getSixteenthTriplet(int $this$sixteenthTriplet) {
        return $this$sixteenthTriplet * this.getDivision().getTicksPerQuarterNote() / 6;
    }

    public final int getThirtySecondTriplet(int $this$thirtySecondTriplet) {
        return $this$thirtySecondTriplet * this.getDivision().getTicksPerQuarterNote() / 12;
    }

    @NotNull
    public final StandardMidiFile.Header.Division.MetricalTime tpq(int tpq) {
        if (!(1 <= tpq ? tpq < 32768 : false)) {
            boolean bl = false;
            String string = "Ticks per quarter note must be in the range [1, 32767]";
            throw new IllegalArgumentException(string.toString());
        }
        return new StandardMidiFile.Header.Division.MetricalTime((short)tpq);
    }

    @NotNull
    public final StandardMidiFile.Track track(@NotNull Function1<? super TrackBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Object object = new TrackBuilder();
        block.invoke(object);
        Object it = object = ((TrackBuilder)object).build();
        boolean bl = false;
        ((Collection)this.tracks).add(it);
        return object;
    }

    @Override
    @NotNull
    public StandardMidiFile build() {
        return new StandardMidiFile(new StandardMidiFile.Header("MThd", this.getFormat(), (short)this.tracks.size(), this.getDivision()), this.tracks);
    }
}

