/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi.reader;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.ArrayInputStream;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.reader.StandardMidiFileHeaderReader;
import org.wysko.kmidi.midi.reader.StandardMidiFileTracksReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader;", "", "policies", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies;", "(Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies;)V", "readByteArray", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "bytes", "", "Policies", "kmidi"})
public final class StandardMidiFileReader {
    @NotNull
    private final Policies policies;

    public StandardMidiFileReader(@NotNull Policies policies) {
        Intrinsics.checkNotNullParameter((Object)policies, (String)"policies");
        this.policies = policies;
    }

    public /* synthetic */ StandardMidiFileReader(Policies policies, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            policies = Policies.Companion.getLenient();
        }
        this(policies);
    }

    @NotNull
    public final StandardMidiFile readByteArray(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ArrayInputStream stream = new ArrayInputStream(bytes);
        StandardMidiFile.Header header = new StandardMidiFileHeaderReader(stream).readHeader();
        List<StandardMidiFile.Track> tracks = new StandardMidiFileTracksReader(this.policies).readRemainingChunks$kmidi(stream, header);
        return new StandardMidiFile(header, tracks);
    }

    public StandardMidiFileReader() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0002#$B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies;", "", "allowRunningStatusAcrossNonMidiEvents", "", "allowTrackCountDiscrepancy", "coerceVelocityToRange", "ignoreBadChannelPrefixes", "ignoreBadKeySignatures", "ignoreIncompleteMetaEvents", "unexpectedEndOfFilePolicy", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "(ZZZZZZLorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;)V", "getAllowRunningStatusAcrossNonMidiEvents", "()Z", "getAllowTrackCountDiscrepancy", "getCoerceVelocityToRange", "getIgnoreBadChannelPrefixes", "getIgnoreBadKeySignatures", "getIgnoreIncompleteMetaEvents", "getUnexpectedEndOfFilePolicy", "()Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "UnexpectedEndOfFileExceptionPolicy", "kmidi"})
    public static final class Policies {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean allowRunningStatusAcrossNonMidiEvents;
        private final boolean allowTrackCountDiscrepancy;
        private final boolean coerceVelocityToRange;
        private final boolean ignoreBadChannelPrefixes;
        private final boolean ignoreBadKeySignatures;
        private final boolean ignoreIncompleteMetaEvents;
        @NotNull
        private final UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFilePolicy;
        @NotNull
        private static final Policies lenient = new Policies(true, true, true, true, true, true, UnexpectedEndOfFileExceptionPolicy.AllowDirty.INSTANCE);
        @NotNull
        private static final Policies strict = new Policies(false, false, false, false, false, false, UnexpectedEndOfFileExceptionPolicy.Disallow.INSTANCE);

        public Policies(boolean allowRunningStatusAcrossNonMidiEvents, boolean allowTrackCountDiscrepancy, boolean coerceVelocityToRange, boolean ignoreBadChannelPrefixes, boolean ignoreBadKeySignatures, boolean ignoreIncompleteMetaEvents, @NotNull UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFilePolicy) {
            Intrinsics.checkNotNullParameter((Object)unexpectedEndOfFilePolicy, (String)"unexpectedEndOfFilePolicy");
            this.allowRunningStatusAcrossNonMidiEvents = allowRunningStatusAcrossNonMidiEvents;
            this.allowTrackCountDiscrepancy = allowTrackCountDiscrepancy;
            this.coerceVelocityToRange = coerceVelocityToRange;
            this.ignoreBadChannelPrefixes = ignoreBadChannelPrefixes;
            this.ignoreBadKeySignatures = ignoreBadKeySignatures;
            this.ignoreIncompleteMetaEvents = ignoreIncompleteMetaEvents;
            this.unexpectedEndOfFilePolicy = unexpectedEndOfFilePolicy;
        }

        public final boolean getAllowRunningStatusAcrossNonMidiEvents() {
            return this.allowRunningStatusAcrossNonMidiEvents;
        }

        public final boolean getAllowTrackCountDiscrepancy() {
            return this.allowTrackCountDiscrepancy;
        }

        public final boolean getCoerceVelocityToRange() {
            return this.coerceVelocityToRange;
        }

        public final boolean getIgnoreBadChannelPrefixes() {
            return this.ignoreBadChannelPrefixes;
        }

        public final boolean getIgnoreBadKeySignatures() {
            return this.ignoreBadKeySignatures;
        }

        public final boolean getIgnoreIncompleteMetaEvents() {
            return this.ignoreIncompleteMetaEvents;
        }

        @NotNull
        public final UnexpectedEndOfFileExceptionPolicy getUnexpectedEndOfFilePolicy() {
            return this.unexpectedEndOfFilePolicy;
        }

        public final boolean component1() {
            return this.allowRunningStatusAcrossNonMidiEvents;
        }

        public final boolean component2() {
            return this.allowTrackCountDiscrepancy;
        }

        public final boolean component3() {
            return this.coerceVelocityToRange;
        }

        public final boolean component4() {
            return this.ignoreBadChannelPrefixes;
        }

        public final boolean component5() {
            return this.ignoreBadKeySignatures;
        }

        public final boolean component6() {
            return this.ignoreIncompleteMetaEvents;
        }

        @NotNull
        public final UnexpectedEndOfFileExceptionPolicy component7() {
            return this.unexpectedEndOfFilePolicy;
        }

        @NotNull
        public final Policies copy(boolean allowRunningStatusAcrossNonMidiEvents, boolean allowTrackCountDiscrepancy, boolean coerceVelocityToRange, boolean ignoreBadChannelPrefixes, boolean ignoreBadKeySignatures, boolean ignoreIncompleteMetaEvents, @NotNull UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFilePolicy) {
            Intrinsics.checkNotNullParameter((Object)unexpectedEndOfFilePolicy, (String)"unexpectedEndOfFilePolicy");
            return new Policies(allowRunningStatusAcrossNonMidiEvents, allowTrackCountDiscrepancy, coerceVelocityToRange, ignoreBadChannelPrefixes, ignoreBadKeySignatures, ignoreIncompleteMetaEvents, unexpectedEndOfFilePolicy);
        }

        public static /* synthetic */ Policies copy$default(Policies policies, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFileExceptionPolicy, int n, Object object) {
            if ((n & 1) != 0) {
                bl = policies.allowRunningStatusAcrossNonMidiEvents;
            }
            if ((n & 2) != 0) {
                bl2 = policies.allowTrackCountDiscrepancy;
            }
            if ((n & 4) != 0) {
                bl3 = policies.coerceVelocityToRange;
            }
            if ((n & 8) != 0) {
                bl4 = policies.ignoreBadChannelPrefixes;
            }
            if ((n & 0x10) != 0) {
                bl5 = policies.ignoreBadKeySignatures;
            }
            if ((n & 0x20) != 0) {
                bl6 = policies.ignoreIncompleteMetaEvents;
            }
            if ((n & 0x40) != 0) {
                unexpectedEndOfFileExceptionPolicy = policies.unexpectedEndOfFilePolicy;
            }
            return policies.copy(bl, bl2, bl3, bl4, bl5, bl6, unexpectedEndOfFileExceptionPolicy);
        }

        @NotNull
        public String toString() {
            return "Policies(allowRunningStatusAcrossNonMidiEvents=" + this.allowRunningStatusAcrossNonMidiEvents + ", allowTrackCountDiscrepancy=" + this.allowTrackCountDiscrepancy + ", coerceVelocityToRange=" + this.coerceVelocityToRange + ", ignoreBadChannelPrefixes=" + this.ignoreBadChannelPrefixes + ", ignoreBadKeySignatures=" + this.ignoreBadKeySignatures + ", ignoreIncompleteMetaEvents=" + this.ignoreIncompleteMetaEvents + ", unexpectedEndOfFilePolicy=" + this.unexpectedEndOfFilePolicy + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.allowRunningStatusAcrossNonMidiEvents);
            result = result * 31 + Boolean.hashCode(this.allowTrackCountDiscrepancy);
            result = result * 31 + Boolean.hashCode(this.coerceVelocityToRange);
            result = result * 31 + Boolean.hashCode(this.ignoreBadChannelPrefixes);
            result = result * 31 + Boolean.hashCode(this.ignoreBadKeySignatures);
            result = result * 31 + Boolean.hashCode(this.ignoreIncompleteMetaEvents);
            result = result * 31 + this.unexpectedEndOfFilePolicy.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Policies)) {
                return false;
            }
            Policies policies = (Policies)other;
            if (this.allowRunningStatusAcrossNonMidiEvents != policies.allowRunningStatusAcrossNonMidiEvents) {
                return false;
            }
            if (this.allowTrackCountDiscrepancy != policies.allowTrackCountDiscrepancy) {
                return false;
            }
            if (this.coerceVelocityToRange != policies.coerceVelocityToRange) {
                return false;
            }
            if (this.ignoreBadChannelPrefixes != policies.ignoreBadChannelPrefixes) {
                return false;
            }
            if (this.ignoreBadKeySignatures != policies.ignoreBadKeySignatures) {
                return false;
            }
            if (this.ignoreIncompleteMetaEvents != policies.ignoreIncompleteMetaEvents) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.unexpectedEndOfFilePolicy, (Object)policies.unexpectedEndOfFilePolicy);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$Companion;", "", "()V", "lenient", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies;", "getLenient", "()Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies;", "strict", "getStrict", "kmidi"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Policies getLenient() {
                return lenient;
            }

            @NotNull
            public final Policies getStrict() {
                return strict;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "", "()V", "AllowClean", "AllowDirty", "Disallow", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowClean;", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowDirty;", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$Disallow;", "kmidi"})
        public static abstract class UnexpectedEndOfFileExceptionPolicy {
            private UnexpectedEndOfFileExceptionPolicy() {
            }

            public /* synthetic */ UnexpectedEndOfFileExceptionPolicy(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowClean;", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kmidi"})
            public static final class AllowClean
            extends UnexpectedEndOfFileExceptionPolicy {
                @NotNull
                public static final AllowClean INSTANCE = new AllowClean();

                private AllowClean() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "AllowClean";
                }

                public int hashCode() {
                    return -582381638;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AllowClean)) {
                        return false;
                    }
                    AllowClean cfr_ignored_0 = (AllowClean)other;
                    return true;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowDirty;", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kmidi"})
            public static final class AllowDirty
            extends UnexpectedEndOfFileExceptionPolicy {
                @NotNull
                public static final AllowDirty INSTANCE = new AllowDirty();

                private AllowDirty() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "AllowDirty";
                }

                public int hashCode() {
                    return -581534397;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AllowDirty)) {
                        return false;
                    }
                    AllowDirty cfr_ignored_0 = (AllowDirty)other;
                    return true;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$Disallow;", "Lorg/wysko/kmidi/midi/reader/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kmidi"})
            public static final class Disallow
            extends UnexpectedEndOfFileExceptionPolicy {
                @NotNull
                public static final Disallow INSTANCE = new Disallow();

                private Disallow() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Disallow";
                }

                public int hashCode() {
                    return -988277451;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Disallow)) {
                        return false;
                    }
                    Disallow cfr_ignored_0 = (Disallow)other;
                    return true;
                }
            }
        }
    }
}

