/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.ActionClassLoader;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.ActionListener;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.cache.ThingEntry;
import org.xmeta.thingManagers.ClassThingManager;
import org.xmeta.thingManagers.FileThingManager;
import org.xmeta.util.JavaCompiler15;
import org.xmeta.util.JavaCompiler16;
import org.xmeta.util.Semaphore;
import org.xmeta.util.ThingClassLoader;
import org.xmeta.util.UtilAction;
import org.xmeta.util.UtilString;

public class Action
extends Semaphore {
    private static Logger log = LoggerFactory.getLogger(Action.class);
    private static World world = World.getInstance();
    private static List<ThrowableRecord> throwables = new ArrayList<ThrowableRecord>();
    private static int throwableRecordCount = 0;
    private static Map<String, SoftReference<ClassCompileTimeFile>> classTimeFiles = new HashMap<String, SoftReference<ClassCompileTimeFile>>();
    public static final String[] javaKeyWords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "#"};
    public ThingEntry thingEntry;
    private boolean isJava = false;
    private boolean throwException;
    private boolean isSynchronized;
    public long lastModified;
    private boolean useOtherAction;
    private boolean isSelfInterpretationType;
    private String otherActionPath;
    private List<ThingEntry> contexts;
    public ClassLoader classLoader;
    public String className;
    public String classFileName;
    public String packageName;
    public String fileName;
    public String code;
    private String methodName;
    private boolean useOuterJava;
    private String outerClassName;
    private boolean attributeTemplate;
    public Class<?> actionClass = null;
    public boolean changed = false;
    private boolean disableGlobalContext = false;
    public Action outerAction = null;
    public Method method = null;
    Map<String, Object> userData = new HashMap<String, Object>();
    Logger logger;
    List<ActionResult> results;
    Thing params = null;
    boolean saveReturn;
    String returnVarName;
    boolean isCreateLocalVarScope;

    public Action(Thing thing) {
        this.thingEntry = new ThingEntry(thing);
        try {
            this.init();
        }
        catch (Exception e) {
            throw new ActionException("init action error, action=" + thing.getMetadata().getPath(), e);
        }
    }

    public void checkChanged() {
        if (this.lastModified != this.thingEntry.getThing().getMetadata().getLastModified()) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws ClassNotFoundException, IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        long classCompileTime;
        String compleClassPath;
        Thing thing;
        block41: {
            String fileManagerName;
            thing = this.thingEntry.getThing();
            this.params = thing.getThing("ins@0");
            this.throwException = thing.getAttribute("throwException") == null ? true : thing.getBoolean("throwException");
            this.isSynchronized = thing.getBoolean("isSynchronized");
            this.lastModified = thing.getMetadata().getLastModified();
            this.contexts = new ArrayList<ThingEntry>();
            Thing contextsThing = thing.getThing("contexts@0");
            if (contextsThing != null) {
                List<Thing> contextList = contextsThing.getChilds();
                for (Thing contextThing : contextList) {
                    this.contexts.add(new ThingEntry(contextThing));
                }
            }
            this.attributeTemplate = thing.getBoolean("attributeTemplate");
            this.useOtherAction = thing.getBoolean("useOtherAction");
            this.otherActionPath = thing.getString("otherActionPath");
            this.disableGlobalContext = thing.getBoolean("disableGlobalContext");
            this.isSelfInterpretationType = "Self".equals(thing.getString("interpretationType"));
            this.returnVarName = thing.getString("returnVarName");
            this.saveReturn = thing.getBoolean("saveReturn");
            Thing parent = thing.getParent();
            Thing rootParent = thing.getRoot();
            if (parent == null) {
                parent = thing;
            }
            fileManagerName = (fileManagerName = thing.getMetadata().getThingManager().getName()) == null ? "null" : UtilString.trimFileName(fileManagerName);
            this.className = fileManagerName + "." + rootParent.getMetadata().getPath();
            if (rootParent != thing) {
                this.className = this.className + ".p" + thing.getMetadata().getPath().hashCode();
                this.className = this.className.replace('-', '_');
                String cName = thing.getString("className");
                this.className = cName == null || "".equals(cName) ? this.className + "." + thing.getMetadata().getName() : this.className + "." + cName;
            }
            this.className = Action.getClassName(this.className);
            int dotIndex = this.className.lastIndexOf(".");
            if (dotIndex != -1) {
                this.packageName = this.className.substring(0, dotIndex);
            }
            this.fileName = this.className.replace('.', '/');
            this.fileName = World.getInstance().getPath() + "/actionSources/" + this.fileName;
            this.classFileName = World.getInstance().getPath() + "/actionClasses/" + this.className.replace('.', '/') + ".class";
            this.code = thing.getString("code");
            if (this.code == null) {
                this.code = "";
            }
            this.methodName = thing.getString("methodName");
            this.useOuterJava = thing.get("useOuterJava") == null ? true : thing.getBoolean("useOuterJava");
            this.outerClassName = thing.getString("outerClassName");
            this.actionClass = null;
            this.isJava = "JavaAction".equals(thing.getThingName());
            ThingClassLoader pclssLoader = thing.getMetadata().getThingManager().getClassLoader();
            compleClassPath = pclssLoader.getCompileClassPath();
            this.classLoader = world.getMode() == World.MODE_WORKING ? pclssLoader : new ActionClassLoader(pclssLoader);
            this.results = new ArrayList<ActionResult>();
            for (Thing child : thing.getAllChilds("Result")) {
                ActionResult result = new ActionResult(child);
                this.results.add(result);
            }
            this.isCreateLocalVarScope = thing.getBoolean("createLocalVarScope");
            classCompileTime = 0L;
            if (thing.getMetadata().getThingManager() instanceof ClassThingManager) {
                try {
                    classCompileTime = Action.getClassCompileTime(this.classFileName);
                    if (classCompileTime == 0L || classCompileTime != this.lastModified) break block41;
                    this.actionClass = this.classLoader.loadClass(this.className);
                    if (this.actionClass != null) {
                        classCompileTime = this.lastModified;
                    }
                }
                catch (Throwable t) {
                    classCompileTime = Action.getClassCompileTime(this.classFileName);
                }
            } else {
                classCompileTime = Action.getClassCompileTime(this.classFileName);
            }
        }
        if (this.isJava) {
            if (this.actionClass == null) {
                this.changed = false;
                if (this.useOuterJava) {
                    this.actionClass = this.classLoader.loadClass(this.outerClassName);
                } else {
                    boolean recompile = false;
                    File classFile = new File(this.classFileName);
                    if (!classFile.exists()) {
                        recompile = true;
                    }
                    if (this.lastModified != classCompileTime) {
                        recompile = true;
                    }
                    if (recompile && world.getMode() == World.MODE_PROGRAMING) {
                        if (thing.getBoolean("useInnerJava")) {
                            ThingManager thingManager = thing.getMetadata().getThingManager();
                            if (!(thingManager instanceof FileThingManager)) throw new ActionException("useInnerJava is only fit for FileThingManager, actionThing=" + thing.getMetadata().getPath());
                            FileThingManager fileThingManager = (FileThingManager)thingManager;
                            String sourcePath = fileThingManager.getFilePath();
                            File codeFile = new File(sourcePath, this.outerClassName.replace('.', '/') + ".java");
                            boolean use16 = true;
                            boolean compiled = false;
                            try {
                                Class.forName("javax.tools.JavaCompiler");
                            }
                            catch (Exception e) {
                                use16 = false;
                            }
                            if (use16) {
                                compiled = JavaCompiler16.compile(compleClassPath, sourcePath, codeFile);
                            }
                            if (!compiled) {
                                JavaCompiler15.compile(compleClassPath, sourcePath, codeFile.getAbsolutePath());
                            }
                        } else {
                            File codeFile = new File(this.fileName + ".java");
                            if (!codeFile.exists()) {
                                codeFile.getParentFile().mkdirs();
                            }
                            FileOutputStream fout = new FileOutputStream(codeFile);
                            try {
                                fout.write(("/*path:" + thing.getMetadata().getPath() + "*/\n").getBytes());
                                fout.write(("package " + this.packageName + ";\n\n").getBytes());
                                fout.write(this.code.getBytes());
                            }
                            finally {
                                fout.close();
                            }
                            File classDir = new File(world.getPath() + "/actionClasses");
                            if (!classDir.exists()) {
                                classDir.mkdirs();
                            }
                            boolean use16 = true;
                            boolean compiled = false;
                            try {
                                Class.forName("javax.tools.JavaCompiler");
                            }
                            catch (Exception e) {
                                use16 = false;
                            }
                            if (use16) {
                                compiled = JavaCompiler16.compile(compleClassPath, null, codeFile);
                            }
                            if (!compiled) {
                                JavaCompiler15.compile(compleClassPath, null, this.fileName);
                            }
                        }
                        this.updateCompileTime();
                    }
                    this.actionClass = thing.getBoolean("useInnerJava") ? this.classLoader.loadClass(this.outerClassName) : this.classLoader.loadClass(this.className);
                }
                Compiler.compileClass(this.actionClass);
                try {
                    if (this.methodName == null || "".equals(this.methodName)) return;
                    this.method = this.actionClass.getDeclaredMethod(this.methodName, ActionContext.class);
                    return;
                }
                catch (Throwable e) {
                    throw new ActionException("load method error, class=" + this.actionClass.getName() + ", method=" + this.methodName + ",action=" + thing.getMetadata().getPath(), e);
                }
            }
            if (this.method != null) return;
            try {
                if (this.methodName == null || "".equals(this.methodName)) return;
                this.method = this.actionClass.getDeclaredMethod(this.methodName, ActionContext.class);
                return;
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
        }
        if (this.useOtherAction) {
            this.outerAction = world.getAction(this.otherActionPath);
            return;
        } else {
            if (this.lastModified != classCompileTime) {
                this.changed = true;
            }
            this.logger = LoggerFactory.getLogger((String)thing.getMetadata().getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getActionClass(ActionContext actionContext) {
        Thing thing = this.thingEntry.getThing();
        if (this.lastModified != thing.getMetadata().getLastModified()) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
            this.changed = true;
        }
        if (this.isJava) {
            return this.actionClass;
        }
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        try {
            actionContext.pushPoolBindings().put("actionThing", thing);
            Class clazz = (Class)thing.doAction("getActionClass", actionContext);
            return clazz;
        }
        finally {
            actionContext.pop();
        }
    }

    public void updateCompileTime() {
        Action.updateClassCompileTime(this.classFileName, this.lastModified);
    }

    public Method getMethod() {
        return this.method;
    }

    public Object run() {
        return this.runArrayParams(new ActionContext(), null, null, false);
    }

    public Object run(ActionContext context) {
        return this.runMapParams(context, null, null, false);
    }

    public Object exec(Object ... params) {
        return this.runArrayParams(null, params, null, false);
    }

    public Object exec(ActionContext context, Object ... params) {
        return this.runArrayParams(context, params, null, false);
    }

    public Object run(ActionContext context, Map<String, Object> parameters) {
        return this.runMapParams(context, parameters, null, false);
    }

    public Object run(ActionContext context, Map<String, Object> parameters, boolean isSubAction) {
        return this.runMapParams(context, parameters, null, isSubAction);
    }

    public Object run(ActionContext context, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        return this.runMapParams(context, parameters, caller, isSubAction);
    }

    public Object runArrayParams(ActionContext context, Object[] params_, Object caller, boolean isSubAction) {
        if (context == null) {
            context = new ActionContext();
        }
        Bindings bindings = new Bindings();
        if (this.params != null) {
            List<Thing> ps = this.params.getChilds();
            for (int i = 0; i < ps.size(); ++i) {
                Thing p = ps.get(i);
                if (params_ != null && params_.length > i) {
                    bindings.put(p.getString("name"), params_[i]);
                    continue;
                }
                bindings.put(p.getString("name"), null);
            }
        }
        return this.dorun(context, bindings, bindings, caller, isSubAction);
    }

    public Object runMapParams(ActionContext context, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        if (context == null) {
            context = new ActionContext();
        }
        Bindings bindings = new Bindings();
        if (parameters != null) {
            bindings.putAll(parameters);
        }
        return this.dorun(context, bindings, parameters, caller, isSubAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object dorun(ActionContext context, Bindings bindings, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        Thing thing;
        if (context.peek().disableGloableContext || this.disableGlobalContext) {
            bindings.disableGloableContext = this.disableGlobalContext;
        }
        if (!bindings.disableGloableContext && world.isHaveActionListener()) {
            ActionListener listener = world.getActionListener();
            try {
                listener.actionExecuted(this, caller, context, parameters, -1L, true);
            }
            catch (Throwable t) {
                log.error("ActionRecorder error", t);
            }
        }
        if (this.lastModified != (thing = this.thingEntry.getThing()).getMetadata().getLastModified()) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
            this.changed = true;
        }
        boolean thisIsSynchronized = false;
        if (this.isSynchronized) {
            try {
                this.use();
                thisIsSynchronized = true;
            }
            catch (InterruptedException e) {
                throw new ActionException("try to synchronize action : " + thing.getMetadata().getPath(), e);
            }
        }
        context.push(bindings);
        if (this.isCreateLocalVarScope) {
            bindings.setVarScopeFlag();
        }
        context.pushAction(this);
        bindings.put("world", world);
        if (this.logger != null) {
            bindings.put("log", this.logger);
        }
        Object result = null;
        ArrayList<ThingEntry> allContexts = new ArrayList<ThingEntry>();
        if (!this.disableGlobalContext) {
            allContexts.addAll(Action.world.globalContexts);
        }
        if (this.contexts.size() > 0) {
            allContexts.addAll(this.contexts);
        }
        bindings.setCaller(this, null);
        bindings.world = world;
        try {
            Throwable exception;
            Bindings returnVarBindings;
            if (allContexts.size() > 0) {
                for (ThingEntry thingContext : allContexts) {
                    Action.initContext(thingContext.getThing(), context);
                }
            }
            if (this.useOtherAction) {
                Bindings callerBindings = context.getScope(context.getScopesSize() - 2);
                try {
                    context.push(callerBindings);
                    result = this.outerAction.run(context, parameters, isSubAction);
                }
                finally {
                    context.pop();
                }
            }
            if (this.isJava) {
                if (this.actionClass != null) {
                    if (this.method != null) {
                        result = this.method.invoke(this.actionClass, context);
                    } else {
                        this.logger.info("Java action method is null, " + this.getThing().getMetadata().getPath());
                    }
                }
            } else if (this.isSelfInterpretationType) {
                if (this.attributeTemplate) {
                    Thing fthing = (Thing)thing.run("processAttributeTemplate", context, (Map<String, Object>)null, isSubAction, true);
                    if (fthing != null) {
                        fthing.run("run", context, (Map<String, Object>)null, isSubAction, true);
                    }
                } else {
                    result = thing.run("run", context, (Map<String, Object>)null, isSubAction, true);
                }
            } else {
                Thing actionThing = thing.getActionThing("run");
                if (actionThing != null) {
                    Action ac = null;
                    try {
                        ac = actionThing.getAction();
                    }
                    catch (Exception e) {
                        throw new ActionException("Get run action error, thing=" + thing.getMetadata().getPath(), e);
                    }
                    result = ac.run(context, null, caller, isSubAction);
                }
            }
            if (this.saveReturn && this.returnVarName != null && !"".equals(this.returnVarName) && (returnVarBindings = UtilAction.getVarScope(this.thingEntry.getThing(), context)) != null) {
                returnVarBindings.put(this.returnVarName, result);
            }
            if (context.getStatus() == 5 && !isSubAction) {
                if (context.getThrowedObject() instanceof Throwable) {
                    throw (Throwable)context.getThrowedObject();
                }
                Object throwedObject = context.getThrowedObject();
                if (throwedObject != null) {
                    if (throwedObject instanceof Throwable) {
                        throw (Throwable)throwedObject;
                    }
                    throw new ActionException(throwedObject.toString());
                }
                throw new ActionException("action throw null");
            }
            String contxtMethod = "success";
            if ("failure".equals(result)) {
                contxtMethod = "failure";
            }
            if ((exception = Action.doContextMethod(allContexts, context, contxtMethod, null)) == null) {
                Object object = result;
                return object;
            }
            if (!this.throwException) {
                this.logHideenExceptionStackTrace(exception, context);
                Object var12_19 = null;
                return var12_19;
            }
            try {
                throw exception;
            }
            catch (Throwable e) {
                exception = Action.doContextMethod(allContexts, context, "exception", e);
                if (throwableRecordCount > 0) {
                    throwables.add(new ThrowableRecord(exception, context));
                    while (throwables.size() > throwableRecordCount) {
                        throwables.remove(0);
                    }
                }
                if (exception == null) {
                    String string = "success";
                    return string;
                }
                if (!this.throwException) {
                    this.logHideenExceptionStackTrace(e, context);
                    Object var12_21 = null;
                    return var12_21;
                }
                throw this.wrapToActionException(exception, context);
            }
        }
        finally {
            context.pop();
            context.popAction();
            if (!isSubAction) {
                context.setStatus(0);
            }
            if (thisIsSynchronized) {
                this.finished();
            }
        }
    }

    private ActionException wrapToActionException(Throwable t, ActionContext actionContext) {
        Throwable cause;
        if (t instanceof InvocationTargetException && (cause = t.getCause()) != null) {
            t = cause;
        }
        if (t instanceof ActionException) {
            return (ActionException)t;
        }
        return new ActionException("Action exception: " + this.thingEntry.getPath(), t, actionContext);
    }

    private void logHideenExceptionStackTrace(Throwable t, ActionContext actionContext) {
        log.warn("action ActionContext stacktrace:" + this.thingEntry.getPath());
        log.warn(actionContext.getStackTrace());
        if (t instanceof InvocationTargetException) {
            log.warn("action hidden throwable", t.getCause());
        } else {
            log.warn("action hidden throwable", t);
        }
    }

    public static Throwable doContextMethod(List<ThingEntry> contexts, ActionContext actionContext, String methodName, Throwable exception) {
        ArrayList<Thing> thingList = new ArrayList<Thing>();
        for (ThingEntry entry : contexts) {
            thingList.add(entry.getThing());
        }
        return Action.doThingContextMethod(thingList, actionContext, methodName, exception);
    }

    public static Throwable doThingContextMethod(List<Thing> contexts, ActionContext actionContext, String methodName, Throwable exception) {
        if (contexts.size() == 0) {
            return exception;
        }
        String tempMethodName = methodName;
        Bindings bindings = actionContext.peek();
        bindings.put("exception", exception);
        for (int i = contexts.size() - 1; i >= 0; --i) {
            Thing contextObj = contexts.get(i);
            ActionContext acContext = bindings.getContexts().get(contextObj);
            if (acContext != null) {
                acContext.peek().put("exception", exception);
            }
            if (contextObj == null || acContext == null || acContext.getScope(0).getCaller() != contextObj) continue;
            String onError = contextObj.getString("onError");
            try {
                String preventError;
                contextObj.doAction(tempMethodName, acContext);
                if (!"exception".equals(methodName) || exception == null || !"true".equals(preventError = contextObj.getString("preventError"))) continue;
                exception = null;
                continue;
            }
            catch (Exception e) {
                log.error("\u6267\u884c" + contextObj.getMetadata().getPath() + "\u4e0a\u4e0b\u6587\u65b9\u6cd5" + methodName + "\u5931\u8d25\uff1a", (Throwable)e);
                if ("exception".equals(onError)) {
                    tempMethodName = "exception";
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        return exception;
    }

    public static void initContext(Thing context, ActionContext actionContext) {
        if (context == null || context.getBoolean("disable")) {
            return;
        }
        Bindings bindings = actionContext.peek();
        ActionContext acContext = new ActionContext();
        acContext.peek().put("acContext", actionContext);
        acContext.getScope(0).setCaller(context, "init");
        Object inheritObj = null;
        boolean needInherit = context.getBoolean("inherit");
        if (needInherit) {
            inheritObj = context.doAction("inherit", acContext);
        }
        if (inheritObj != null && inheritObj instanceof ActionContext) {
            bindings.getContexts().put(context, (ActionContext)inheritObj);
        } else {
            context.doAction("init", acContext);
            bindings.getContexts().put(context, acContext);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getCompileClassPath() {
        return this.getThing().getMetadata().getThingManager().getClassLoader().getCompileClassPath();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static String getClassName(String className) {
        String[] cns = className.split("[.]");
        String cName = "";
        for (int i = 0; i < cns.length; ++i) {
            for (int n = 0; n < javaKeyWords.length; ++n) {
                if (!cns[i].equals(javaKeyWords[n])) continue;
                cns[i] = "t" + cns[i];
                break;
            }
            cns[i] = cns[i].replaceAll("(-)", "_");
            cns[i] = cns[i].replace(' ', '_');
            cName = cName.length() == 0 ? cns[i] : cName + "." + cns[i];
        }
        return cName;
    }

    public void setData(String key, Object data) {
        this.userData.put(key, data);
    }

    public Object getData(String key) {
        return this.userData.get(key);
    }

    public Thing getThing() {
        return this.thingEntry.getThing();
    }

    public static long getClassCompileTime(String classFileName) {
        File file = new File(classFileName);
        String path = file.getParentFile().getAbsolutePath();
        String className = file.getName();
        ClassCompileTimeFile timeFile = Action.getClassCompileTimeFile(path);
        if (timeFile != null) {
            return timeFile.getTime(className);
        }
        return 0L;
    }

    private static void updateClassCompileTime(String classFileName, long time) {
        File file = new File(classFileName);
        String path = file.getParentFile().getAbsolutePath();
        String className = file.getName();
        ClassCompileTimeFile timeFile = Action.getClassCompileTimeFile(path);
        if (timeFile != null) {
            timeFile.updateTime(className, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassCompileTimeFile getClassCompileTimeFile(String path) {
        Map<String, SoftReference<ClassCompileTimeFile>> map = classTimeFiles;
        synchronized (map) {
            SoftReference<ClassCompileTimeFile> fileRef = classTimeFiles.get(path);
            ClassCompileTimeFile file = null;
            if (fileRef != null) {
                file = fileRef.get();
            }
            if (file == null) {
                file = new ClassCompileTimeFile(path);
                fileRef = new SoftReference<ClassCompileTimeFile>(file);
                classTimeFiles.put(path, fileRef);
            }
            return file;
        }
    }

    public static int getThrowableRecordCount() {
        return throwableRecordCount;
    }

    public static void setThrowableRecordCount(int throwableRecordCount) {
        Action.throwableRecordCount = throwableRecordCount;
    }

    public static List<ThrowableRecord> getThrowables() {
        return throwables;
    }

    public static class ThrowableRecord {
        public Throwable throwable;
        public String actionStackTrace;
        public Date date;
        public String threadName;

        public ThrowableRecord(Throwable throwable, ActionContext actionContext) {
            this.throwable = throwable;
            this.actionStackTrace = actionContext.getStackTrace();
            this.date = new Date();
            this.threadName = Thread.currentThread().getName();
        }
    }

    class ActionResult {
        String name;
        String runType;
        String condition;
        ThingEntry resultObj;

        public ActionResult(Thing resultObj) {
            this.name = resultObj.getMetadata().getName();
            this.runType = resultObj.getString("type");
            this.resultObj = new ThingEntry(resultObj);
            this.condition = resultObj.getString("condition");
        }

        public Object run(ActionContext actionContext) throws Exception {
            Thing resultThing = this.resultObj.getThing();
            if (resultThing == null) {
                return null;
            }
            List<Thing> rchilds = resultThing.getAllChilds();
            if (this.runType != null && this.runType.startsWith("RANDOM")) {
                Collections.shuffle(rchilds, new Random(System.currentTimeMillis()));
            }
            ArrayList<Rate> rates = null;
            Random random = new Random();
            int maxRate = 0;
            if ("RANDOM_RATE".equals(this.runType)) {
                rates = new ArrayList<Rate>();
                for (Thing child : rchilds) {
                    int rate = 1;
                    try {
                        rate = child.getInt("rate");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rate <= 0) {
                        rate = 1;
                    }
                    Rate r = new Rate();
                    r.minRate = maxRate;
                    r.maxRate = maxRate += rate;
                    rates.add(r);
                }
            }
            int runCount = rchilds.size() > 0 ? random.nextInt(rchilds.size()) : 0;
            int count = 0;
            Object result = null;
            while (count < rchilds.size()) {
                int sint;
                Exception aexception = null;
                boolean successed = false;
                Thing data = rchilds.get(count);
                try {
                    if ("RANDOM_RATE".equals(this.runType)) {
                        int rate = random.nextInt(maxRate);
                        Rate r = (Rate)rates.get(count);
                        if (r.minRate > rate || r.maxRate <= rate) continue;
                    }
                    if ((result = data.getAction().run(actionContext, null, true)) instanceof String) {
                        if ("success".equals(result)) {
                            successed = true;
                        }
                    } else {
                        successed = true;
                    }
                }
                catch (Exception ee) {
                    aexception = ee;
                }
                if (successed) {
                    if ("SUCCESS".equals(this.runType) || "RANDOM_SUCCESS".equals(this.runType)) {
                        break;
                    }
                } else if ("SUCCESS".equals(this.runType) || "RANDOM_SUCCESS".equals(this.runType)) {
                    if (aexception != null) {
                        log.error("run script method", (Throwable)aexception);
                    }
                } else if (aexception != null) {
                    throw aexception;
                }
                if ("RANDOM_RATE".equals(this.runType) || "RANDOM_ONE".equals(this.runType) || "RANDOM_RANDOM".equals(this.runType) && runCount == count || (sint = actionContext.getStatus()) == 1 || sint == 3 || sint == 4) break;
                if (sint == 2) {
                    actionContext.setStatus(0);
                    break;
                }
                ++count;
            }
            return result;
        }
    }

    class Rate {
        int minRate;
        int maxRate;

        Rate() {
        }
    }

    static class ClassCompileTimeFile {
        Map<String, Long> classTimes = new HashMap<String, Long>();
        String timeFileName = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassCompileTimeFile(String path) {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            File timeFile = new File(file, "_classTime.txt");
            this.timeFileName = timeFile.getAbsolutePath();
            if (timeFile.exists()) {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(timeFile);
                    BufferedReader br = new BufferedReader(new InputStreamReader(fin));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        String[] strs;
                        if ("".equals(line = line.trim()) || (strs = line.split("[|]")).length != 2) continue;
                        this.classTimes.put(strs[0], Long.parseLong(strs[1]));
                    }
                    br.close();
                }
                catch (Exception e) {
                    log.error("init class compile time file error, " + this.timeFileName, (Throwable)e);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public long getTime(String className) {
            Long time = this.classTimes.get(className);
            if (time != null) {
                return time;
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void updateTime(String className, long time) {
            this.classTimes.put(className, time);
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(this.timeFileName);
                for (String key : this.classTimes.keySet()) {
                    Long ctime = this.classTimes.get(key);
                    fout.write((key + "|" + ctime + "\n").getBytes());
                }
            }
            catch (Exception e) {
                log.error("update class compile time file error, " + this.timeFileName, (Throwable)e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

