/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.util.List;
import org.xmeta.index.WorldIndex;

public abstract class Index {
    private static final Index index = new WorldIndex();
    public static final String TYPE_WORLD = "world";
    public static final String TYPE_PROJECTS = "projects";
    public static final String TYPE_PLUGINS = "plugins";
    public static final String TYPE_CHILDWORLDS = "childWorlds";
    public static final String TYPE_PROJECT = "project";
    public static final String TYPE_THINGMANAGER = "thingManager";
    public static final String TYPE_CATEGORY = "category";
    public static final String TYPE_THING = "thing";
    public static final String TYPE_WORKING_SET = "workingSet";
    protected boolean indexed = false;

    public static Index getInstance() {
        return index;
    }

    public static String getIndexId(Index index) {
        String id = index.getType() + "|" + index.getName();
        for (Index parent = index.getParent(); parent != null; parent = parent.getParent()) {
            id = parent.getType() + "|" + parent.getName() + "." + id;
        }
        return id;
    }

    public static Index getIndexById(String id) {
        Index parent = Index.getInstance();
        if (id == null || "".equals(index)) {
            return parent;
        }
        String path = parent.getType() + "|" + parent.getName();
        while (parent != null) {
            if (id.equals(path)) {
                return parent;
            }
            boolean have = false;
            for (Index child : parent.getChilds()) {
                String childPath = path + "." + child.getType() + "|" + child.getName();
                if (id.equals(childPath)) {
                    return child;
                }
                if (!id.startsWith(childPath + ".")) continue;
                path = childPath;
                parent = child;
                have = true;
                break;
            }
            if (have) continue;
            break;
        }
        return null;
    }

    public abstract Object getIndexObject();

    public abstract Index getParent();

    public abstract List<Index> getChilds();

    public abstract String getDescription();

    public abstract String getLabel();

    public abstract String getName();

    public abstract String getPath();

    public abstract String getType();

    public abstract boolean refresh();

    public long getLastModified() {
        return 0L;
    }
}

