/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.ParserConfigurationException;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.ActionListener;
import org.xmeta.Bindings;
import org.xmeta.Category;
import org.xmeta.Path;
import org.xmeta.ThingManager;
import org.xmeta.ThingMetadata;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.cache.LinkedThingEntry;
import org.xmeta.cache.ThingCache;
import org.xmeta.cache.ThingEntry;
import org.xmeta.codes.TxtThingCoder;
import org.xmeta.codes.XmlCoder;
import org.xmeta.thingManagers.TransientThingManager;
import org.xmeta.util.OgnlUtil;
import org.xmeta.util.ThingCallable;
import org.xmeta.util.ThingRunnable;
import org.xmeta.util.ThingUtil;
import org.xmeta.util.UtilData;
import org.xmeta.util.UtilMap;
import org.xmeta.util.UtilString;
import org.xmeta.util.UtilThing;
import org.xml.sax.SAXException;

public class Thing {
    private static Logger log = LoggerFactory.getLogger(Thing.class);
    private static Map<String, String> nameCache = new HashMap<String, String>(4096);
    public static final String THING = "thing";
    public static final String ATTRIBUTE = "attribute";
    public static final String NAME = "name";
    public static final String LABEL = "label";
    public static final String DESCRIPTORS = "descriptors";
    public static final String EXTENDS = "extends";
    public static final String DESCRIPTION = "description";
    public static final String ORIGIN_THING_PATH = "__ORIGIN_THING_PATH__";
    protected Map<String, Object> attributes = new HashMap<String, Object>(32);
    protected Thing parent = null;
    protected ThingMetadata metadata = new ThingMetadata(this);
    protected List<Thing> childs = new CopyOnWriteArrayList<Thing>();
    protected List<String> thingNames = new CopyOnWriteArrayList<String>();
    protected ThingEntry[] extendsCaches = null;
    protected ThingEntry[] descriptorsCaches = null;
    protected Map<String, LinkedThingEntry> actionCaches = new ConcurrentHashMap<String, LinkedThingEntry>();
    private static Map<Thread, Stack<Thread>> updatingThreads = new ConcurrentHashMap<Thread, Stack<Thread>>();
    protected boolean isTransient = false;
    protected Action action = null;
    protected Map<String, Object> datas = null;

    public Thing() {
        this(null, null, null, true);
    }

    public Thing(String descriptorPath) {
        this(null, null, descriptorPath, true);
    }

    public Thing(String name, String label) {
        this(name, label, null, true);
    }

    public Thing(String name, String label, String descriptorPath) {
        this(name, label, descriptorPath, true);
    }

    public Thing(String name, String label, String descriptorPath, boolean isTransient) {
        this.put(NAME, name);
        this.put(LABEL, label);
        this.put(DESCRIPTORS, descriptorPath);
        if (descriptorPath != null) {
            this.initDefaultValue();
        }
        if (isTransient) {
            TransientThingManager manager = World.getInstance().getTransientThingManager();
            String id = "" + manager.getNextId();
            this.metadata.setId(id);
            this.metadata.setPath("_transient.p" + id);
            this.metadata.setCategory(manager.getCategory("_transient"));
            this.isTransient = true;
            this.save();
        } else {
            this.isTransient = false;
        }
    }

    public synchronized void addChild(Thing childThing) {
        this.addChild(childThing, this.childs.size());
    }

    public synchronized void addChild(Thing childThing, int index) {
        this.addChild(childThing, index, true);
    }

    public synchronized void addChild(Thing childThing, boolean changeParen) {
        this.addChild(childThing, this.childs.size(), changeParen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addChild(Thing childThing, int index, boolean changeParent) {
        this.beginModify();
        try {
            if (childThing != null && changeParent) {
                String childThingId = childThing.getMetadata().getId();
                if (childThingId == null || "".equals(childThingId)) {
                    childThingId = childThing.getMetadata().getName();
                }
                if (childThingId != null) {
                    childThingId = childThingId.replace('\'', '_');
                    childThingId = childThingId.replace('\"', '_');
                    childThingId = childThingId.replace(':', '_');
                    childThingId = childThingId.replace('@', '_');
                    childThingId = childThingId.replace('&', '_');
                    childThingId = childThingId.replace('*', '_');
                    childThingId = childThingId.replace('#', '_');
                    childThingId = childThingId.replace('$', '_');
                    childThingId = childThingId.replace('%', '_');
                    childThingId = childThingId.replace('/', '_');
                    childThingId = childThingId.replace('.', '_');
                    childThingId = childThingId.replace('\\', '_');
                }
                boolean repeated = false;
                for (Thing child : this.childs) {
                    if (!child.getMetadata().getId().equals(childThingId)) continue;
                    repeated = true;
                    break;
                }
                if (!repeated) {
                    childThing.getMetadata().setId(childThingId);
                    this.childs.add(index, childThing);
                } else {
                    int idIndex = 0;
                    for (Thing child : this.childs) {
                        String childId = child.getMetadata().getId();
                        if (!childId.startsWith(childThingId)) continue;
                        try {
                            int aIndex = Integer.parseInt(childId.substring(childThingId.length(), childId.length()));
                            if (aIndex <= idIndex) continue;
                            idIndex = aIndex;
                        }
                        catch (Exception exception) {}
                    }
                    childThingId = childThingId + ++idIndex;
                    childThing.getMetadata().setId(childThingId);
                    this.childs.add(index, childThing);
                }
                childThing.parent = this;
                this.initChildMetadata(childThing);
            } else if (childThing != null) {
                this.childs.add(childThing);
                if (changeParent) {
                    this.initChildMetadata(childThing);
                }
            }
        }
        finally {
            this.endModify(true);
        }
    }

    public synchronized void addDescriptor(int index, Thing descriptor) {
        if (descriptor != null) {
            String descriptors = (String)this.attributes.get(DESCRIPTORS);
            String descriptorPath = descriptor.getMetadata().getPath();
            if (descriptors != null && !"".equals(descriptors)) {
                descriptors = UtilString.insert(descriptors, descriptorPath, index);
                this.put(DESCRIPTORS, descriptors);
            } else {
                this.put(DESCRIPTORS, descriptorPath);
            }
        }
    }

    public synchronized void addDescritpor(int index, String descriptorPath) {
        if (descriptorPath != null) {
            for (String descPath : UtilString.split(descriptorPath, ',')) {
                Thing descriptor = World.getInstance().getThing(descPath);
                if (descriptor == null) continue;
                this.addDescriptor(index, descriptor);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDetachedChild(Thing thing, Thing forDetachedChild, Map<Thing, Thing> context) {
        this.beginModify();
        try {
            if (context.get(forDetachedChild) != null) {
                thing.addChild(context.get(forDetachedChild));
            } else {
                Thing newChildThing = null;
                newChildThing = new Thing();
                newChildThing.attributes.putAll(forDetachedChild.attributes);
                newChildThing.getMetadata().setId(forDetachedChild.getMetadata().getId());
                context.put(forDetachedChild, newChildThing);
                thing.addChild(newChildThing);
                for (Thing childChildThing : forDetachedChild.childs) {
                    newChildThing.addDetachedChild(newChildThing, childChildThing, context);
                }
            }
        }
        finally {
            this.endModify(true);
        }
    }

    public void addExtend(int index, Thing extendThing) {
        if (extendThing != null) {
            String extendsStr = (String)this.attributes.get(EXTENDS);
            String extendPath = extendThing.getMetadata().getPath();
            if (extendsStr != null && !"".equals(extendsStr)) {
                extendsStr = UtilString.insert(extendsStr, extendPath, index);
                this.put(EXTENDS, extendsStr);
            } else {
                this.put(EXTENDS, extendPath);
            }
        }
    }

    public void changeChildIndex(Thing child, int index, int moveStep) {
        int oldIndex = 0;
        boolean have = false;
        for (Thing chd : this.childs) {
            if (chd == child) {
                have = true;
                break;
            }
            ++oldIndex;
        }
        if (have) {
            this.childs.remove(child);
            if (index < 0) {
                index = oldIndex + moveStep;
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= this.childs.size()) {
                this.childs.add(child);
            } else {
                this.childs.add(index, child);
            }
            child.updateLastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cognize(Map<String, Object> adata) {
        if (adata == null) {
            return;
        }
        this.beginModify();
        try {
            Object value;
            for (Thing attributeDescriptor : this.getAllAttributesDescriptors()) {
                String key = attributeDescriptor.getMetadata().getName();
                if (!adata.containsKey(key) || (value = adata.get(key)) instanceof Map) continue;
                this.put(key, value);
            }
            for (Thing childDescriptor : this.getAllChildsDescriptors()) {
                String childName = childDescriptor.getMetadata().getName();
                value = adata.get(childName);
                if (!(value instanceof Map)) continue;
                Map childData = (Map)value;
                Thing newChild = new Thing(null, null, childDescriptor.getMetadata().getPath(), false);
                newChild.cognize(childData);
                this.addChild(newChild);
            }
        }
        finally {
            this.endModify(true);
        }
    }

    public void cognize(String xmlData) throws ParserConfigurationException, SAXException, IOException {
        Thing thing = new Thing();
        XmlCoder.parse(thing, xmlData);
        this.cognize(thing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cognize(Thing thing) {
        if (thing == null) {
            return;
        }
        this.beginModify();
        try {
            List<Thing> descriptors = thing.getDescriptors();
            for (Thing descriptor : descriptors) {
                if (descriptor == World.getInstance().metaThing || descriptor.getMetadata().getPath().equals("metaThing")) continue;
                this.addDescriptor(-1, descriptor);
            }
            List<Thing> extendThings = thing.getExtends();
            for (Thing extend : extendThings) {
                this.addExtend(-1, extend);
            }
            for (String key : thing.getAttributes().keySet()) {
                if (NAME.equals(key) || LABEL.equals(key) || DESCRIPTION.equals(key) || EXTENDS.equals(key) || DESCRIPTORS.equals(key)) {
                    this.putIfNull(key, thing.getAttribute(key));
                    continue;
                }
                this.put(key, thing.getAttribute(key));
            }
            for (Thing child : thing.getChilds()) {
                boolean have = false;
                if (have) continue;
                Thing detachedChild = child.detach();
                this.addChild(detachedChild);
            }
        }
        finally {
            this.endModify(true);
        }
    }

    private void putIfNull(String name, Object value) {
        Object v = this.attributes.get(name);
        if (v == null || "".equals(v)) {
            this.put(name, value);
        }
    }

    public void paste(Map<String, Object> data) {
        this.cognize(data);
    }

    public void paste(String data) throws ParserConfigurationException, SAXException, IOException {
        this.cognize(data);
    }

    public void parseXML(String xml) throws ParserConfigurationException, SAXException, IOException {
        this.cognize(xml);
    }

    public void paste(Thing data) {
        this.cognize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thing detach() {
        Thing newThing = null;
        this.beginModify();
        try {
            newThing = new Thing();
            newThing.attributes.putAll(this.attributes);
            newThing.getMetadata().setId(this.getMetadata().getId());
            HashMap<Thing, Thing> context = new HashMap<Thing, Thing>();
            context.put(this, newThing);
            for (Thing childThing : this.getChilds()) {
                this.addDetachedChild(newThing, childThing, context);
            }
            if (this.get(ORIGIN_THING_PATH) == null) {
                newThing.set(ORIGIN_THING_PATH, this.getMetadata().getPath());
            }
        }
        finally {
            this.endModify(true);
        }
        return newThing;
    }

    public Thing detach(boolean detachToTransient) {
        return this.detach();
    }

    public Object doAction(String name) {
        return this.run(name, new ActionContext(), (Object[])null, false, true);
    }

    public Object doAction(String name, Map<String, Object> parameters) {
        return this.run(name, new ActionContext(), parameters, false, true);
    }

    public Object doAction(String name, ActionContext actionContext) {
        return this.run(name, actionContext, (Map<String, Object>)null, false, true);
    }

    public Object doAction(String name, ActionContext actionContext, Map<String, Object> parameters) {
        return this.run(name, actionContext, parameters, false, true);
    }

    public Object doAction(String name, ActionContext actionContext, Object ... parameters) {
        return this.doAction(name, actionContext, UtilMap.toMap(parameters));
    }

    public Object doAction(String name, ActionContext actionContext, Map<String, Object> parameters, boolean isSubAction) {
        return this.run(name, actionContext, parameters, isSubAction, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(String name, ActionContext context, Map<String, Object> parameters, boolean isSubAction, boolean includeSelf) {
        Thing actionThing = this.getActionThing(name);
        Action action = null;
        if (actionThing == null) {
            return null;
        }
        action = actionThing.getAction();
        if (context == null) {
            context = new ActionContext();
        }
        if (action == null) {
            log.info("thing's action is not found : " + this.getMetadata().getPath() + " : " + name);
            return null;
        }
        World world = World.getInstance();
        if (world.isHaveActionListener()) {
            ActionListener listener = world.getActionListener();
            try {
                listener.actionExecuted(this, name, context, parameters, System.currentTimeMillis(), true);
            }
            catch (Throwable t) {
                log.error("ActionRecorder error", t);
            }
        }
        if (includeSelf) {
            Bindings bindings = context.pushPoolBindings();
            bindings.setCaller(this, name);
            bindings.put("self", this);
            try {
                this.fireGlobalContextDoActionEvent(name, parameters, context);
                Object object = action.runMapParams(context, parameters, this, isSubAction);
                return object;
            }
            finally {
                context.pop();
            }
        }
        context.peek().setCaller(this, name);
        this.fireGlobalContextDoActionEvent(name, parameters, context);
        return action.runMapParams(context, parameters, this, isSubAction);
    }

    public void fireGlobalContextDoActionEvent(String name, Map<String, Object> params, ActionContext actionContext) {
        World world = World.getInstance();
        if (world.globalContexts != null && world.globalContexts.size() > 0) {
            for (ThingEntry contextEntry : world.globalContexts) {
                Thing context = contextEntry.getThing();
                if (context == null || context == this) continue;
                context.doAction("onDoAction", actionContext, THING, this, "actionName", name, "params", params);
            }
        }
    }

    public Object exec(String name, ActionContext context, Object ... params) {
        return this.run(name, context, params, false, false);
    }

    public Object exec(String name, Object ... params) {
        return this.run(name, null, params, false, false);
    }

    public Object doExec(String name, ActionContext context, Object ... params) {
        return this.run(name, context, params, false, true);
    }

    public Object doExec(String name, Object ... params) {
        return this.run(name, null, params, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(String name, ActionContext context, Object[] parameters, boolean isSubAction, boolean includeSelf) {
        Thing actionThing = this.getActionThing(name);
        Action action = null;
        if (actionThing == null) {
            return null;
        }
        action = actionThing.getAction();
        if (context == null) {
            context = new ActionContext();
        }
        if (action == null) {
            log.info("thing's action is not found : " + this.getMetadata().getPath() + " : " + name);
            return null;
        }
        if (includeSelf) {
            Bindings bindings = context.pushPoolBindings();
            bindings.setCaller(this, name);
            bindings.put("self", this);
            try {
                Object object = action.runArrayParams(context, parameters, this, isSubAction);
                return object;
            }
            finally {
                context.pop();
            }
        }
        return action.runArrayParams(context, parameters, this, isSubAction);
    }

    public Object run(String name, ActionContext context, Map<String, Object> parameters, boolean isSubAction) {
        return this.run(name, context, parameters, isSubAction, false);
    }

    public Object run(String name, ActionContext context, Map<String, Object> parameters) {
        return this.run(name, context, parameters, false, false);
    }

    public Object run(String name, ActionContext context) {
        return this.run(name, context, (Object[])null, false, false);
    }

    public Object run(String name, Map<String, Object> parameters) {
        return this.run(name, null, parameters, false, false);
    }

    public Object run(String name) {
        return this.run(name, null, (Object[])null, false, false);
    }

    public Object get(Path path) {
        if (path == null || path.getChildPath() == null) {
            return this;
        }
        Path lastChildPath = path;
        Path childPath = path.getChildPath();
        Thing currentThing = this;
        Thing nextCurrentThing = null;
        block9: while (childPath != null && currentThing != null) {
            switch (childPath.getType()) {
                case 4: {
                    ArrayList<Thing> childThings = new ArrayList<Thing>();
                    Iterator<Thing> iter = currentThing.getChildsIterator();
                    while (iter.hasNext()) {
                        Thing child = iter.next();
                        if (childPath.getThingName() != null && !"".equals(childPath.getThingName()) && !child.isThingByName(childPath.getThingName())) continue;
                        childThings.add(child);
                    }
                    return childThings;
                }
                case 5: {
                    Thing child;
                    int index = 0;
                    nextCurrentThing = null;
                    Iterator<Thing> iter = currentThing.getChildsIterator();
                    while (iter.hasNext()) {
                        child = iter.next();
                        if (childPath.getThingName() != null && !"".equals(childPath.getThingName()) && !child.isThingByName(childPath.getThingName())) continue;
                        if (childPath.getIndex() == index) {
                            nextCurrentThing = child;
                            lastChildPath = childPath;
                            childPath = childPath.getChildPath();
                            break;
                        }
                        ++index;
                    }
                    currentThing = nextCurrentThing;
                    continue block9;
                }
                case 7: {
                    Thing child;
                    nextCurrentThing = null;
                    Iterator<Thing> iter = currentThing.getChildsIterator();
                    while (iter.hasNext()) {
                        child = iter.next();
                        if (!child.getMetadata().getId().equals(childPath.getThingId())) continue;
                        nextCurrentThing = child;
                        lastChildPath = childPath;
                        childPath = childPath.getChildPath();
                        break;
                    }
                    currentThing = nextCurrentThing;
                    continue block9;
                }
                case 3: {
                    return currentThing.get(childPath.getAttributeName());
                }
                case 8: {
                    short index1 = 0;
                    nextCurrentThing = null;
                    Iterator<Thing> iter = currentThing.getChildsIterator();
                    while (iter.hasNext()) {
                        Thing child = iter.next();
                        if (childPath.getThingName() != null && !"".equals(childPath.getThingName()) && !child.isThingByName(childPath.getThingName())) continue;
                        if (child.getMetadata().getId().equals(childPath.getThingId())) {
                            nextCurrentThing = child;
                            lastChildPath = childPath;
                            childPath = childPath.getChildPath();
                            break;
                        }
                        try {
                            if (index1 == Short.parseShort(childPath.getThingId())) {
                                nextCurrentThing = child;
                                lastChildPath = childPath;
                                childPath = childPath.getChildPath();
                                break;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index1;
                    }
                    currentThing = nextCurrentThing;
                    continue block9;
                }
            }
        }
        if (currentThing == null) {
            return this.getNullReturn(lastChildPath);
        }
        if (childPath == null) {
            return currentThing;
        }
        return null;
    }

    public Object get(String path) {
        if (path == null || "".equals(path)) {
            return this;
        }
        String[] paths = UtilString.split(path, '/');
        Thing current = this;
        for (int i = 0; i < paths.length; ++i) {
            if (current == null) {
                return this.getNullReturn(path);
            }
            String p = paths[i];
            if (p.equals("")) continue;
            String[] ps = UtilString.split(p, '@');
            if (ps.length == 1) {
                if (i < paths.length - 1) {
                    return this.getNullReturn(path);
                }
                if (p.endsWith("@")) {
                    return current.getAllChilds(ps[0]);
                }
                return current.getAttribute(ps[0]);
            }
            if (ps.length == 2 && ps[1].equals("")) {
                if (i < paths.length - 1) {
                    return this.getNullReturn(path);
                }
                if ("".equals(ps[0])) {
                    return current.getChilds();
                }
                return current.getAllChilds(ps[0]);
            }
            if (ps.length == 2) {
                boolean setted = false;
                boolean isByName = false;
                String compareStr = ps[1];
                if (compareStr.startsWith("?")) {
                    isByName = true;
                    compareStr = compareStr.substring(1, compareStr.length());
                }
                Iterator<Thing> iter = current.getChildsIterator();
                while (iter.hasNext()) {
                    Thing currentChild = iter.next();
                    if (!ps[0].equals("") && !currentChild.isThingByName(ps[0]) || (isByName || !compareStr.equals(currentChild.getMetadata().getId())) && (!isByName || !compareStr.equals(currentChild.getMetadata().getName()))) continue;
                    current = currentChild;
                    setted = true;
                    break;
                }
                if (!setted) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(ps[1]);
                    }
                    catch (Exception currentChild) {
                        // empty catch block
                    }
                    if (index != -1) {
                        int n = 0;
                        Iterator<Thing> iter2 = current.getChildsIterator();
                        while (iter2.hasNext()) {
                            Thing currentChild = iter2.next();
                            if (!ps[0].equals("") && !currentChild.isThingByName(ps[0])) continue;
                            if (n == index) {
                                current = currentChild;
                                setted = true;
                                break;
                            }
                            ++n;
                        }
                    } else {
                        return null;
                    }
                }
                if (setted) continue;
                return this.getNullReturn(path);
            }
            return this.getNullReturn(path);
        }
        return current;
    }

    private Thing getSelfActionThing(String name, Map<Thing, Object> context, LinkedThingEntry linkedThingEntry) {
        if (context.get(this) != null) {
            return null;
        }
        context.put(this, this);
        Thing actionSet = null;
        for (Thing child : this.getChilds()) {
            if (!child.isThingByName("actions")) continue;
            actionSet = child;
            break;
        }
        if (actionSet != null) {
            for (Thing child : actionSet.getChilds()) {
                if (!child.getMetadata().getName().equals(name)) continue;
                linkedThingEntry.addThing(child);
                return child;
            }
        }
        return null;
    }

    private Thing getActionThing(String name, Map<Thing, Object> context, Map<Thing, Object> superContext, LinkedThingEntry linkedThingEntry) {
        Thing actionThing = this.getSelfActionThing(name, context, linkedThingEntry);
        if (actionThing == null) {
            actionThing = this.getSuperActionThing(name, context, superContext, linkedThingEntry);
        }
        return actionThing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thing getSuperActionThing(String name, Map<Thing, Object> context, Map<Thing, Object> superContext, LinkedThingEntry linkedThingEntry) {
        Thing actionThing;
        block12: {
            actionThing = null;
            if (superContext.get(this) != null) {
                return null;
            }
            superContext.put(this, this);
            linkedThingEntry.addThing(this);
            try {
                Thing descriptor;
                Iterator<Thing> iterator;
                if (actionThing == null) {
                    iterator = this.getDescriptors().iterator();
                    while (iterator.hasNext() && (actionThing = (descriptor = iterator.next()).getSelfActionThing(name, context, linkedThingEntry)) == null) {
                    }
                }
                if (actionThing == null) {
                    Thing extend;
                    iterator = this.getExtends().iterator();
                    while (iterator.hasNext() && (actionThing = (extend = iterator.next()).getSelfActionThing(name, context, linkedThingEntry)) == null) {
                    }
                }
                if (actionThing == null) {
                    iterator = this.getDescriptors().iterator();
                    while (iterator.hasNext() && (actionThing = (descriptor = iterator.next()).getSuperActionThing(name, context, superContext, linkedThingEntry)) == null) {
                    }
                }
                if (actionThing != null) break block12;
                for (Thing extend : this.getExtends()) {
                    actionThing = extend.getSuperActionThing(name, context, superContext, linkedThingEntry);
                    if (actionThing == null) continue;
                    break;
                }
            }
            finally {
                if (actionThing == null) {
                    linkedThingEntry.removeLast();
                }
            }
        }
        return actionThing;
    }

    public Thing getActionThing(String name) {
        Thing thing;
        if (name == null || "".equals(name)) {
            return null;
        }
        Thing actionThing = null;
        LinkedThingEntry linkedThingEntry = this.actionCaches.get(name);
        if (linkedThingEntry != null && (thing = linkedThingEntry.getThing()) != null) {
            return thing;
        }
        linkedThingEntry = new LinkedThingEntry();
        HashMap<Thing, Object> context = new HashMap<Thing, Object>();
        HashMap<Thing, Object> superContext = new HashMap<Thing, Object>();
        actionThing = name.startsWith("super.") ? this.getSuperActionThing(name.substring(6, name.length()), context, superContext, linkedThingEntry) : this.getActionThing(name, context, superContext, linkedThingEntry);
        if (actionThing != null) {
            this.actionCaches.put(name, linkedThingEntry);
        }
        return actionThing;
    }

    private void addToSourceByName(List<Thing> srcs, Thing forAdd) {
        boolean have = false;
        String forAddName = forAdd.getMetadata().getName();
        for (Thing src : srcs) {
            if (!src.getMetadata().getName().equals(forAddName)) continue;
            have = true;
            break;
        }
        if (!have) {
            srcs.add(forAdd);
        }
    }

    public Action getAction() {
        if (this.action == null) {
            this.action = new Action(this);
        }
        return this.action;
    }

    public Runnable getRunnable(ActionContext actionContext) {
        return new ThingRunnable(this, actionContext, null);
    }

    public Runnable getRunnable(ActionContext actionContext, Map<String, Object> params) {
        return new ThingRunnable(this, actionContext, params);
    }

    public Callable<Object> getCallable(ActionContext actionContext) {
        return new ThingCallable(this, actionContext, null);
    }

    public Callable<Object> getCallable(ActionContext actionContext, Map<String, Object> params) {
        return new ThingCallable(this, actionContext, params);
    }

    public List<Thing> getActionsThings() {
        return this.getActionThings();
    }

    public List<Thing> getActionThings() {
        Thing descActionSet;
        ArrayList<Thing> actionThings = new ArrayList<Thing>();
        Thing actionSet = null;
        for (Thing child : this.childs) {
            if (!child.isThingByName("actions")) continue;
            actionSet = child;
            break;
        }
        if (actionSet != null) {
            for (Thing child : actionSet.getAllChilds()) {
                this.addToSourceByName(actionThings, child);
            }
        }
        for (Thing descriptor : this.getAllDescriptors()) {
            descActionSet = descriptor.getThing("actions@0");
            if (descActionSet == null) continue;
            for (Thing child : descActionSet.getAllChilds()) {
                this.addToSourceByName(actionThings, child);
            }
        }
        for (Thing extend : this.getAllExtends()) {
            descActionSet = extend.getThing("actions@0");
            if (descActionSet == null) continue;
            for (Thing child : descActionSet.getAllChilds()) {
                this.addToSourceByName(actionThings, child);
            }
        }
        return actionThings;
    }

    public List<Thing> getAllAttributesDescriptors() {
        ArrayList<Thing> attributesDescriptors = new ArrayList<Thing>();
        List<Thing> selfDescriptors = this.getDescriptors();
        for (Thing descriptor : selfDescriptors) {
            UtilData.addToSource(attributesDescriptors, descriptor.getAllChilds(ATTRIBUTE), false);
        }
        return attributesDescriptors;
    }

    public List<Thing> getAllChilds() {
        ArrayList<Thing> childList = new ArrayList<Thing>();
        childList.addAll(this.getChilds());
        for (Thing thing : this.getAllExtends()) {
            for (Thing child : thing.childs) {
                if ("private".equals(child.getString("modifier"))) continue;
                childList.add(child);
            }
        }
        return childList;
    }

    public List<Thing> getAllChilds(String thingName) {
        ArrayList<Thing> childs = new ArrayList<Thing>();
        Iterator<Thing> iter = this.getChildsIterator();
        while (iter.hasNext()) {
            Thing child = iter.next();
            if (!child.isThingByName(thingName) || "private".equals(child.getString("modifier")) && child.getParent() != this) continue;
            UtilData.addToSource(childs, child, true);
        }
        return childs;
    }

    public List<Thing> getAllChildsDescriptors() {
        ArrayList<Thing> childsDescriptors = new ArrayList<Thing>();
        for (Thing descriptor : this.getDescriptors()) {
            UtilData.addToSource(childsDescriptors, descriptor.getAllChilds(THING), false);
        }
        return childsDescriptors;
    }

    public List<Thing> getAllExtends() {
        ArrayList<Thing> extendList = new ArrayList<Thing>();
        HashMap<Thing, Object> context = new HashMap<Thing, Object>();
        HashMap<Thing, Object> extendCache = new HashMap<Thing, Object>();
        this.getAllExtends(this, extendList, context, extendCache);
        return extendList;
    }

    private void getAllExtends(Thing thing, List<Thing> extendList, Map<Thing, Object> context, Map<Thing, Object> extendCache) {
        if (context.get(thing) == null) {
            context.put(thing, thing);
            List<Thing> exts = thing.getExtends();
            for (Thing ext : exts) {
                if (extendCache.get(ext) != null) continue;
                extendList.add(ext);
                this.getAllExtends(ext, extendList, context, extendCache);
            }
        }
    }

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value != null) {
            return value;
        }
        return null;
    }

    private Thing getAttributeDescriptor(Map<Thing, Object> context, String name) {
        if (context.get(this) == null) {
            context.put(this, this);
            List<Thing> attributesDescriptors = this.getAllAttributesDescriptors();
            for (Thing attrDescriptor : attributesDescriptors) {
                if (!attrDescriptor.getMetadata().getName().equals(name)) continue;
                return attrDescriptor;
            }
            for (Thing extend : this.getExtends()) {
                Thing attrDescriptor = extend.getAttributeDescriptor(context, name);
                if (attrDescriptor == null) continue;
                return attrDescriptor;
            }
            return null;
        }
        return null;
    }

    public Thing getAttributeDescriptor(String name) {
        HashMap<Thing, Object> context = new HashMap<Thing, Object>();
        return this.getAttributeDescriptor(context, name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<Thing> getAttributesDescriptors() {
        List<Thing> selfDescriptors = this.getDescriptors();
        Iterator<Thing> iterator = selfDescriptors.iterator();
        if (iterator.hasNext()) {
            Thing descriptor = iterator.next();
            List<Thing> attrDescriptors = descriptor.getChilds(ATTRIBUTE);
            return attrDescriptors;
        }
        return Collections.emptyList();
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, null);
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        return UtilData.getBigDecimal(this.getAttribute(name), defaultValue);
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getBigDecimal(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public BigInteger getBigInteger(String name) {
        return this.getBigInteger(name, null);
    }

    public BigInteger getBigInteger(String name, BigInteger defaultValue) {
        return UtilData.getBigInteger(this.getAttribute(name), defaultValue);
    }

    public BigInteger getBigInteger(String name, BigInteger defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getBigInteger(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return UtilData.getBoolean(this.getAttribute(name), defaultValue);
    }

    public boolean getBoolean(String name, boolean defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getBoolean(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte getByte(String name, byte defaultValue) {
        return UtilData.getByte(this.getAttribute(name), defaultValue);
    }

    public byte getByte(String name, byte defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getByte(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public byte[] getBytes(String name) {
        return this.getBytes(name, null);
    }

    public byte[] getBytes(String name, byte[] defaultValue) {
        return UtilData.getBytes(this.getAttribute(name), defaultValue);
    }

    public byte[] getBytes(String name, byte[] defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getBytes(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public char getChar(String name) {
        return this.getChar(name, '\u0000');
    }

    public char getChar(String name, char defaultValue) {
        return UtilData.getChar(this.getAttribute(name), defaultValue);
    }

    public char getChar(String name, char defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getChar(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public List<Thing> getChilds() {
        return this.childs;
    }

    public List<Thing> getChilds(String thingName) {
        ArrayList<Thing> childThings = new ArrayList<Thing>();
        for (Thing child : this.getChilds()) {
            if (!child.isThingByName(thingName)) continue;
            UtilData.addToSource(childThings, child, true);
        }
        return childThings;
    }

    public List<Thing> getChildsDescriptors() {
        List<Thing> selfDescriptors = this.getDescriptors();
        return selfDescriptors.get(0).getAllChilds(THING);
    }

    public Date getDate(String name) {
        return this.getDate(name, null);
    }

    public Date getDate(String name, Date defaultValue) {
        return UtilData.getDate(this.getAttribute(name), defaultValue);
    }

    public Date getDate(String name, Date defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getDate(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public Thing getClassThing() {
        return this.getDescriptor();
    }

    public List<Thing> getClasses() {
        return this.getDescriptors();
    }

    public Thing getDescriptor() {
        return this.getDescriptors().get(0);
    }

    public List<Thing> getDescriptors() {
        World world = World.getInstance();
        ArrayList<Thing> descriptors = new ArrayList<Thing>();
        if (this.descriptorsCaches == null || this.descriptorsCaches.length == 0) {
            this.initDescriptors();
        }
        for (int i = 0; i < this.descriptorsCaches.length; ++i) {
            ThingEntry entry = this.descriptorsCaches[i];
            if (entry == null) continue;
            Thing thing = entry.getThing();
            if (thing == null) {
                this.removeDescriptorsCache(i);
                continue;
            }
            descriptors.add(thing);
        }
        if (world.metaThing != null) {
            descriptors.add(world.metaThing);
        }
        return descriptors;
    }

    public List<Thing> getAllDescriptors() {
        ArrayList<Thing> descriptors = new ArrayList<Thing>();
        ArrayList<Thing> extendsList = new ArrayList<Thing>();
        HashMap<Thing, Object> caches = new HashMap<Thing, Object>();
        HashMap<Thing, Object> context = new HashMap<Thing, Object>();
        if (this.descriptorsCaches == null || this.descriptorsCaches.length == 0) {
            this.initDescriptors();
        }
        for (int i = 0; i < this.descriptorsCaches.length; ++i) {
            ThingEntry entry = this.descriptorsCaches[i];
            if (entry == null) continue;
            Thing thing = entry.getThing();
            if (thing == null) {
                this.removeDescriptorsCache(i);
                continue;
            }
            descriptors.add(thing);
            caches.put(thing, thing);
            thing.getAllExtends(thing, extendsList, context, caches);
        }
        for (Thing desc : extendsList) {
            descriptors.add(desc);
        }
        if (caches.get(World.getInstance().metaThing) == null) {
            descriptors.add(World.getInstance().metaThing);
        }
        return descriptors;
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defaultValue) {
        return UtilData.getDouble(this.getAttribute(name), defaultValue);
    }

    public double getDouble(String name, double defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getDouble(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public List<Thing> getExtends() {
        ArrayList<Thing> extendList = new ArrayList<Thing>();
        if (this.extendsCaches == null) {
            this.initExtends();
        }
        for (int i = 0; i < this.extendsCaches.length; ++i) {
            ThingEntry entry = this.extendsCaches[i];
            if (entry == null) continue;
            Thing thing = entry.getThing();
            if (thing == null) {
                this.removeExtendsCache(i);
                continue;
            }
            extendList.add(thing);
        }
        return extendList;
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float defaultValue) {
        return UtilData.getFloat(this.getAttribute(name), defaultValue);
    }

    public float getFloat(String name, float defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getFloat(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        int value = UtilData.getInt(this.getAttribute(name), defaultValue);
        return value;
    }

    public int getInt(String name, int defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getInt(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public Object getObject(String name, ActionContext actionContext) throws OgnlException {
        Object value = this.get(name);
        if (value != null && value instanceof String) {
            String str = (String)value;
            if (str.startsWith("var:")) {
                return actionContext.get(str.substring(4, str.length()));
            }
            if (str.startsWith("ognl:")) {
                return OgnlUtil.getValue(this, name, actionContext);
            }
            if (str.startsWith("thing:")) {
                String thingPath = str.substring(6, str.length());
                return World.getInstance().getThing(thingPath);
            }
            if ("".equals(str)) {
                return null;
            }
            return actionContext.get(str);
        }
        return value;
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long getLong(String name, long defaultValue) {
        return UtilData.getLong(this.getAttribute(name), defaultValue);
    }

    public long getLong(String name, long defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getLong(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public ThingMetadata getMetadata() {
        return this.metadata;
    }

    private Object getNullReturn(String path) {
        if (path.endsWith("@")) {
            return Collections.emptyList();
        }
        return null;
    }

    private Object getNullReturn(Path path) {
        while (path.getChildPath() != null) {
            path = path.getChildPath();
        }
        if (path.getType() == 4) {
            return Collections.emptyList();
        }
        return null;
    }

    public Thing getParent() {
        return this.parent;
    }

    public Thing getRoot() {
        HashMap<Thing, Thing> context = new HashMap<Thing, Thing>();
        if (this.parent == null) {
            return this;
        }
        Thing currentParent = this.parent;
        while (context.get(currentParent) == null) {
            if (currentParent.parent == null) {
                return currentParent;
            }
            context.put(currentParent, this.parent);
            currentParent = currentParent.parent;
        }
        return currentParent;
    }

    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    public short getShort(String name, short defaultValue) {
        return UtilData.getShort(this.getAttribute(name), defaultValue);
    }

    public short getShort(String name, short defaultValue, ActionContext actionContext) throws OgnlException {
        return UtilData.getShort(UtilData.getData(this, name, actionContext), defaultValue);
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getStringBlankAsNull(String name) {
        String attr = this.getString(name);
        if (attr != null) {
            attr = attr.trim();
        }
        if (attr == null || "".equals(attr)) {
            return null;
        }
        return attr;
    }

    public String getString(String name, String defaultValue) {
        return UtilData.getString(this.getAttribute(name), defaultValue);
    }

    public String getString(String name, String defaultValue, ActionContext actionContext) {
        String value = UtilString.getString(this, name, actionContext);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return value;
    }

    public Thing getThing(String childThingPath) {
        Object obj = this.get(childThingPath);
        if (obj instanceof Thing) {
            return (Thing)obj;
        }
        return null;
    }

    public Thing getQuotedThing(String attribute) {
        return UtilThing.getQuoteThing(this, attribute);
    }

    public String getThingName() {
        List<Thing> descriptors = this.getDescriptors();
        return descriptors.get(0).getMetadata().getName();
    }

    public List<String> getThingNames() {
        if (this.thingNames.size() == 0) {
            this.initThingNames();
        }
        return this.thingNames;
    }

    private synchronized void initDescriptors() {
        World world = World.getInstance();
        if (world == null) {
            return;
        }
        this.thingNames.clear();
        ArrayList<ThingEntry> tempList = new ArrayList<ThingEntry>();
        String descriptorsNamesStr = (String)this.attributes.get(DESCRIPTORS);
        if (descriptorsNamesStr != null) {
            String[] descriptorsNames;
            for (String descriptorName : descriptorsNames = UtilString.split(descriptorsNamesStr, ',')) {
                Thing descriptor = world.getThing(descriptorName);
                if (descriptor == null) continue;
                tempList.add(new ThingEntry(descriptorName, descriptor));
            }
        }
        ThingEntry[] tmp = new ThingEntry[tempList.size()];
        tmp = tempList.toArray(tmp);
        this.descriptorsCaches = tmp;
        this.actionCaches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultValue() {
        this.beginModify();
        try {
            Thing descriptor;
            List<Thing> fields = this.getAllAttributesDescriptors();
            for (Thing field : fields) {
                String name = field.getMetadata().getName();
                Object value = this.getAttribute(name);
                if (value != null && !"".equals(value)) continue;
                String defaultValue = field.getString("default");
                if (defaultValue != null && !"".equals(defaultValue)) {
                    this.attributes.put(name, defaultValue);
                    String type = field.getStringBlankAsNull("type");
                    if (type == null) continue;
                    UtilData.resetAttributeByType(this, name, type);
                    continue;
                }
                if (this.getAttributes().containsKey(name)) continue;
            }
            if (this.attributes.get(NAME) == null && (descriptor = this.getDescriptor()) != null) {
                this.attributes.put(NAME, descriptor.get(NAME));
            }
        }
        finally {
            this.endModify(true);
        }
    }

    private void initExtends() {
        World world = World.getInstance();
        if (world == null) {
            return;
        }
        this.extendsCaches = null;
        ArrayList<ThingEntry> tempList = new ArrayList<ThingEntry>();
        String extendsNamesStr = (String)this.attributes.get(EXTENDS);
        if (extendsNamesStr != null) {
            String[] extendsNames;
            for (String extendName : extendsNames = UtilString.split(extendsNamesStr, ',')) {
                if (extendName.equals("_root") && this.getRoot() != this) {
                    tempList.add(new ThingEntry(extendName, this.getRoot()));
                    continue;
                }
                Thing descriptor = world.getThing(extendName);
                if (descriptor == null) continue;
                tempList.add(new ThingEntry(extendName, descriptor));
            }
        }
        this.extendsCaches = new ThingEntry[tempList.size()];
        this.extendsCaches = tempList.toArray(this.extendsCaches);
    }

    private void initThingNames() {
        boolean have;
        this.thingNames.clear();
        List<Thing> descriptors = this.getAllDescriptors();
        for (Thing descriptor : descriptors) {
            have = false;
            for (String name : this.thingNames) {
                if (!name.equals(descriptor.getMetadata().getName())) continue;
                have = true;
                break;
            }
            if (have) continue;
            this.thingNames.add(descriptor.getMetadata().getName());
        }
        for (Thing extend : this.getAllExtends()) {
            have = false;
            for (String name : this.thingNames) {
                if (!name.equals(extend.getMetadata().getName())) continue;
                have = true;
                break;
            }
            if (have) continue;
            this.thingNames.add(extend.getMetadata().getName());
        }
    }

    public void initChildPath() {
        for (Thing child : this.childs) {
            this.initChildMetadata(child);
        }
    }

    protected void initChildMetadata(Thing child) {
        ThingMetadata childMeta = child.getMetadata();
        childMeta.setCategory(this.metadata.getCategory());
        if (this.getRoot() == this) {
            childMeta.setPath(this.metadata.getPath() + "/@" + childMeta.getId());
        } else {
            childMeta.setPath(this.metadata.getPath() + "/@" + childMeta.getId());
        }
        for (Thing childChild : child.getChilds()) {
            child.initChildMetadata(childChild);
        }
    }

    private boolean isThing(Map<Thing, Object> context, Thing descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (context.get(this) == null) {
            context.put(this, this);
            for (Thing mydescriptor : this.getAllDescriptors()) {
                if (!descriptor.getMetadata().getPath().equals(mydescriptor.getMetadata().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isThing(String descriptorPath) {
        Thing descriptor = World.getInstance().getThing(descriptorPath);
        return this.isThing(descriptor);
    }

    public boolean isThing(Thing descriptor) {
        HashMap<Thing, Object> context = new HashMap<Thing, Object>();
        return this.isThing(context, descriptor);
    }

    public boolean isThingByName(String descriptorName) {
        List<Thing> allDescriptors = this.getAllDescriptors();
        for (int i = 0; i < allDescriptors.size() - 1; ++i) {
            Thing descriptor = allDescriptors.get(i);
            if (!descriptor.getMetadata().getName().equals(descriptorName)) continue;
            return true;
        }
        return false;
    }

    private synchronized void removeDescriptorsCache(int index) {
        ThingEntry[] temp = new ThingEntry[this.descriptorsCaches.length - 1];
        for (int i = 0; i < this.descriptorsCaches.length; ++i) {
            if (i < index) {
                temp[i] = this.descriptorsCaches[i];
                continue;
            }
            if (i <= index) continue;
            temp[i - 1] = this.descriptorsCaches[i];
        }
        this.descriptorsCaches = temp;
    }

    private synchronized void removeExtendsCache(int index) {
        ThingEntry[] temp = new ThingEntry[this.extendsCaches.length - 1];
        for (int i = 0; i < this.extendsCaches.length; ++i) {
            if (i < index) {
                temp[i] = this.extendsCaches[i];
                continue;
            }
            if (i <= index) continue;
            temp[i - 1] = this.extendsCaches[i];
        }
        this.extendsCaches = temp;
    }

    public void replace(Thing thing) {
        this.attributes.clear();
        this.childs.clear();
        this.paste(thing);
        this.initChildPath();
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public Iterator<Thing> getChildsIterator() {
        final ArrayList<List<Thing>> allChilds = new ArrayList<List<Thing>>();
        allChilds.add(this.childs);
        for (Thing extend : this.getAllExtends()) {
            allChilds.add(extend.getChilds());
        }
        return new Iterator<Thing>(){
            int currentIndex = 0;
            int currentSubIndex = 0;
            Thing nextChild = null;
            List<Thing> currentList = null;
            boolean inited = false;
            boolean hasNext = false;

            @Override
            public boolean hasNext() {
                if (!this.inited) {
                    this.initCurrent();
                    this.inited = true;
                }
                return this.hasNext;
            }

            public void initCurrent() {
                if (this.currentList == null || this.currentSubIndex == this.currentList.size()) {
                    if (allChilds.size() == this.currentIndex) {
                        this.nextChild = null;
                        this.hasNext = false;
                        return;
                    }
                    this.currentList = (List)allChilds.get(this.currentIndex);
                    ++this.currentIndex;
                    this.currentSubIndex = 0;
                }
                if (this.currentSubIndex < this.currentList.size()) {
                    this.nextChild = this.currentList.get(this.currentSubIndex);
                    this.hasNext = true;
                } else {
                    this.initCurrent();
                }
            }

            @Override
            public Thing next() {
                this.initCurrent();
                this.inited = true;
                Thing next = this.nextChild;
                ++this.currentSubIndex;
                this.initCurrent();
                return next;
            }

            @Override
            public void remove() {
            }
        };
    }

    public Object put(Object name, Object value) {
        if (name == null) {
            return null;
        }
        String key = name.toString();
        String k = nameCache.get(key);
        if (k == null) {
            k = key;
            nameCache.put(k, k);
        }
        this.attributes.put(k, value);
        if (name.equals(DESCRIPTORS)) {
            this.initDescriptors();
            this.actionCaches.clear();
        }
        if (name.equals(EXTENDS)) {
            this.initExtends();
            this.actionCaches.clear();
        }
        this.updateLastModified();
        return value;
    }

    public void putAll(Map<String, Object> values) {
        this.attributes.putAll(values);
        this.updateLastModified();
    }

    public void set(Object name, Object value) {
        this.put(name, value);
    }

    public void setParent(Thing parent) {
        this.parent = parent;
        if (parent != null) {
            this.getMetadata().setPath(parent.getMetadata().getPath() + "/@" + this.getMetadata().getId());
        }
    }

    public void removeDescriptor(Thing descriptor) {
        String descriptorPath;
        if (descriptor == null) {
            return;
        }
        String descriptors = (String)this.attributes.get(DESCRIPTORS);
        if (descriptors.indexOf(descriptorPath = descriptor.getMetadata().getPath()) != -1) {
            descriptors = descriptors.replaceAll("(" + descriptorPath + ",)", "");
        }
        if (descriptors.indexOf(descriptorPath) != -1) {
            descriptors = descriptors.replaceAll("(," + descriptorPath + ")", "");
        }
        if (descriptors.indexOf(descriptorPath) != -1) {
            descriptors = descriptors.replaceAll("(" + descriptorPath + ")", "");
        }
        this.put(DESCRIPTORS, descriptors);
    }

    public void removeChild(Thing child) {
        if (this.childs.contains(child)) {
            child.getMetadata().setRemoved(true);
        }
        child.setParent(null);
        this.childs.remove(child);
        this.updateLastModified();
    }

    public boolean remove() {
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
            return true;
        }
        this.metadata.setRemoved(true);
        this.updateLastModified();
        ThingCache.remove(this.metadata.getPath());
        ThingManager manager = this.metadata.getThingManager();
        if (manager != null) {
            return manager.remove(this);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.metadata.removed = true;
        ThingCache.remove(this.metadata.getPath());
    }

    public void removeExtend(Thing extend) {
        String extendPath;
        if (extend == null) {
            return;
        }
        String extendstr = (String)this.attributes.get(EXTENDS);
        if (extendstr.indexOf(extendPath = extend.getMetadata().getPath()) != -1) {
            extendstr = extendstr.replaceAll("(" + extendPath + ",)", "");
        }
        if (extendstr.indexOf(extendPath) != -1) {
            extendstr = extendstr.replaceAll("(," + extendPath + ")", "");
        }
        if (extendstr.indexOf(extendPath) != -1) {
            extendstr = extendstr.replaceAll("(" + extendPath + ")", "");
        }
        this.put(EXTENDS, extendstr);
    }

    public synchronized boolean save() {
        Thing root = this.getRoot();
        ThingManager manager = root.getMetadata().getThingManager();
        if (manager != null) {
            if (root.getMetadata().getPath() == null || "".equals(root.getMetadata().getPath())) {
                root.getMetadata().initPath();
            }
            boolean saved = manager.save(root);
            if (ThingCache.get(root.getMetadata().getPath()) == null) {
                ThingCache.put(root.getMetadata().getPath(), this);
            }
            return saved;
        }
        return false;
    }

    public void saveAs(String thingManager, String path) {
        Thing thing = this.getRoot();
        String oldPath = thing.getMetadata().getPath();
        int dotIndex = path.lastIndexOf(".");
        String thingName = null;
        String category = null;
        if (dotIndex == -1) {
            category = "";
            thingName = path;
        } else {
            category = path.substring(0, dotIndex);
            thingName = path.substring(dotIndex + 1, path.length());
        }
        ThingManager manager = World.getInstance().getThingManager(thingManager);
        if (manager != null) {
            Category cat;
            if (!"_transient".equals(thingManager) && (thing.isTransient() || this.isTransient())) {
                this.setTransient(false);
            }
            if ((cat = manager.getCategory(category)) == null) {
                manager.createCategory(category);
                cat = manager.getCategory(category);
            }
            thing.getMetadata().setCategory(cat);
            thing.getMetadata().setReserve(thingName);
            thing.getMetadata().initPath();
            if (thing.getMetadata().getCoderType() == null || "".equals(thing.getMetadata().getCoderType())) {
                thing.getMetadata().setCoderType(TxtThingCoder.TYPE);
            }
        } else {
            throw new XMetaException("Thing manager not exists, name=" + thingManager);
        }
        thing.initChildPath();
        ThingUtil.replaceThing(thing, oldPath, path);
        manager.save(thing);
    }

    public Thing copyTo(String thingManager, String category) {
        Thing root = this.getRoot();
        Thing thing = root.detach();
        ThingManager manager = World.getInstance().getThingManager(thingManager);
        if (manager != null) {
            Category cat = manager.getCategory(category);
            if (cat == null) {
                manager.createCategory(category);
                cat = manager.getCategory(category);
            }
            thing.getMetadata().setCategory(cat);
            thing.getMetadata().setReserve(root.getMetadata().getReserve());
            thing.getMetadata().initPath();
            thing.getMetadata().setCoderType(root.getMetadata().getCoderType());
            thing.initChildPath();
            manager.save(thing);
            return thing;
        }
        return null;
    }

    public void beginModify() {
        Thread currentThread = Thread.currentThread();
        Stack<Thread> stk = updatingThreads.get(currentThread);
        if (stk == null) {
            stk = new Stack();
            stk.push(currentThread);
            updatingThreads.put(currentThread, stk);
        } else {
            stk.push(currentThread);
        }
    }

    public void endModify(boolean change) {
        Thread currentThread = Thread.currentThread();
        Stack<Thread> stk = updatingThreads.get(currentThread);
        if (stk == null) {
            return;
        }
        stk.pop();
        if (stk.size() == 0) {
            updatingThreads.remove(currentThread);
            if (change) {
                this.updateLastModified();
            }
        }
    }

    private void updateLastModified() {
        Thread currentThread = Thread.currentThread();
        Stack<Thread> stk = updatingThreads.get(currentThread);
        if (stk != null && stk.size() > 0) {
            return;
        }
        HashMap<Thing, Object> context = new HashMap<Thing, Object>();
        long lastModified = System.currentTimeMillis();
        this.getMetadata().setLastModified(lastModified);
        context.put(this, this);
        for (Thing parent = this.getParent(); parent != null && context.get(parent) == null; parent = parent.getParent()) {
            parent.getMetadata().setLastModified(lastModified);
            context.put(parent, parent);
        }
        for (Thing child : this.getChilds()) {
            this.changeChildLastModified(child, context, lastModified);
        }
    }

    private void changeChildLastModified(Thing child, Map<Thing, Object> context, long lastModified) {
        if (context.get(child) == null) {
            child.getMetadata().setLastModified(lastModified);
            context.put(child, child);
            for (Thing childChild : child.getChilds()) {
                this.changeChildLastModified(childChild, context, lastModified);
            }
        }
    }

    public String toString() {
        return "Thing{name=" + this.getMetadata().getName() + ",label=" + this.getMetadata().getLabel() + ",path=" + this.getMetadata().getPath() + ",descriptios=" + this.getString(DESCRIPTORS) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object data) {
        if (key == null) {
            return;
        }
        Thing thing = this;
        synchronized (thing) {
            if (this.datas == null) {
                this.datas = new HashMap<String, Object>();
            }
        }
        this.datas.put(key, data);
    }

    public Object getData(String key) {
        if (this.datas == null) {
            return null;
        }
        return this.datas.get(key);
    }

    public Map<String, Object> getDatas() {
        return this.datas;
    }

    public void setCachedData(String key, Object data) {
        String timeKey = "__" + key + "__Modified__";
        this.datas.put(key, data);
        this.datas.put(timeKey, this.getMetadata().getLastModified());
    }

    public Object getCachedData(String key) {
        String timeKey = "__" + key + "__Modified__";
        Object data = this.datas.get(key);
        Long lastTime = (Long)this.datas.get(timeKey);
        if (lastTime == null || lastTime.longValue() != this.getMetadata().getLastModified()) {
            return null;
        }
        return data;
    }

    public void setTransient(boolean isTransient) {
        this.setTransient(isTransient, new HashMap<Thing, Thing>());
    }

    private void setTransient(boolean isTransient, Map<Thing, Thing> context) {
        if (context.get(this) != null) {
            return;
        }
        context.put(this, this);
        this.isTransient = isTransient;
        for (Thing child : this.childs) {
            child.setTransient(isTransient, context);
        }
    }

    public <T> T getObject(String key) {
        return (T)this.get(key);
    }
}

