/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.ActionListener;
import org.xmeta.Category;
import org.xmeta.CategoryCache;
import org.xmeta.Help;
import org.xmeta.MetaThing;
import org.xmeta.Path;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingManager;
import org.xmeta.ThingManagerListener;
import org.xmeta.ThingMetadata;
import org.xmeta.XMetaException;
import org.xmeta.cache.ThingCache;
import org.xmeta.cache.ThingEntry;
import org.xmeta.codes.DmlThingCoder;
import org.xmeta.codes.JsonThingCoder;
import org.xmeta.codes.PropertyThingCoder;
import org.xmeta.codes.TxtThingCoder;
import org.xmeta.codes.XerThingCoder;
import org.xmeta.codes.XmlThingCoder;
import org.xmeta.thingManagers.ClassThingManager;
import org.xmeta.thingManagers.FileMonitor;
import org.xmeta.thingManagers.FileThingManager;
import org.xmeta.thingManagers.JarThingManager;
import org.xmeta.thingManagers.TransientThingManager;
import org.xmeta.util.ThingClassLoader;
import org.xmeta.util.ThingOgnlAccessor;
import org.xmeta.util.UtilFile;

public class World {
    private static Logger log = LoggerFactory.getLogger(World.class);
    public static byte MODE_PROGRAMING = 0;
    public static byte MODE_WORKING = 1;
    private static final World worldInstance = new World();
    private TransientThingManager transientThingManager = new TransientThingManager();
    private ClassThingManager classThingManager = new ClassThingManager();
    public Thing metaThing = null;
    protected List<ThingEntry> globalContexts = new CopyOnWriteArrayList<ThingEntry>();
    private String worldPath = ".";
    private Map<String, Object> userDatas = new HashMap<String, Object>();
    private Map<String, List<ThingManagerListener>> thingManagerListeners = new ConcurrentHashMap<String, List<ThingManagerListener>>();
    private ThingClassLoader worldClassLoader = null;
    private ActionListener actionListener = null;
    private List<Help> helps = new ArrayList<Help>();
    public int helpSize = 100;
    private boolean verbose = false;
    private boolean inited = false;
    private byte mode = MODE_PROGRAMING;
    private Map<String, String> verboseThingCache = null;
    private List<ThingManager> thingManagers = new ArrayList<ThingManager>();
    private List<ThingCoder> thingCoders = new ArrayList<ThingCoder>();
    private Map<String, CategoryCache> categoryCaches = new HashMap<String, CategoryCache>();
    private List<String> failureThingManangers = new ArrayList<String>();
    private Map<String, Path> pathCache1 = new ConcurrentHashMap<String, Path>(5000);
    private Map<String, Path> pathCache2 = new ConcurrentHashMap<String, Path>(5000);
    private String OS;
    private String PROCESSOR_ARCHITECTURE;
    private String webFileRoot = null;

    private World() {
        TxtThingCoder txtThingCoder = new TxtThingCoder();
        XmlThingCoder xmlThingCoder = new XmlThingCoder();
        PropertyThingCoder propertyCoder = new PropertyThingCoder();
        DmlThingCoder dmlThingCoder = new DmlThingCoder(xmlThingCoder, txtThingCoder, propertyCoder);
        this.thingCoders.add(dmlThingCoder);
        this.thingCoders.add(txtThingCoder);
        this.thingCoders.add(xmlThingCoder);
        this.thingCoders.add(new XerThingCoder());
        try {
            this.thingCoders.add(new JsonThingCoder());
        }
        catch (Throwable e) {
            log.debug("JsonThingCoder init error, if need json, need Jackson, " + e.getMessage());
        }
        try {
            ThingOgnlAccessor.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static World getInstance() {
        return worldInstance;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public byte getMode() {
        return this.mode;
    }

    public ThingManager createThingManager(String name, String link) {
        File managerRootFile = new File(this.getPath() + "/projects/" + name);
        return this.createThingManager(name, managerRootFile, link);
    }

    public ThingManager createThingManager(String name, File managerRootFile, String link) {
        if (managerRootFile.exists()) {
            throw new XMetaException("ThingManager already exists, name=" + name);
        }
        managerRootFile.mkdirs();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(managerRootFile, "config.properties"));
            fout.write(("link=" + link).getBytes());
        }
        catch (Exception e) {
            throw new XMetaException("create config.properties error, thingManager=" + name, e);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.initThingManager(managerRootFile);
    }

    public List<String> getFailureThingManangers() {
        return this.failureThingManangers;
    }

    public boolean isFailureThingManager(String thingManager) {
        return this.failureThingManangers.contains(thingManager);
    }

    public void removeFailureThingManager(String thingManager) {
        this.failureThingManangers.remove(thingManager);
    }

    public void addGlobalContext(Thing contextThing, int index) {
        boolean have = false;
        for (ThingEntry entry : this.globalContexts) {
            Thing thing = entry.getThing();
            if (thing == null || !thing.getMetadata().getPath().equals(contextThing.getMetadata().getPath())) continue;
            have = true;
            break;
        }
        if (!have) {
            ThingEntry entry = new ThingEntry(contextThing);
            if (index == -1) {
                this.globalContexts.add(entry);
            } else {
                this.globalContexts.add(index, entry);
            }
        }
    }

    public void removeGlobalContext(Thing contextThing) {
        ThingEntry forRemoved = null;
        for (ThingEntry entry : this.globalContexts) {
            Thing thing = entry.getThing();
            if (thing == null || !thing.getMetadata().getPath().equals(contextThing.getMetadata().getPath())) continue;
            forRemoved = entry;
            break;
        }
        if (forRemoved != null) {
            this.globalContexts.remove(forRemoved);
        }
    }

    public Object get(String pathStr) {
        Thing thing;
        if (pathStr == null || "".equals(pathStr)) {
            return this;
        }
        Path path = this.pathCache1.get(pathStr);
        if (path == null) {
            path = this.pathCache2.get(pathStr);
            if (path == null) {
                path = new Path(pathStr);
            }
            this.pathCache1.put(pathStr, path);
        }
        if ((thing = ThingCache.get(path.getPath())) != null && thing.getMetadata().isRemoved()) {
            thing = null;
        }
        if (thing == null) {
            if ("MetaThing".equals(path.getPath())) {
                thing = this.metaThing;
            } else {
                String thingName;
                String categoryPath = path.getPath();
                int index = categoryPath.lastIndexOf(".");
                if (index != -1) {
                    thingName = categoryPath.substring(index + 1, categoryPath.length());
                    categoryPath = categoryPath.substring(0, index);
                } else {
                    thingName = categoryPath;
                    categoryPath = null;
                }
                CategoryCache categoryCache = this.categoryCaches.get(categoryPath);
                if (categoryCache != null) {
                    thing = categoryCache.getThing(path.getPath());
                }
                if (thing != null) {
                    ThingCache.put(path.getPath(), thing);
                } else {
                    for (int i = 0; i < this.thingManagers.size(); ++i) {
                        ThingManager thingManager = this.thingManagers.get(i);
                        thing = thingManager.getThing(path.getPath());
                        if (thing == null) continue;
                        path.setType((byte)2);
                        break;
                    }
                    if (thing != null) {
                        ThingCache.put(path.getPath(), thing);
                        if (categoryCache == null) {
                            categoryCache = new CategoryCache();
                            categoryCache.addCategory(thing.getMetadata().getCategory());
                            this.categoryCaches.put(categoryPath, categoryCache);
                        }
                    } else {
                        categoryCache = this.categoryCaches.get(path.getPath());
                        if (categoryCache != null) {
                            return categoryCache.getCategory();
                        }
                        Category category = null;
                        for (int i = 0; i < this.thingManagers.size(); ++i) {
                            ThingManager thingManager = this.thingManagers.get(i);
                            category = thingManager.getCategory(path.getPath());
                            if (category == null) continue;
                            path.setType((byte)1);
                            categoryCache = this.categoryCaches.get(path.getPath());
                            if (categoryCache == null) {
                                categoryCache = new CategoryCache();
                                categoryCache.addCategory(category);
                                this.categoryCaches.put(path.getPath(), categoryCache);
                            }
                            return category;
                        }
                    }
                }
            }
        }
        if (thing == null) {
            thing = this.loadThingFromClasspath(path.getPath());
        }
        if (thing != null) {
            return thing.get(path);
        }
        return null;
    }

    private void printVerbose(String thingPath) {
        if (this.verboseThingCache == null) {
            this.verboseThingCache = new HashMap<String, String>();
        }
        if (this.verboseThingCache.get(thingPath) == null) {
            this.verboseThingCache.put(thingPath, thingPath);
            System.out.println("[Loaded " + thingPath + " from X-Meta");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Thing loadThingFromClasspath(String thingPath) {
        Thing thing = null;
        Iterator<ThingCoder> iterator = this.thingCoders.iterator();
        while (iterator.hasNext()) {
            ThingCoder coder = iterator.next();
            String resource = thingPath.replace('.', '/') + "." + coder.getType();
            URL url = this.getClassLoader().getResource(resource);
            if (url == null) continue;
            thing = new Thing(null, null, null, false);
            ThingMetadata metadata = thing.getMetadata();
            metadata.setPath(thingPath);
            String categoryPath = thingPath;
            if (thingPath.lastIndexOf(".") != -1) {
                categoryPath = thingPath.substring(0, thingPath.lastIndexOf("."));
            }
            Category category = this.classThingManager.getCategory(categoryPath);
            metadata.setCategory(category);
            try {
                InputStream fin = url.openStream();
                try {
                    File file;
                    thing.beginModify();
                    long lastModified = 0L;
                    String fileName = url.getFile();
                    if (fileName != null && (file = new File(fileName)).exists()) {
                        lastModified = file.lastModified();
                    }
                    coder.decode(thing, fin, lastModified);
                }
                catch (Exception e) {
                    System.out.println("load thing error, thingPath=" + thingPath);
                    e.printStackTrace();
                    Thing thing2 = null;
                    return thing2;
                }
                finally {
                    if (thing != null) {
                        thing.endModify(false);
                    }
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (url.getProtocol().toLowerCase().equals("file")) {
                    FileMonitor.getInstance().addFile(thingPath, thing, new File(url.getFile()));
                }
                ThingCache.put(metadata.getPath(), thing);
                return thing;
            }
            catch (IOException e) {
                log.error("load thing from classpath error", (Throwable)e);
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).startsWith("world|")) {
            path = World.getInstance().getPath() + "/" + path.substring(6, path.length());
            File file = new File(path);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            return this.getClassLoader().getResourceAsStream("/" + path.substring(6, path.length()));
        }
        if (path.startsWith("project|") || path.indexOf(":") != -1) {
            int index = path.indexOf(":");
            String projectName = null;
            projectName = path.startsWith("project|") ? path.substring(8, index) : path.substring(0, index);
            path = path.substring(index + 1, path.length());
            path = "/" + projectName + "/" + path;
            for (ThingManager thingManager : this.getThingManagers()) {
                InputStream in = thingManager.getResourceAsStream(path);
                if (in == null) continue;
                return in;
            }
            return this.getClassLoader().getResourceAsStream(path);
        }
        File file = new File(path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        file = new File(this.getPath() + "/webroot/" + path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        for (ThingManager thingManager : this.getThingManagers()) {
            InputStream in = thingManager.getResourceAsStream(path);
            if (in == null) continue;
            return in;
        }
        InputStream in = this.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            in = path.startsWith("/") || path.startsWith("\\") ? this.getClassLoader().getResourceAsStream(path.substring(1, path.length())) : this.getClassLoader().getResourceAsStream("/" + path);
        }
        return in;
    }

    public Action getAction(String actionPath) {
        Thing actionThing = this.getThing(actionPath);
        if (actionThing != null) {
            return actionThing.getAction();
        }
        return null;
    }

    public Class getActionClass(String actionPath, ActionContext actionContext) {
        return this.getActionClass(this.getThing(actionPath), actionContext);
    }

    public Class getActionClass(Thing actionThing, ActionContext actionContext) {
        if (actionThing != null) {
            return actionThing.getAction().getActionClass(actionContext);
        }
        return null;
    }

    public Action getAction(Thing actionThing) {
        return actionThing.getAction();
    }

    public Object getData(String key) {
        return this.userDatas.get(key);
    }

    public String getPath() {
        return this.worldPath;
    }

    public void debug(ActionContext actionContext) {
        Thing debugAction = this.getThing("xworker.ide.debug.action.DebugAction");
        if (debugAction != null) {
            debugAction.doAction("debug", actionContext);
        }
    }

    public Thing getThing(String path) {
        Object obj = this.get(path);
        if (obj instanceof Thing) {
            return (Thing)obj;
        }
        return null;
    }

    public Thing getThing(String path, String thingManager, String descriptor) {
        Thing thing = this.getThing(path);
        if (thing == null) {
            thing = new Thing(descriptor);
            thing.initDefaultValue();
            thing.saveAs(thingManager, path);
        }
        return thing;
    }

    public List<ThingManager> getThingManagers() {
        return this.thingManagers;
    }

    public List<ThingManagerListener> getThingManagerListeners(String thingManagerName) {
        ArrayList<ThingManagerListener> ls = new ArrayList<ThingManagerListener>();
        List<ThingManagerListener> listeners = this.thingManagerListeners.get(thingManagerName);
        if (listeners != null) {
            ls.addAll(listeners);
        }
        if ((listeners = this.thingManagerListeners.get("*")) != null) {
            ls.addAll(listeners);
        }
        return ls;
    }

    public ThingClassLoader getClassLoader() {
        return this.worldClassLoader;
    }

    private void initLibraryPath() {
        File f = new File(this.worldPath);
        String libraryPath = System.getProperty("java.library.path");
        String path = new File(f, "library/" + this.OS).getAbsolutePath();
        libraryPath = libraryPath + File.pathSeparator + path;
        World.addLibraryDir(path);
        path = new File(f, "library/" + this.OS + "/" + this.PROCESSOR_ARCHITECTURE).getAbsolutePath();
        libraryPath = libraryPath + File.pathSeparator + path;
        World.addLibraryDir(path);
        System.setProperty("java.library.path", libraryPath);
    }

    private void initOsProperites() {
        try {
            try {
                this.OS = System.getenv("OS").toLowerCase();
            }
            catch (Exception e) {
                this.OS = System.getProperty("os.name").toLowerCase();
            }
            this.PROCESSOR_ARCHITECTURE = "bit" + System.getProperty("sun.arch.data.model");
            InputStream osin = World.class.getResourceAsStream("/xworker_os.properties");
            if (osin != null) {
                Properties p = new Properties();
                p.load(osin);
                osin.close();
                String value = p.getProperty(this.OS);
                if (value != null && !"".equals(value)) {
                    this.OS = value;
                }
                if ((value = p.getProperty(this.PROCESSOR_ARCHITECTURE)) != null && !"".equals(value)) {
                    this.PROCESSOR_ARCHITECTURE = value;
                }
            }
            log.info("OS=" + this.OS + ", sun.arch.data.model=" + this.PROCESSOR_ARCHITECTURE);
        }
        catch (Exception e) {
            log.error("init os info error", (Throwable)e);
        }
    }

    public void init(String worldPath) {
        if (worldPath == null) {
            String home = System.getProperty("xmeta_home");
            if (home == null) {
                home = System.getProperty("XMETA_HOME");
            }
            if (home == null) {
                home = System.getenv("xmeta_home");
            }
            if (home == null) {
                home = System.getenv("XMETA_HOME");
            }
            worldPath = home == null ? "." : home;
        }
        ThingCache.clear();
        File f = new File(worldPath);
        this.worldPath = f.getAbsolutePath();
        this.initOsProperites();
        this.worldClassLoader = new ThingClassLoader(Thread.currentThread().getContextClassLoader());
        this.initLibraryPath();
        this.metaThing = new MetaThing();
        this.thingManagers.clear();
        this.refresh();
        this.thingManagers.add(this.transientThingManager);
        this.getClassLoader().initLibs();
        Thing metaThing = this.getThing("xworker.lang.MetaThing");
        if (metaThing != null) {
            metaThing = metaThing.detach();
            metaThing.getMetadata().setPath("xworker.lang.MetaThing");
            metaThing.initChildPath();
            this.metaThing = metaThing;
        }
        this.inited = true;
    }

    public boolean isInited() {
        return this.inited;
    }

    public static void addLibraryDir(String s) {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!s.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
        }
        catch (Exception e) {
            log.error("error on init library path", (Throwable)e);
        }
    }

    public void refresh() {
        HashMap<String, String> context = new HashMap<String, String>();
        for (ThingManager manager : this.thingManagers) {
            context.put(manager.getName(), manager.getName());
        }
        File projectsFiles = new File(this.worldPath, "projects");
        if (projectsFiles.exists()) {
            for (File projectFile : projectsFiles.listFiles()) {
                String name;
                if (projectFile.isFile() || context.get(name = projectFile.getName()) != null) continue;
                this.initThingManager(projectFile);
                context.put(name, name);
            }
        }
    }

    public void registThingManagerListener(String thingManagerName, ThingManagerListener listener) {
        List<ThingManagerListener> listeners = this.thingManagerListeners.get(thingManagerName);
        if (listeners == null) {
            listeners = new ArrayList<ThingManagerListener>();
            this.thingManagerListeners.put(thingManagerName, listeners);
        }
        if (listener != null && !listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void runActionAsync(String actionPath, ActionContext actionContext) {
        this.runActionAsync(actionPath, actionContext, null);
    }

    public void runActionAsync(String actionPath, final ActionContext actionContext, final Map<String, Object> parameters) {
        final Action action = this.getAction(actionPath);
        if (action == null) {
            if (log.isInfoEnabled()) {
                log.info("can not find the action : " + actionPath);
            }
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    action.run(actionContext, parameters);
                }
            }).start();
        }
    }

    public Object runAction(String actionPath, ActionContext actionContext) {
        return this.runAction(actionPath, actionContext, null);
    }

    public Object runAction(String actionPath, ActionContext actionContext, Map<String, Object> parameters) {
        Action action = this.getAction(actionPath);
        if (action == null) {
            if (log.isInfoEnabled()) {
                log.info("can not find the action : " + actionPath);
            }
            return null;
        }
        return action.run(actionContext, parameters);
    }

    public void setData(String key, Object value) {
        if (value == null) {
            this.userDatas.remove(key);
        } else {
            this.userDatas.put(key, value);
        }
    }

    public void removeData(String key) {
        this.userDatas.remove(key);
    }

    public void unregistThingManagerListener(String thingManagerName, ThingManagerListener listener) {
        List<ThingManagerListener> listeners = this.thingManagerListeners.get(thingManagerName);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public boolean isHaveActionListener() {
        return this.actionListener != null;
    }

    public boolean isThingFile(String fileName) {
        for (ThingCoder coder : this.thingCoders) {
            if (!fileName.endsWith("." + coder.getType())) continue;
        }
        return false;
    }

    public void addThingManager(ThingManager thingManager) {
        this.checkIfThingManagerExists(thingManager);
        this.thingManagers.add(thingManager);
    }

    public void addThingManagerFirst(ThingManager thingManager) {
        this.checkIfThingManagerExists(thingManager);
        this.thingManagers.add(0, thingManager);
    }

    private void checkIfThingManagerExists(ThingManager thingManager) {
        for (ThingManager manager : this.thingManagers) {
            if (!manager.getName().equals(thingManager.getName())) continue;
            throw new XMetaException("ThingManager already exists, name=" + manager.getName());
        }
    }

    public ThingManager getThingManager(String name) {
        for (ThingManager manager : this.thingManagers) {
            if (!manager.getName().equals(name)) continue;
            return manager;
        }
        return null;
    }

    public void removeThingManager(ThingManager thingManager) {
        this.removeThingManager(thingManager, true);
    }

    public void removeThingManager(ThingManager thingManager, boolean deleteRes) {
        this.thingManagers.remove(thingManager);
        if (deleteRes && thingManager instanceof FileThingManager) {
            FileThingManager fm = (FileThingManager)thingManager;
            UtilFile.delete(new File(fm.getFilePath()));
        }
    }

    public String getOS() {
        return this.OS;
    }

    public String getJVMBit() {
        return this.PROCESSOR_ARCHITECTURE;
    }

    public ThingManager initThingManager(File rootPath) {
        String thingManagerClass = null;
        String name = rootPath.getName();
        String link = null;
        if (this.isFailureThingManager(name)) {
            return null;
        }
        boolean hasThingsDir = true;
        Properties properties = new Properties();
        if (rootPath.isDirectory()) {
            File configFile = new File(rootPath, "config.properties");
            if (!configFile.exists()) {
                configFile = new File(rootPath, "xworker.properties");
            }
            if (!configFile.exists() && (configFile = new File(rootPath, "dml.prj")).exists()) {
                hasThingsDir = false;
            }
            if (configFile.exists()) {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(configFile);
                    properties.load(fin);
                    String pname = properties.getProperty("projectName");
                    if (pname != null && !"".equals(pname.trim())) {
                        name = pname.trim();
                    }
                    if ((link = properties.getProperty("link")) != null && link.trim().equals("")) {
                        link = null;
                    }
                    thingManagerClass = properties.getProperty("class");
                }
                catch (Exception e) {
                    this.failureThingManangers.add(name);
                    throw new XMetaException("init thing manager error, path=" + rootPath, e);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        boolean isLink = false;
        if (link != null) {
            File linkFile = new File(link);
            if (!linkFile.exists()) {
                linkFile = new File(this.worldPath, link);
            }
            if (!linkFile.exists()) {
                linkFile = new File(rootPath.getParentFile(), link);
            }
            if (linkFile.exists()) {
                isLink = true;
                String linkName = linkFile.getName().toLowerCase();
                if (linkFile.isFile() && (linkName.endsWith(".jar") || linkName.endsWith(".zip"))) {
                    JarThingManager thingManager = new JarThingManager(name, linkFile);
                    this.addThingManager(thingManager);
                    this.getClassLoader().addJarOrZip(linkFile);
                    this.getClassLoader().addJarOrZip(new File(rootPath, "lib"));
                    this.getClassLoader().addJarOrZip(new File(rootPath, "lib_" + this.OS));
                    this.getClassLoader().addJarOrZip(new File(rootPath, "lib_" + this.OS + "_" + this.PROCESSOR_ARCHITECTURE));
                    return thingManager;
                }
                FileThingManager thingManager = new FileThingManager(name, linkFile);
                this.addThingManager(thingManager);
                this.getClassLoader().addJarOrZip(new File(linkFile, "lib"));
                this.getClassLoader().addJarOrZip(new File(linkFile, "lib_" + this.OS));
                this.getClassLoader().addJarOrZip(new File(linkFile, "lib_" + this.OS + "_" + this.PROCESSOR_ARCHITECTURE));
                return thingManager;
            }
        }
        if (!isLink) {
            ThingManager thingManager = null;
            if (thingManagerClass != null) {
                try {
                    Class<?> cls = Class.forName(thingManagerClass);
                    Constructor<?> constructor = cls.getConstructor(String.class, File.class);
                    thingManager = constructor != null ? (ThingManager)constructor.newInstance(name, rootPath) : (ThingManager)cls.newInstance();
                }
                catch (Exception e) {
                    log.warn("can not load thingManager", (Throwable)e);
                }
                if (thingManager == null) {
                    this.failureThingManangers.add(name);
                    return null;
                }
            } else {
                thingManager = new FileThingManager(name, rootPath, hasThingsDir);
            }
            try {
                thingManager.init(properties);
            }
            catch (Exception e) {
                log.warn("init thingManager error", (Throwable)e);
                this.failureThingManangers.add(name);
                return null;
            }
            this.addThingManager(thingManager);
            this.getClassLoader().addJarOrZip(new File(rootPath, "lib"));
            this.getClassLoader().addJarOrZip(new File(rootPath, "lib_" + this.OS));
            this.getClassLoader().addJarOrZip(new File(rootPath, "lib_" + this.OS + "_" + this.PROCESSOR_ARCHITECTURE));
            return thingManager;
        }
        return null;
    }

    public void addHelp(String title, String sourcePath, String helpPath) {
        Help help = new Help(title, sourcePath, helpPath);
        this.helps.add(help);
        if (this.helps.size() > this.helpSize) {
            this.helps.remove(0);
        }
    }

    public List<Help> getHelps() {
        return this.helps;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public TransientThingManager getTransientThingManager() {
        return this.transientThingManager;
    }

    public void registThingCoder(ThingCoder thingCoder) {
        this.thingCoders.add(thingCoder);
    }

    public List<ThingCoder> getThingCoders() {
        return this.thingCoders;
    }

    public ThingCoder getThingCoder(String type) {
        for (ThingCoder thingCoder : this.thingCoders) {
            if (!thingCoder.acceptType(type)) continue;
            return thingCoder;
        }
        return null;
    }

    public String getWebFileRoot() {
        return this.webFileRoot;
    }

    public void setWebFileRoot(String webFileRoot) {
        this.webFileRoot = webFileRoot;
    }

    public void addFileThingManager(String name, File dir, boolean hasThingDir, boolean first) throws IOException {
        File worldDir = new File(this.getPath());
        if (worldDir.getCanonicalFile().equals(dir.getCanonicalFile())) {
            return;
        }
        FileThingManager tm = new FileThingManager(name, dir, hasThingDir);
        if (first) {
            this.addThingManagerFirst(tm);
        } else {
            this.addThingManager(tm);
        }
    }

    public ThingManager getWorkDirThingManager() {
        return this.thingManagers.get(0);
    }
}

