/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmeta.Thing;
import org.xmeta.ThingCoderException;
import org.xmeta.codes.CoderUtils;
import org.xmeta.util.UtilData;
import org.xml.sax.SAXException;

public class XmlCoder {
    public static final String NODE_NAME = "__node__name__";

    public static String encodeToString(Thing thing) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            XmlCoder.encode(thing, bout);
            String string = new String(bout.toByteArray());
            return string;
        }
        catch (Exception e) {
            throw new ThingCoderException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new ThingCoderException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(Thing thing, OutputStream out) throws XMLStreamException, IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out, "utf-8");
        try {
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeCharacters("\n");
            XmlCoder.encode(thing, null, writer, "", false);
            writer.writeEndDocument();
        }
        finally {
            writer.close();
        }
    }

    public static String encodeToString(Thing thing, boolean includeDefaultValue) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            XmlCoder.encode(thing, bout, includeDefaultValue);
            String string = new String(bout.toByteArray());
            return string;
        }
        catch (Exception e) {
            throw new ThingCoderException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new ThingCoderException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(Thing thing, OutputStream out, boolean includeDefaultValue) throws XMLStreamException, IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out, "utf-8");
        try {
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeCharacters("\n");
            XmlCoder.encode(thing, null, writer, "", includeDefaultValue);
            writer.writeEndDocument();
        }
        finally {
            writer.close();
        }
    }

    private static void encode(Thing thing, Thing parentDescriptors, XMLStreamWriter writer, String ident, boolean includeDefaultValue) throws XMLStreamException, IOException {
        writer.writeCharacters("\n" + ident);
        HashMap<String, String> attrContext = new HashMap<String, String>();
        String thingName = thing.getThingName();
        writer.writeStartElement(thingName);
        String name = thing.getMetadata().getName();
        if (!name.equals(thingName)) {
            writer.writeAttribute("name", name);
        }
        attrContext.put("name", name);
        String id = thing.getMetadata().getId();
        if (!(includeDefaultValue || id == null || "".equals(id) || id.equals(name))) {
            writer.writeAttribute("_xmeta_id_", id);
        }
        boolean writeDescriptor = true;
        String descriptors = thing.getString("descriptors");
        Thing descriptor = thing.getDescriptor();
        if (parentDescriptors != null && descriptors != null && descriptors.split("[,]").length == 1) {
            for (Thing parentDescriptor : parentDescriptors.getAllChilds("thing")) {
                if (!parentDescriptor.getMetadata().getName().equals(thingName) || !descriptor.getMetadata().getPath().equals(parentDescriptor.getMetadata().getPath())) continue;
                writeDescriptor = false;
                break;
            }
        }
        if (writeDescriptor && descriptors != null) {
            writer.writeAttribute("descriptors", descriptors);
        }
        attrContext.put("descriptors", descriptors);
        List<Thing> attributes = thing.getAllAttributesDescriptors();
        ArrayList<Thing> cDataAttributes = new ArrayList<Thing>();
        SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Thing attribute : attributes) {
            Object value;
            String attrname = attribute.getMetadata().getName();
            if (attrContext.get(attrname) != null) continue;
            attrContext.put(attrname, attrname);
            String defaultValue = attribute.getString("default");
            if (includeDefaultValue) {
                defaultValue = null;
            }
            if ((value = thing.getAttribute(attrname)) == null || "".equals(value) || "label".equals(attrname) && name.equals(value)) continue;
            boolean isCdata = false;
            String type = attribute.getString("type");
            String strValue = null;
            if ("__PCDATA__".equals(attrname) || "__CDATA__".equals(attrname)) {
                cDataAttributes.add(attribute);
                isCdata = true;
            } else if ("int".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("long".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("double".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("float".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("bigDecimal".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("bigInteger".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("boolean".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("byte".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("bytes".equals(type)) {
                byte[] bytes = thing.getBytes(attrname);
                strValue = UtilData.bytesToHexString(bytes);
            } else if ("char".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("short".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("date".equals(type)) {
                Date date = thing.getDate(attrname);
                strValue = dateFormater.format(date);
            } else if ("object".equals(type)) {
                if (value instanceof Serializable) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                    oout.writeObject(value);
                    oout.flush();
                    byte[] bs = bout.toByteArray();
                    strValue = UtilData.bytesToHexString(bs);
                }
            } else {
                String str = thing.getString(attrname);
                if (str.indexOf("\n") != -1) {
                    cDataAttributes.add(attribute);
                    isCdata = true;
                } else {
                    strValue = String.valueOf(value);
                }
            }
            if (isCdata) continue;
            if (strValue != null) {
                if (!includeDefaultValue && CoderUtils.isDefault(attribute, strValue)) continue;
                writer.writeAttribute(attrname, strValue);
                continue;
            }
            if (defaultValue == null || "".equals(defaultValue)) continue;
            writer.writeAttribute(attrname, "");
        }
        String xmlns = thing.getStringBlankAsNull("xmlns");
        String xmlns_xsi = thing.getStringBlankAsNull("xmlns:xsi");
        String schemaLocation = thing.getStringBlankAsNull("xsi:schemaLocation");
        if (xmlns != null) {
            writer.writeAttribute("xmlns", xmlns);
        }
        if (xmlns_xsi != null) {
            writer.writeAttribute("xmlns:xsi", xmlns_xsi);
        }
        if (schemaLocation != null) {
            writer.writeAttribute("xsi:schemaLocation", schemaLocation);
        }
        for (Thing attribute : cDataAttributes) {
            String attrname = attribute.getMetadata().getName();
            String str = thing.getString(attrname);
            writer.writeCharacters("\n" + ident + "    ");
            writer.writeStartElement(attrname);
            writer.writeCData(str);
            writer.writeEndElement();
        }
        for (Thing child : thing.getChilds()) {
            XmlCoder.encode(child, descriptor, writer, ident + "    ", includeDefaultValue);
        }
        if (cDataAttributes.size() > 0 || thing.getChilds().size() > 0) {
            writer.writeCharacters("\n" + ident);
        }
        writer.writeEndElement();
    }

    public static void parse(Thing thing, String content) throws ParserConfigurationException, SAXException, IOException {
        if (content == null) {
            return;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(bis);
        Element root = document.getDocumentElement();
        XmlCoder.parse(thing, null, root, System.currentTimeMillis());
    }

    public static void parse(Thing thing, InputStream input) throws SAXException, IOException, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(input);
        Element root = document.getDocumentElement();
        XmlCoder.parse(thing, null, root, System.currentTimeMillis());
    }

    public static void parse(Thing thing, Thing parentDescriptor, Element element, long lastModifyed) {
        Map<String, Object> attributes = thing.getAttributes();
        String thingName = element.getNodeName();
        String descriptors = element.getAttribute("descriptors");
        if (descriptors != null && !"".equals(descriptors.trim())) {
            attributes.put("descriptors", descriptors);
            thing.initDefaultValue();
        } else if (parentDescriptor != null) {
            for (Thing descriptor : parentDescriptor.getAllChilds("thing")) {
                if (!thingName.equals(descriptor.getMetadata().getName())) continue;
                descriptors = descriptor.getMetadata().getPath();
                attributes.put("descriptors", descriptors);
                thing.initDefaultValue();
                break;
            }
        }
        descriptors = (String)attributes.get("descriptors");
        if (descriptors == null || descriptors.equals("")) {
            if ("actions".equals(thingName)) {
                attributes.put("descriptors", "MetaThing/@actions");
            } else if ("JavaAction".equals(thingName)) {
                attributes.put("descriptors", "MetaThing/@actions/@JavaAction");
            } else {
                attributes.put("descriptors", "MetaThing");
            }
        }
        thing.getMetadata().setLastModified(lastModifyed);
        NamedNodeMap nodes = element.getAttributes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node attributeNode = nodes.item(i);
            if ("descriptors".equals(attributeNode.getNodeName())) continue;
            attributes.put(attributeNode.getNodeName(), attributeNode.getNodeValue());
            attributes.put(NODE_NAME, attributeNode.getNodeValue());
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1) continue;
                if (XmlCoder.isAttributeNode(node)) {
                    Node childNode = node.getFirstChild();
                    if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) continue;
                    attributes.put(node.getNodeName(), childNode.getNodeValue());
                    continue;
                }
                Thing child = new Thing(null, null, null, false);
                XmlCoder.parse(child, thing.getDescriptor(), (Element)node, lastModifyed);
                if (child == null) continue;
                thing.addChild(child);
            } while ((node = node.getNextSibling()) != null);
        }
        if (attributes.get("name") == null) {
            attributes.put("name", thingName);
        }
        if (attributes.get("_xmeta_id_") != null) {
            thing.getMetadata().setId(attributes.get("_xmeta_id_").toString());
        } else {
            thing.getMetadata().setId((String)attributes.get("name"));
        }
    }

    public static boolean isAttributeNode(Node node) {
        Node childNode;
        return node.getNodeType() == 1 && ((Element)node).getAttributes().getLength() == 0 && node.getChildNodes().getLength() == 1 && ((childNode = node.getFirstChild()).getNodeType() == 4 || childNode.getNodeType() == 3);
    }
}

