/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingIndex;
import org.xmeta.ThingMetadata;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.thingManagers.AbstractThingManager;
import org.xmeta.thingManagers.CachedCategory;
import org.xmeta.thingManagers.JarCategory;
import org.xmeta.util.ThingClassLoader;

public class JarThingManager
extends AbstractThingManager {
    JarFile jarFile;
    String name;
    String jarFilePath = null;

    public JarThingManager(String name, File jarFile) {
        super(name);
        try {
            this.jarFile = new JarFile(jarFile);
            this.jarFilePath = jarFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new XMetaException("open jar error, jarFile=" + jarFile, e);
        }
        this.rootCategory = new JarCategory(this, null, null);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Thing doLoadThing(String thingName) {
        try {
            ThingCoder thingCoder;
            JarEntry jarEntry;
            String jarEntryName = thingName.replace('.', '/');
            Iterator<ThingCoder> iterator = World.getInstance().getThingCoders().iterator();
            do {
                if (!iterator.hasNext()) return null;
                thingCoder = iterator.next();
            } while ((jarEntry = this.jarFile.getJarEntry(jarEntryName + "." + thingCoder.getType())) == null);
            InputStream fin = this.jarFile.getInputStream(jarEntry);
            try {
                Thing thing = new Thing(null, null, null, false);
                ThingMetadata metadata = thing.getMetadata();
                metadata.setPath(thingName);
                String category = null;
                String thingFileName = thingName;
                int lastDotIndex = thingName.lastIndexOf(".");
                if (lastDotIndex != -1) {
                    category = thingName.substring(0, lastDotIndex);
                    thingFileName = thingName.substring(lastDotIndex + 1, thingName.length());
                }
                metadata.setCategory(this.getCategory(category));
                metadata.setCoderType(thingCoder.getType());
                metadata.setReserve(thingFileName);
                thingCoder.decode(thing, fin, jarEntry.getTime());
                Thing thing2 = thing;
                return thing2;
            }
            finally {
                fin.close();
            }
        }
        catch (IOException e) {
            throw new XMetaException("load thing from jar error, jarFile=" + this.jarFile, e);
        }
    }

    @Override
    public boolean doRemoveThing(Thing thing) {
        throw new XMetaException("remove thing is not supported by JarThingManager");
    }

    @Override
    public boolean doSaveThing(Thing thing) {
        throw new XMetaException("save thing is not supported by JarThingManager");
    }

    @Override
    public ThingClassLoader getClassLoader() {
        return World.getInstance().getClassLoader();
    }

    @Override
    public void refresh() {
        try {
            World world = World.getInstance();
            Enumeration<JarEntry> enumeration = this.jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String fileExt;
                ThingCoder thingCoder;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory()) continue;
                String jarEntryName = jarEntry.getName();
                int index = jarEntryName.lastIndexOf("/");
                String packageName = null;
                String fileName = null;
                if (index != -1) {
                    packageName = jarEntryName.substring(0, index);
                    packageName = packageName.replace('/', '.');
                    fileName = jarEntryName.substring(index + 1, jarEntryName.length());
                } else {
                    fileName = jarEntryName;
                }
                if ((index = fileName.indexOf(".")) == -1 || (thingCoder = world.getThingCoder(fileExt = fileName.substring(index + 1, fileName.length()))) == null) continue;
                String thingName = fileName.substring(0, index);
                this.initThingIndex(this.jarFile, jarEntry, thingCoder, packageName, thingName, fileExt);
            }
        }
        catch (IOException ioe) {
            throw new XMetaException("refresh jarThingManager error, jarFile=" + this.jarFile, ioe);
        }
    }

    private void initThingIndex(JarFile jFile, JarEntry jarEntry, ThingCoder thingCoder, String packageName, String thingName, String fileExt) throws IOException {
        Category category = this.initCategory(packageName);
        CachedCategory cat = (CachedCategory)category;
        for (ThingIndex index : cat.getThingIndexs()) {
            if (!index.getThingName().equals(thingName)) continue;
            return;
        }
        ThingIndex thingIndex = new ThingIndex();
        InputStream in = jFile.getInputStream(jarEntry);
        in.close();
        thingIndex.name = thingName;
        thingIndex.path = packageName + "." + thingName;
        thingIndex.thingManager = this;
        thingIndex.lastModified = jarEntry.getTime();
        ((CachedCategory)category).addThingIndex(thingIndex);
    }

    private Category initCategory(String packageName) {
        Category category = null;
        if (packageName == null) {
            category = this.rootCategory;
        } else {
            Category parentPackage = this.rootCategory;
            for (String pkName : packageName.split("[.]")) {
                category = parentPackage.getCategory(pkName);
                if (category == null) {
                    String name = parentPackage.getName();
                    name = name != null && !"".equals(name) ? name + "." + pkName : pkName;
                    category = new JarCategory(this, parentPackage, name);
                    ((JarCategory)parentPackage).addCategory(category);
                }
                parentPackage = category;
            }
        }
        return category;
    }

    @Override
    public boolean remove() {
        return true;
    }

    @Override
    public boolean removeCategory(String categoryName) {
        throw new XMetaException("remove package is not supported by JarThingManager");
    }

    @Override
    public boolean createCategory(String categoryName) {
        throw new XMetaException("create category is not supported by JarThingManager");
    }

    @Override
    public String getClassPath() {
        return World.getInstance().getClassLoader().getClassPath();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            JarEntry jarEntry = this.jarFile.getJarEntry(name);
            if (jarEntry != null) {
                return this.jarFile.getInputStream(jarEntry);
            }
        }
        catch (Exception e) {
            throw new XMetaException("get resource stream from jar error", e);
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        try {
            JarEntry jarEntry = this.jarFile.getJarEntry(name);
            if (jarEntry != null) {
                return new URL("jar:file:/" + this.jarFilePath + "!" + name);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public void init(Properties properties) {
    }

    @Override
    public boolean isSaveable() {
        return false;
    }
}

