/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingMetadata;
import org.xmeta.World;
import org.xmeta.thingManagers.AbstractThingManager;
import org.xmeta.thingManagers.RedisCategory;
import org.xmeta.util.ThingClassLoader;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisThingManager
extends AbstractThingManager {
    String host;
    int port;
    String password;
    JedisPool jedisPool;

    public RedisThingManager(String name, File rootFile) throws IOException {
        super(name);
    }

    public Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    public void releaseJedis(Jedis jedis) {
        this.jedisPool.returnResource(jedis);
    }

    @Override
    public boolean createCategory(String categoryName) {
        Jedis jedis = this.jedisPool.getResource();
        try {
            jedis.set("category|" + categoryName, categoryName);
            this.refreshParentCategory(categoryName);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return true;
    }

    @Override
    public void refresh() {
        this.rootCategory.refresh();
    }

    @Override
    public boolean remove() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCategory(String categoryName) {
        Jedis jedis = this.jedisPool.getResource();
        try {
            Set categorys = jedis.keys("category|" + categoryName + "*");
            String[] keys = new String[categorys.size()];
            int index = 0;
            Iterator iterator = categorys.iterator();
            while (iterator.hasNext()) {
                String name;
                keys[index] = name = (String)iterator.next();
                ++index;
            }
            jedis.del(keys);
            Set things = jedis.keys("thing|" + categoryName + ".*");
            keys = new String[things.size()];
            index = 0;
            Iterator iterator2 = things.iterator();
            while (iterator2.hasNext()) {
                String name;
                keys[index] = name = (String)iterator2.next();
                ++index;
            }
            jedis.del(keys);
            this.refreshParentCategory(categoryName);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return true;
    }

    @Override
    public ThingClassLoader getClassLoader() {
        return World.getInstance().getClassLoader();
    }

    @Override
    public String getClassPath() {
        return World.getInstance().getClassLoader().getClassPath();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return null;
    }

    @Override
    public URL findResource(String name) {
        return null;
    }

    @Override
    public void init(Properties properties) {
        String host = properties.getProperty("host");
        int port = Integer.parseInt(properties.getProperty("port"));
        String password = properties.getProperty("password");
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port, 5000, password);
        Jedis jedis = this.jedisPool.getResource();
        this.jedisPool.returnResource(jedis);
        this.rootCategory = new RedisCategory(null, this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thing doLoadThing(String thingName) {
        Jedis jedis = this.jedisPool.getResource();
        try {
            String thingCode = jedis.get("thing|" + thingName);
            if (thingCode != null) {
                Thing thing = new Thing(null, null, null, false);
                ThingMetadata metadata = thing.getMetadata();
                metadata.setPath(thingName);
                String category = null;
                int lastDotIndex = thingName.lastIndexOf(".");
                if (lastDotIndex != -1) {
                    category = thingName.substring(0, lastDotIndex);
                }
                metadata.setCategory(this.getCategory(category));
                ThingCoder coder = World.getInstance().getThingCoder("xer.txt");
                coder.decode(thing, new ByteArrayInputStream(thingCode.getBytes()), 0L);
                metadata.setCoderType(coder.getType());
                Thing thing2 = thing;
                return thing2;
            }
            Thing thing = null;
            return thing;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    @Override
    public boolean doRemoveThing(Thing thing) {
        Jedis jedis = this.jedisPool.getResource();
        try {
            jedis.del("thing|" + thing.getMetadata().getPath());
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doSaveThing(Thing thing) {
        Jedis jedis = this.jedisPool.getResource();
        try {
            ThingCoder coder = World.getInstance().getThingCoder("xer.txt");
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            coder.encode(thing, bout);
            jedis.set("thing|" + thing.getMetadata().getPath(), new String(bout.toByteArray()));
            try {
                bout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return true;
    }

    @Override
    public boolean isSaveable() {
        return true;
    }
}

