/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.ThingManagerListener;
import org.xmeta.World;
import org.xmeta.thingManagers.TransientCategory;
import org.xmeta.thingManagers.TransientFinalizer;
import org.xmeta.util.ThingClassLoader;

public class TransientThingManager
implements ThingManager {
    private static TransientFinalizer transientFinalizer = new TransientFinalizer();
    TransientCategory category = new TransientCategory(this);
    List<Category> categorys = new CopyOnWriteArrayList<Category>();
    Map<String, WeakReference<Thing>> things = new ConcurrentHashMap<String, WeakReference<Thing>>();
    List<ThingIndex> thingIndexs = new CopyOnWriteArrayList<ThingIndex>();
    private long transientId = 0L;

    public TransientThingManager() {
        this.categorys.add(this.category);
        transientFinalizer.addTransientManager(this);
    }

    public synchronized long getNextId() {
        if (this.transientId == Long.MAX_VALUE) {
            this.transientId = 0L;
        }
        do {
            ++this.transientId;
        } while (this.things.get("_transient." + this.transientId) != null);
        return this.transientId;
    }

    @Override
    public String getName() {
        return "_transient";
    }

    @Override
    public void clearCache() {
    }

    @Override
    public boolean createCategory(String categoryName) {
        return false;
    }

    @Override
    public List<Category> getCategorys() {
        return this.categorys;
    }

    public int getSize() {
        return this.things.size();
    }

    @Override
    public Thing getThing(String thingPath) {
        WeakReference<Thing> wr = this.things.get(thingPath);
        if (wr != null) {
            Thing thing = (Thing)wr.get();
            if (thing == null) {
                this.things.remove(thingPath);
            }
            return thing;
        }
        return null;
    }

    @Override
    public boolean save(Thing athing) {
        if (athing == null) {
            return false;
        }
        Thing root = athing.getRoot();
        String thingPath = root.getMetadata().getPath();
        WeakReference<Thing> wr = this.things.get(thingPath);
        if (wr == null || wr.get() == null) {
            wr = new WeakReference<Thing>(root);
            this.things.put(thingPath, wr);
        }
        return true;
    }

    @Override
    public boolean remove(Thing thing) {
        if (thing == null) {
            return false;
        }
        Thing root = thing.getRoot();
        String thingPath = root.getMetadata().getPath();
        WeakReference<Thing> wr = this.things.remove(thingPath);
        return wr != null;
    }

    @Override
    public Category getCategory(String name) {
        if (name == null || "".equals(name) || name.equals("_transient")) {
            return this.category;
        }
        return null;
    }

    @Override
    public void refresh() {
        String[] keys = new String[this.things.keySet().size()];
        this.things.keySet().toArray(keys);
        for (String key : keys) {
            WeakReference<Thing> wr = this.things.get(key);
            if (wr != null && wr.get() != null) continue;
            this.things.remove(key);
        }
    }

    @Override
    public boolean remove() {
        this.things.clear();
        this.thingIndexs.clear();
        return true;
    }

    public void removeDeadThings() {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : this.things.keySet()) {
                keys.add(key);
            }
            for (String key : keys) {
                WeakReference<Thing> wr = this.things.get(key);
                if (wr != null && wr.get() != null) continue;
                this.things.remove(key);
                this.thingIndexs.remove(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<Thing> getThings(String categoryName) {
        return this.getThings(categoryName, null);
    }

    @Override
    public List<Thing> getThings(String categoryName, String descriptorPath) {
        ArrayList<Thing> thins = new ArrayList<Thing>();
        for (Map.Entry<String, WeakReference<Thing>> entry : this.things.entrySet()) {
            Thing thing;
            WeakReference<Thing> wr = entry.getValue();
            if (wr == null || (thing = (Thing)wr.get()) == null || descriptorPath != null && !thing.isThing(descriptorPath)) continue;
            thins.add(thing);
        }
        return thins;
    }

    @Override
    public Iterator<Thing> iterator(String categoryName, boolean includeChild) {
        return this.getThings(categoryName).iterator();
    }

    @Override
    public Iterator<Thing> iterator(String categoryName, String descriptorPath, boolean includeChild) {
        return this.getThings(categoryName, descriptorPath).iterator();
    }

    public ThingIndex getThingIndex(String thingName) {
        for (ThingIndex thingIndex : this.thingIndexs) {
            if (!thingIndex.getThingName().equals(thingName)) continue;
            return thingIndex;
        }
        return null;
    }

    @Override
    public List<ThingIndex> getThingIndexs(String categoryName) {
        return this.thingIndexs;
    }

    @Override
    public List<ThingIndex> getThingIndexs(String categoryName, String descriptorPath) {
        ArrayList<ThingIndex> indexs = new ArrayList<ThingIndex>();
        for (ThingIndex index : this.thingIndexs) {
            if (index.descriptors == null || index.descriptors.indexOf(descriptorPath) == -1) continue;
            indexs.add(index);
        }
        return indexs;
    }

    @Override
    public void refresh(String categoryName, boolean includeChildCategory) {
        this.refresh();
    }

    @Override
    public boolean removeCategory(String categoryName) {
        return false;
    }

    @Override
    public void addThingManagerListener(ThingManagerListener listener) {
    }

    @Override
    public boolean removeThingManagerListener(ThingManagerListener listener) {
        return true;
    }

    @Override
    public ThingClassLoader getClassLoader() {
        return World.getInstance().getClassLoader();
    }

    @Override
    public String getClassPath() {
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return null;
    }

    @Override
    public URL findResource(String name) {
        return null;
    }

    @Override
    public void init(Properties properties) {
    }

    @Override
    public boolean isSaveable() {
        return true;
    }
}

