/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.util.UtilMap;

public class ActionContainer {
    private static Logger log = LoggerFactory.getLogger(ActionContainer.class);
    static World world = World.getInstance();
    private Thing actions;
    private ActionContext actionContext;

    public ActionContainer(Thing actions, ActionContext actionContext) {
        this.actionContext = actionContext;
        this.actions = actions;
    }

    public Thing getThing() {
        return this.actions;
    }

    public Object doAction(String name) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext);
            }
            return null;
        }
        catch (Throwable e) {
            log.error("Container do action " + name, e);
            return null;
        }
    }

    public Object doAction(String name, ActionContext context) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext);
            }
            return null;
        }
        catch (Throwable e) {
            log.error("Container do action " + name, e);
            return null;
        }
    }

    public Object doAction(String name, Map<String, Object> parameters) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            return null;
        }
        catch (Throwable e) {
            log.error("Container do action " + name, e);
            return null;
        }
    }

    public Object doAction(String name, ActionContext context, Map<String, Object> parameters) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            return null;
        }
        catch (Throwable e) {
            log.error("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
            return null;
        }
    }

    public Object doAction(String name, ActionContext context, Object ... parameters) {
        return this.doAction(name, context, UtilMap.toMap(parameters));
    }

    public Thing getActionThing(String name) {
        for (Thing child : this.actions.getAllChilds()) {
            if (!child.getMetadata().getName().equals(name)) continue;
            return child;
        }
        Thing child = this.actions.getActionThing(name);
        if (child == null) {
            log.warn("action is not found : " + this.actions.getMetadata().getPath() + "/@" + name);
            return null;
        }
        return child;
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }
}

