/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.util.UtilFile;

public class ThingRunner {
    private static final Logger logger = LoggerFactory.getLogger(ThingRunner.class);
    public static final String working_project = "working_directory";

    public static void main(String[] args) {
        ThingRunner.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadXerFromJar(Properties p, File fileName) {
        try {
            JarFile jarFile = new JarFile(fileName);
            try {
                JarEntry entry = jarFile.getJarEntry("dml.ini");
                if (entry == null) {
                    boolean bl = false;
                    return bl;
                }
                InputStream in = jarFile.getInputStream(entry);
                p.load(in);
                boolean bl = true;
                return bl;
            }
            finally {
                jarFile.close();
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void run(String[] args) {
        try {
            Thing thing;
            String worldPath = null;
            String thingPath = null;
            String actionName = null;
            if (args.length >= 1) {
                worldPath = args[0];
            }
            if (args.length >= 2) {
                thingPath = args[1];
            }
            if (args.length >= 3) {
                actionName = args[2];
            }
            if (actionName == null) {
                actionName = "run";
            }
            if (thingPath == null) {
                System.out.println("Please input thing path or thing file");
                System.exit(0);
            }
            logger.info("world path : " + worldPath);
            logger.info("thing path : " + thingPath);
            logger.info("action name : " + actionName);
            World world = World.getInstance();
            world.init(worldPath);
            for (String arg : args) {
                if (!arg.toLowerCase().equals("-verbose")) continue;
                world.setVerbose(true);
            }
            boolean isFile = false;
            File thingFile = new File(thingPath);
            if (!thingFile.exists()) {
                thingFile = new File("./" + thingPath);
            }
            if (thingFile.exists()) {
                thingPath = UtilFile.getThingPathByFile(thingFile.getAbsoluteFile());
                if (thingPath == null) {
                    logger.info("Cann't open, file is no a thing, file=" + thingPath);
                    return;
                }
                isFile = true;
            } else {
                String tname;
                File file = new File(".");
                File rootFile = UtilFile.getThingsRootAndInitProject(file);
                if (rootFile == null && world.getThingManager(tname = UtilFile.getThingManagerNameByDir(rootFile = file)) == null) {
                    world.addFileThingManager(tname, rootFile, false, true);
                }
            }
            if (isFile) {
                // empty if block
            }
            if ("XWORKER".equals(thingPath.toUpperCase())) {
                thingPath = "XWorker";
            }
            if ((thing = world.getThing(thingPath)) == null) {
                System.out.println("thing not exists : " + thingPath);
                System.exit(0);
            } else {
                ActionContext actionContext = new ActionContext();
                actionContext.put("args", (Object)args);
                thing.doAction(actionName, actionContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static boolean editThing(String thingPath) {
        Thing globalConfig = World.getInstance().getThing("_local.xworker.config.GlobalConfig");
        if (globalConfig == null) {
            System.out.println("XWorker has not run thing explorer, run thing......");
            return false;
        }
        String baseUrl = globalConfig.getString("webUrl") + "do?sc=xworker.ide.worldExplorer.swt.http.IDETools";
        try {
            URL checkIde = new URL(baseUrl + "&ac=isIdeOpened");
            URLConnection urlcon = checkIde.openConnection();
            InputStream in = urlcon.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String content = reader.readLine();
            if (!"true".equals(content)) {
                System.out.println("XWorker has not run thing explorer, run thing......");
                return false;
            }
        }
        catch (Exception e) {
            return ThingRunner.startExplorerAndEditThing(thingPath);
        }
        try {
            URL openThing = new URL(baseUrl + "&ac=oepenThing&path=" + URLEncoder.encode(thingPath, "utf-8"));
            openThing.openConnection().getContent();
            return true;
        }
        catch (Exception e) {
            System.out.println("Exception happend, run thing......, " + e.getLocalizedMessage());
            return false;
        }
    }

    private static boolean startExplorerAndEditThing(String filePath) {
        Thing explorer = World.getInstance().getThing("xworker.ide.worldExplorer.swt.SimpleExplorerRunner");
        if (explorer == null) {
            return false;
        }
        ActionContext actionContext = new ActionContext();
        actionContext.put("defaultOpenFile", (Object)new File(filePath));
        explorer.doAction("run", actionContext);
        return true;
    }

    public static class WaiterForEnter
    extends Thread {
        boolean ctrPressed = false;
        boolean stoped = false;
        Thread waitThread = Thread.currentThread();

        public void waitForEnter() {
            try {
                while (!this.stoped) {
                    if (System.in.available() > 0) {
                        this.ctrPressed = true;
                    }
                    Thread.sleep(300L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            long timestart = System.currentTimeMillis();
            while (System.currentTimeMillis() - timestart < 3000L && !this.ctrPressed) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.stoped = true;
        }
    }
}

