/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.World;

public class UtilAction {
    public static String getActionCodeFilePath(Thing actionThing, String ext) {
        String cName;
        String className = "";
        Thing parent = actionThing.getParent();
        Thing rootParent = actionThing.getRoot();
        if (parent == null) {
            parent = actionThing;
        }
        if (rootParent != null) {
            className = className + ".p" + rootParent.getMetadata().getPath().hashCode();
        }
        if (parent != null && parent != rootParent) {
            className = className + ".p" + parent.getMetadata().getPath().hashCode();
        }
        className = (cName = actionThing.getString("className")) == null || "".equals(cName) ? className + "." + actionThing.getMetadata().getName() : className + "." + cName;
        className = Action.getClassName(className);
        String fileName = className.replace('.', '/');
        return World.getInstance().getPath() + "/actionSources/" + fileName + "." + ext;
    }

    public static void putVarByActioScope(Thing action, String varName, Object var, ActionContext actionContext) {
        Bindings bindings;
        if (varName != null && !"".equals(varName) && (bindings = UtilAction.getVarScope(action, actionContext)) != null) {
            bindings.put(varName, var);
        }
    }

    public static Bindings getVarScope(Thing action, ActionContext actionContext) {
        if (action == null) {
            return actionContext.getScope();
        }
        String varScope = action.getString("varScope");
        return UtilAction.getVarScope(varScope, actionContext);
    }

    public static Bindings getVarScope(String varScope, ActionContext actionContext) {
        Bindings binding = null;
        if (varScope == null || "".equals(varScope)) {
            binding = actionContext.getScope();
        } else if ("Global".equals(varScope)) {
            binding = actionContext.getScope(0);
        } else if ("Local".equals(varScope)) {
            binding = actionContext.getScope();
        } else {
            try {
                int scopeIndex = Integer.parseInt(varScope);
                binding = scopeIndex >= 0 ? actionContext.getScope(scopeIndex) : actionContext.getScope(actionContext.getScopesSize() + scopeIndex);
            }
            catch (Exception e) {
                binding = actionContext.getScope(varScope);
            }
        }
        return binding;
    }

    public static boolean getDebugLog(Thing actionThing, ActionContext actionContext) {
        return actionThing.getBoolean("debugLog");
    }
}

