/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.ActionClassLoader;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.annotation.ActionAnnotationHelper;
import org.xmeta.cache.ThingEntry;
import org.xmeta.thingManagers.ClassThingManager;
import org.xmeta.thingManagers.FileThingManager;
import org.xmeta.util.JavaCompiler15;
import org.xmeta.util.JavaCompiler16;
import org.xmeta.util.Semaphore;
import org.xmeta.util.ThingClassLoader;
import org.xmeta.util.UtilAction;
import org.xmeta.util.UtilString;

public class Action
extends Semaphore {
    private static Logger log = LoggerFactory.getLogger(Action.class);
    private static World world = World.getInstance();
    private static List<ThrowableRecord> throwables = new ArrayList<ThrowableRecord>();
    private static int throwableRecordCount = 0;
    private static Map<String, SoftReference<ClassCompileTimeFile>> classTimeFiles = new HashMap<String, SoftReference<ClassCompileTimeFile>>();
    public static final String[] javaKeyWords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "#"};
    public static final String str_acContext = "acContext";
    public static final String str_parentContext = "parentContext";
    public static final String str_action = "action";
    public static final String str_actionThing = "actionThing";
    public ThingEntry thingEntry;
    private boolean isJava = false;
    private boolean throwException;
    private boolean isSynchronized;
    public long lastModified = 0L;
    private boolean useOtherAction;
    private boolean isSelfInterpretationType;
    private String otherActionPath;
    private List<ThingEntry> contexts;
    public ClassLoader classLoader;
    public String className;
    public String classFileName;
    public String packageName;
    public String fileName;
    public String code;
    private String methodName;
    private boolean useOuterJava;
    private String outerClassName;
    private boolean attributeTemplate;
    public Class<?> actionClass = null;
    public boolean changed = false;
    public Action outerAction = null;
    public Method method = null;
    Map<String, Object> userData = new HashMap<String, Object>();
    Logger logger;
    List<ActionResult> results;
    Thing params = null;
    boolean saveReturn;
    String returnVarName;
    boolean isCreateLocalVarScope;
    Map<String, Action> actionsDefiend = null;
    private ActionAnnotationHelper annotationHelper;

    public Action(Thing thing) {
        this.thingEntry = new ThingEntry(thing);
        try {
            this.init();
        }
        catch (Exception e) {
            throw new ActionException("init action error, action=" + thing.getMetadata().getPath(), e);
        }
    }

    public void checkChanged() {
        if (this.lastModified != this.thingEntry.getThing().getMetadata().getLastModified()) {
            if (this.lastModified != 0L) {
                this.changed = true;
            }
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
        }
    }

    public String getClassTargetDirectory() {
        String fileManagerName = this.thingEntry.getThing().getMetadata().getThingManager().getName();
        fileManagerName = fileManagerName == null ? "null" : UtilString.trimFileName(fileManagerName);
        return String.valueOf(World.getInstance().getPath()) + "/actionClasses/" + fileManagerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws ClassNotFoundException, IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        long classCompileTime;
        String compleClassPath;
        Thing thing;
        block50: {
            String fileManagerName;
            thing = this.thingEntry.getThing();
            this.params = thing.getThing("ins@0");
            this.throwException = thing.getAttribute("throwException") == null ? true : thing.getBoolean("throwException");
            this.isSynchronized = thing.getBoolean("isSynchronized");
            this.lastModified = thing.getMetadata().getLastModified();
            this.contexts = new ArrayList<ThingEntry>();
            Thing contextsThing = thing.getThing("contexts@0");
            if (contextsThing != null) {
                List<Thing> contextList = contextsThing.getChilds();
                for (Thing contextThing : contextList) {
                    this.contexts.add(new ThingEntry(contextThing));
                }
            }
            this.attributeTemplate = thing.getBoolean("attributeTemplate");
            this.useOtherAction = thing.getBoolean("useOtherAction");
            this.otherActionPath = thing.getString("otherActionPath");
            this.isSelfInterpretationType = "Self".equals(thing.getString("interpretationType"));
            List<Thing> actionsThingList = thing.getChilds("ActionDefined");
            if (actionsThingList.size() > 0) {
                this.actionsDefiend = new HashMap<String, Action>();
                for (Thing actionsThing : actionsThingList) {
                    for (Thing actionThing : actionsThing.getChilds()) {
                        this.actionsDefiend.put(actionThing.getMetadata().getName(), actionThing.getAction());
                    }
                }
            } else {
                this.actionsDefiend = null;
            }
            this.returnVarName = thing.getString("returnVarName");
            this.saveReturn = thing.getBoolean("saveReturn");
            Thing parent = thing.getParent();
            Thing rootParent = thing.getRoot();
            if (parent == null) {
                parent = thing;
            }
            fileManagerName = (fileManagerName = thing.getMetadata().getThingManager().getName()) == null ? "null" : UtilString.trimFileName(fileManagerName);
            this.className = rootParent.getMetadata().getPath();
            if (rootParent != thing) {
                this.className = String.valueOf(this.className) + ".p" + thing.getMetadata().getPath().hashCode();
                this.className = this.className.replace('-', '_');
                String cName = thing.getString("className");
                this.className = cName == null || "".equals(cName) ? String.valueOf(this.className) + "." + thing.getMetadata().getName() : String.valueOf(this.className) + "." + cName;
            }
            this.className = Action.getClassName(this.className);
            int dotIndex = this.className.lastIndexOf(".");
            if (dotIndex != -1) {
                this.packageName = this.className.substring(0, dotIndex);
            }
            this.fileName = String.valueOf(fileManagerName) + "/" + this.className.replace('.', '/');
            this.fileName = String.valueOf(World.getInstance().getPath()) + "/actionSources/" + this.fileName;
            this.classFileName = String.valueOf(World.getInstance().getPath()) + "/actionClasses/" + fileManagerName + "/" + this.className.replace('.', '/') + ".class";
            this.code = thing.getString("code");
            if (this.code == null) {
                this.code = "";
            }
            this.methodName = thing.getString("methodName");
            this.useOuterJava = thing.get("useOuterJava") == null ? true : thing.getBoolean("useOuterJava");
            this.outerClassName = thing.getString("outerClassName");
            this.actionClass = null;
            this.isJava = "JavaAction".equals(thing.getThingName());
            ThingClassLoader pclssLoader = thing.getMetadata().getThingManager().getClassLoader();
            compleClassPath = pclssLoader.getCompileClassPath();
            if (world.getMode() == World.MODE_WORKING) {
                this.classLoader = pclssLoader;
            } else {
                File classDir = new File(String.valueOf(world.getPath()) + "/actionClasses/" + fileManagerName);
                if (!classDir.exists()) {
                    classDir.mkdirs();
                }
                this.classLoader = new ActionClassLoader(new URL[]{classDir.toURI().toURL()}, (ClassLoader)pclssLoader);
            }
            this.results = new ArrayList<ActionResult>();
            for (Thing child : thing.getAllChilds("Result")) {
                ActionResult result = new ActionResult(child);
                this.results.add(result);
            }
            this.isCreateLocalVarScope = thing.getBoolean("createLocalVarScope");
            classCompileTime = 0L;
            if (thing.getMetadata().getThingManager() instanceof ClassThingManager) {
                try {
                    classCompileTime = Action.getClassCompileTime(this.classFileName);
                    if (classCompileTime == 0L || classCompileTime != this.lastModified) break block50;
                    this.actionClass = this.classLoader.loadClass(this.className);
                    if (this.actionClass != null) {
                        classCompileTime = this.lastModified;
                    }
                }
                catch (Throwable t) {
                    classCompileTime = Action.getClassCompileTime(this.classFileName);
                }
            } else {
                classCompileTime = Action.getClassCompileTime(this.classFileName);
            }
        }
        if (this.isJava) {
            if (this.actionClass == null) {
                this.changed = false;
                if (this.useOuterJava) {
                    this.actionClass = this.classLoader.loadClass(this.outerClassName);
                } else {
                    boolean recompile = false;
                    File classFile = new File(this.classFileName);
                    if (!classFile.exists()) {
                        recompile = true;
                    }
                    if (this.lastModified != classCompileTime) {
                        recompile = true;
                    }
                    if (recompile && world.getMode() == World.MODE_PROGRAMING) {
                        if (thing.getBoolean("useInnerJava")) {
                            ThingManager thingManager = thing.getMetadata().getThingManager();
                            if (!(thingManager instanceof FileThingManager)) throw new ActionException("useInnerJava is only fit for FileThingManager, actionThing=" + thing.getMetadata().getPath());
                            FileThingManager fileThingManager = (FileThingManager)thingManager;
                            String sourcePath = fileThingManager.getFilePath();
                            File codeFile = new File(sourcePath, String.valueOf(this.outerClassName.replace('.', '/')) + ".java");
                            boolean use16 = true;
                            boolean compiled = false;
                            try {
                                Class.forName("javax.tools.JavaCompiler");
                            }
                            catch (Exception e) {
                                use16 = false;
                            }
                            if (use16) {
                                compiled = JavaCompiler16.compile(compleClassPath, sourcePath, codeFile, this.getClassTargetDirectory());
                            }
                            if (!compiled) {
                                JavaCompiler15.compile(compleClassPath, sourcePath, codeFile.getAbsolutePath(), this.getClassTargetDirectory());
                            }
                        } else {
                            File codeFile = new File(String.valueOf(this.fileName) + ".java");
                            if (!codeFile.exists()) {
                                codeFile.getParentFile().mkdirs();
                            }
                            FileOutputStream fout = new FileOutputStream(codeFile);
                            try {
                                fout.write(("/*path:" + thing.getMetadata().getPath() + "*/\n").getBytes());
                                fout.write(("package " + this.packageName + ";\n\n").getBytes());
                                fout.write(this.code.getBytes());
                            }
                            finally {
                                fout.close();
                            }
                            File classDir = new File(String.valueOf(world.getPath()) + "/actionClasses");
                            if (!classDir.exists()) {
                                classDir.mkdirs();
                            }
                            boolean use16 = true;
                            boolean compiled = false;
                            try {
                                Class.forName("javax.tools.JavaCompiler");
                            }
                            catch (Exception e) {
                                use16 = false;
                            }
                            if (use16) {
                                compiled = JavaCompiler16.compile(compleClassPath, null, codeFile, this.getClassTargetDirectory());
                            }
                            if (!compiled) {
                                JavaCompiler15.compile(compleClassPath, null, this.fileName, this.getClassTargetDirectory());
                            }
                        }
                        this.updateCompileTime();
                    }
                    this.actionClass = thing.getBoolean("useInnerJava") ? this.classLoader.loadClass(this.outerClassName) : this.classLoader.loadClass(this.className);
                }
                Compiler.compileClass(this.actionClass);
                try {
                    if (this.methodName == null || "".equals(this.methodName)) return;
                    this.method = this.getDeclaredMethod(this.actionClass, this.methodName);
                    if (this.method == null) {
                        throw new NoSuchMethodException(this.methodName);
                    }
                    this.annotationHelper = ActionAnnotationHelper.parse(this.actionClass, this.method);
                    return;
                }
                catch (Throwable e) {
                    throw new ActionException("load method error, class=" + this.actionClass.getName() + ", method=" + this.methodName + ",action=" + thing.getMetadata().getPath(), e);
                }
            }
            if (this.method != null) return;
            try {
                if (this.methodName == null || "".equals(this.methodName)) return;
                this.method = this.getDeclaredMethod(this.actionClass, this.methodName);
                if (this.method == null) {
                    throw new NoSuchMethodException(this.methodName);
                }
                this.annotationHelper = ActionAnnotationHelper.parse(this.actionClass, this.method);
                return;
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
        }
        if (this.useOtherAction) {
            this.outerAction = world.getAction(this.otherActionPath);
            return;
        } else {
            if (this.lastModified != classCompileTime) {
                this.changed = true;
            }
            this.logger = LoggerFactory.getLogger((String)this.className);
        }
    }

    private Method getDeclaredMethod(Class<?> cls, String methodName) throws Exception {
        Exception exception = null;
        try {
            Method method_ = cls.getDeclaredMethod(methodName, ActionContext.class);
            if (method_ != null) {
                return method_;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        Method[] methodArray = cls.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++n2;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    public Class getActionClass(ActionContext actionContext) {
        Thing thing = this.thingEntry.getThing();
        if (this.lastModified != thing.getMetadata().getLastModified()) {
            if (this.lastModified != 0L) {
                this.changed = true;
            }
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
        }
        if (this.isJava) {
            return this.actionClass;
        }
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        try {
            actionContext.pushPoolBindings().put(str_actionThing, thing);
            Class clazz = (Class)thing.doAction("getActionClass", actionContext);
            return clazz;
        }
        finally {
            actionContext.pop();
        }
    }

    public void updateCompileTime() {
        Action.updateClassCompileTime(this.classFileName, this.lastModified);
    }

    public Method getMethod() {
        return this.method;
    }

    public <T> T run() {
        return this.runArrayParams(new ActionContext(), null, null, false);
    }

    public <T> T run(ActionContext context) {
        return this.runMapParams(context, null, null, false);
    }

    public <T> T run(ActionContext context, Object ... params) {
        return this.runArrayParams(context, params, null, false);
    }

    public <T> T exec(Object ... params) {
        return this.runArrayParams(null, params, null, false);
    }

    public <T> T exec(ActionContext context, Object ... params) {
        return this.runArrayParams(context, params, null, false);
    }

    public <T> T call(ActionContext actionContext, Object ... params) {
        return this.runArrayParams(actionContext, params, null, false);
    }

    public <T> T call(ActionContext context, Map<String, Object> parameters) {
        return this.runMapParams(context, parameters, null, false);
    }

    public <T> T run(ActionContext context, Map<String, Object> parameters) {
        return this.runMapParams(context, parameters, null, false);
    }

    public <T> T run(ActionContext context, Map<String, Object> parameters, boolean isSubAction) {
        return this.runMapParams(context, parameters, null, isSubAction);
    }

    public <T> T run(ActionContext context, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        return this.runMapParams(context, parameters, caller, isSubAction);
    }

    public <T> T runArrayParams(ActionContext context, Object[] params_, Object caller, boolean isSubAction) {
        if (context == null) {
            context = new ActionContext();
        }
        Bindings bindings = new Bindings();
        bindings.setParameterScope(true);
        if (params_ != null) {
            int i = 0;
            while (i < params_.length - 1) {
                bindings.put((String)params_[i], params_[i + 1]);
                ++i;
                ++i;
            }
        }
        return this.dorun(context, bindings, bindings, caller, isSubAction);
    }

    public <T> T runMapParams(ActionContext context, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        if (context == null) {
            context = new ActionContext();
        }
        Bindings bindings = new Bindings();
        bindings.setParameterScope(true);
        if (parameters != null) {
            bindings.putAll(parameters);
        }
        return this.dorun(context, bindings, parameters, caller, isSubAction);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T dorun(ActionContext context, Bindings bindings, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        block53: {
            block52: {
                if (!context.isDisableGloableContext() && Action.world.isHaveActionListener()) {
                    listener = Action.world.getActionListener();
                    try {
                        listener.actionExecuted(this, caller, context, parameters, -1L, true);
                    }
                    catch (Throwable t) {
                        Action.log.error("ActionRecorder error", t);
                    }
                }
                if (this.lastModified != (thing = this.thingEntry.getThing()).getMetadata().getLastModified()) {
                    if (this.lastModified != 0L) {
                        this.changed = true;
                    }
                    try {
                        this.init();
                    }
                    catch (Exception e) {
                        throw new ActionException("", e);
                    }
                }
                thisIsSynchronized = false;
                if (this.isSynchronized) {
                    try {
                        this.use();
                        thisIsSynchronized = true;
                    }
                    catch (InterruptedException e) {
                        throw new ActionException("try to synchronize action : " + thing.getMetadata().getPath(), e);
                    }
                }
                context.push(bindings);
                if (this.isCreateLocalVarScope) {
                    bindings.setVarScopeFlag();
                }
                context.pushAction(this);
                bindings.put("world", Action.world);
                if (this.logger != null) {
                    bindings.put("log", this.logger);
                }
                if (this.actionsDefiend != null) {
                    bindings.putAll(this.actionsDefiend);
                }
                result = null;
                allContexts = this.getContextThings(context);
                bindings.setCaller(this, null);
                bindings.world = Action.world;
                if (allContexts.size() > 0) {
                    for (Thing contextThing : allContexts) {
                        Action.initContext(this, contextThing, context);
                    }
                }
                if (this.useOtherAction) {
                    callerBindings = context.getScope(context.getScopesSize() - 2);
                    try {
                        context.push(callerBindings);
                        result = this.outerAction.run(context, parameters, isSubAction);
                    }
                    finally {
                        context.pop();
                    }
                }
                if (this.isJava) {
                    if (this.actionClass != null) {
                        if (this.method == null) throw new ActionException("Java action method not setted");
                        classInstance = null;
                        paramValues = null;
                        if (this.annotationHelper != null) {
                            classInstance = this.annotationHelper.createObject(context);
                            paramValues = this.annotationHelper.getParamValues(context);
                        }
                        if (classInstance == null && (this.method.getModifiers() & 8) != 8) {
                            classInstance = this.actionClass.newInstance();
                        }
                        if (paramValues == null) {
                            paramValues = this.method.getParameterCount() > 0 ? new Object[]{context} : new Object[]{};
                        }
                        result = this.method.invoke(classInstance, paramValues);
                    }
                } else if (this.isSelfInterpretationType) {
                    if (this.attributeTemplate) {
                        fthing = (Thing)thing.run("processAttributeTemplate", context, (Map<String, Object>)null, isSubAction, true);
                        if (fthing != null) {
                            fthing.run("run", context, (Map<String, Object>)null, isSubAction, true);
                        }
                    } else {
                        result = thing.run("run", context, (Map<String, Object>)null, isSubAction, true);
                    }
                } else {
                    actionThing = thing.getActionThing("run");
                    if (actionThing != null) {
                        ac = null;
                        try {
                            ac = actionThing.getAction();
                        }
                        catch (Exception e) {
                            throw new ActionException("Get run action error, thing=" + thing.getMetadata().getPath(), e);
                        }
                        result = ac.run(context, null, caller, isSubAction);
                    }
                }
                if (this.saveReturn && this.returnVarName != null && !"".equals(this.returnVarName) && (returnVarBindings = UtilAction.getVarScope(this.thingEntry.getThing(), context)) != null) {
                    returnVarBindings.put(this.returnVarName, result);
                }
                if (context.getStatus() == 5 && !isSubAction) {
                    if (context.getThrowedObject() instanceof Throwable) {
                        throw (Throwable)context.getThrowedObject();
                    }
                    throwedObject = context.getThrowedObject();
                    if (throwedObject == null) throw new ActionException("action throw null");
                    if (!(throwedObject instanceof Throwable)) throw new ActionException(throwedObject.toString());
                    throw (Throwable)throwedObject;
                }
                contxtMethod = "success";
                if ("failure".equals(result)) {
                    contxtMethod = "failure";
                }
                if ((exception = Action.doContextMethod(allContexts, context, contxtMethod, null, result)) != null) break block52;
                var14_18 = result;
                context.pop();
                context.popAction();
                if (!isSubAction) {
                    context.setStatus(0);
                }
                if (!thisIsSynchronized) return (T)var14_18;
                this.finished();
                return (T)var14_18;
            }
            if (this.throwException) break block53;
            this.logHideenExceptionStackTrace(exception, context);
            context.pop();
            context.popAction();
            if (!isSubAction) {
                context.setStatus(0);
            }
            if (!thisIsSynchronized) return null;
            this.finished();
            return null;
        }
        try {
            block54: {
                try {
                    throw exception;
                }
                catch (Throwable e) {
                    exception = Action.doContextMethod(allContexts, context, "exception", e, null);
                    if (Action.throwableRecordCount <= 0) break block54;
                    Action.throwables.add(new ThrowableRecord(exception, context));
                    ** while (Action.throwables.size() > Action.throwableRecordCount)
                }
lbl-1000:
                // 1 sources

                {
                    Action.throwables.remove(0);
                    continue;
                }
            }
            if (exception == null) {
                return null;
            }
            if (this.throwException) throw this.wrapToActionException(exception, context);
            this.logHideenExceptionStackTrace(e, context);
            return null;
        }
        catch (Throwable var13_19) {
            throw var13_19;
        }
        finally {
            context.pop();
            context.popAction();
            if (!isSubAction) {
                context.setStatus(0);
            }
            if (thisIsSynchronized) {
                this.finished();
            }
        }
    }

    private List<Thing> getContextThings(ActionContext actionContext) {
        ArrayList<Thing> allContexts = new ArrayList<Thing>();
        if (!actionContext.isDisableGloableContext()) {
            for (ThingEntry entry : Action.world.globalContexts) {
                this.addContextThing(allContexts, entry.getThing());
            }
        }
        if (this.contexts.size() > 0) {
            for (ThingEntry entry : this.contexts) {
                this.addContextThing(allContexts, entry.getThing());
            }
        }
        for (Bindings bindings : actionContext.getScopes()) {
            this.addContextThing(allContexts, bindings.getContextThing());
        }
        return allContexts;
    }

    private void addContextThing(List<Thing> contexts, Thing contextThing) {
        if (contextThing == null) {
            return;
        }
        contexts.add(contextThing);
    }

    private ActionException wrapToActionException(Throwable t, ActionContext actionContext) {
        Throwable cause;
        if (t instanceof InvocationTargetException && (cause = t.getCause()) != null) {
            t = cause;
        }
        if (t instanceof ActionException) {
            return (ActionException)t;
        }
        return new ActionException("Action exception: " + this.thingEntry.getPath(), t, actionContext);
    }

    private void logHideenExceptionStackTrace(Throwable t, ActionContext actionContext) {
        log.warn("action ActionContext stacktrace:" + this.thingEntry.getPath());
        log.warn(actionContext.getStackTrace());
        if (t instanceof InvocationTargetException) {
            log.warn("action hidden throwable", t.getCause());
        } else {
            log.warn("action hidden throwable", t);
        }
    }

    private static Throwable doContextMethod(List<Thing> contexts, ActionContext actionContext, String methodName, Throwable exception, Object result) {
        ArrayList<Thing> thingList = new ArrayList<Thing>();
        for (Thing thing : contexts) {
            thingList.add(thing);
        }
        return Action.doThingContextMethod(thingList, actionContext, methodName, exception, result);
    }

    public static Throwable doThingContextMethod(List<Thing> contexts, ActionContext actionContext, String methodName, Throwable exception, Object result) {
        if (contexts.size() == 0) {
            return exception;
        }
        String tempMethodName = methodName;
        Bindings bindings = actionContext.peek();
        bindings.put("action-exception", exception);
        bindings.put("action-result", result);
        bindings.put("contexts", contexts);
        int i = contexts.size() - 1;
        while (i >= 0) {
            block8: {
                Thing contextObj = contexts.get(i);
                ActionContext acContext = bindings.getContexts().get(contextObj);
                if (acContext != null) {
                    acContext.peek().put("exception", exception);
                }
                if (contextObj != null && acContext != null && acContext.getScope(0).getCaller() == contextObj) {
                    String onError = contextObj.getString("onError");
                    try {
                        String preventError;
                        contextObj.doAction(tempMethodName, acContext);
                        if ("exception".equals(methodName) && exception != null && "true".equals(preventError = contextObj.getString("preventError"))) {
                            exception = null;
                        }
                    }
                    catch (Exception e) {
                        log.error("\u6267\u884c" + contextObj.getMetadata().getPath() + "\u4e0a\u4e0b\u6587\u65b9\u6cd5" + methodName + "\u5931\u8d25\uff1a", (Throwable)e);
                        if ("exception".equals(onError)) {
                            tempMethodName = "exception";
                        }
                        if (exception != null) break block8;
                        exception = e;
                    }
                }
            }
            --i;
        }
        return exception;
    }

    public static void initContext(Action action, Thing context, ActionContext actionContext) {
        if (context == null || context.getBoolean("disable")) {
            return;
        }
        Bindings bindings = actionContext.peek();
        ActionContext acContext = new ActionContext();
        acContext.setDisableGloableContext(true);
        acContext.put(str_acContext, (Object)actionContext);
        acContext.put(str_parentContext, (Object)actionContext);
        acContext.put(str_action, (Object)action);
        acContext.put(str_actionThing, (Object)action.getThing());
        acContext.getScope(0).setCaller(context, "init");
        Object inheritObj = null;
        boolean needInherit = context.getBoolean("inherit");
        if (needInherit) {
            inheritObj = context.doAction("inherit", acContext);
        }
        if (inheritObj != null && inheritObj instanceof ActionContext) {
            bindings.getContexts().put(context, inheritObj);
        } else {
            bindings.getContexts().put(context, acContext);
            context.doAction("init", acContext);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getCompileClassPath() {
        return this.getThing().getMetadata().getThingManager().getClassLoader().getCompileClassPath();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static String getClassName(String className) {
        String[] cns = className.split("[.]");
        String cName = "";
        int i = 0;
        while (i < cns.length) {
            int n = 0;
            while (n < javaKeyWords.length) {
                if (cns[i].equals(javaKeyWords[n])) {
                    cns[i] = "t" + cns[i];
                    break;
                }
                ++n;
            }
            cns[i] = cns[i].replaceAll("(-)", "_");
            cns[i] = cns[i].replace(' ', '_');
            cName = cName.length() == 0 ? cns[i] : String.valueOf(cName) + "." + cns[i];
            ++i;
        }
        return cName;
    }

    public void setData(String key, Object data) {
        this.userData.put(key, data);
    }

    public Object getData(String key) {
        return this.userData.get(key);
    }

    public Thing getThing() {
        return this.thingEntry.getThing();
    }

    public static long getClassCompileTime(String classFileName) {
        File file = new File(classFileName);
        String path = file.getParentFile().getAbsolutePath();
        String className = file.getName();
        ClassCompileTimeFile timeFile = Action.getClassCompileTimeFile(path);
        if (timeFile != null) {
            return timeFile.getTime(className);
        }
        return 0L;
    }

    private static void updateClassCompileTime(String classFileName, long time) {
        File file = new File(classFileName);
        String path = file.getParentFile().getAbsolutePath();
        String className = file.getName();
        ClassCompileTimeFile timeFile = Action.getClassCompileTimeFile(path);
        if (timeFile != null) {
            timeFile.updateTime(className, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassCompileTimeFile getClassCompileTimeFile(String path) {
        Map<String, SoftReference<ClassCompileTimeFile>> map = classTimeFiles;
        synchronized (map) {
            SoftReference<ClassCompileTimeFile> fileRef = classTimeFiles.get(path);
            ClassCompileTimeFile file = null;
            if (fileRef != null) {
                file = fileRef.get();
            }
            if (file == null) {
                file = new ClassCompileTimeFile(path);
                fileRef = new SoftReference<ClassCompileTimeFile>(file);
                classTimeFiles.put(path, fileRef);
            }
            return file;
        }
    }

    public static int getThrowableRecordCount() {
        return throwableRecordCount;
    }

    public static void setThrowableRecordCount(int throwableRecordCount) {
        Action.throwableRecordCount = throwableRecordCount;
    }

    public static List<ThrowableRecord> getThrowables() {
        return throwables;
    }

    class ActionResult {
        String name;
        String runType;
        String condition;
        ThingEntry resultObj;

        public ActionResult(Thing resultObj) {
            this.name = resultObj.getMetadata().getName();
            this.runType = resultObj.getString("type");
            this.resultObj = new ThingEntry(resultObj);
            this.condition = resultObj.getString("condition");
        }

        public Object run(ActionContext actionContext) throws Exception {
            Thing resultThing = this.resultObj.getThing();
            if (resultThing == null) {
                return null;
            }
            List<Thing> rchilds = resultThing.getAllChilds();
            if (this.runType != null && this.runType.startsWith("RANDOM")) {
                Collections.shuffle(rchilds, new Random(System.currentTimeMillis()));
            }
            ArrayList<Rate> rates = null;
            Random random = new Random();
            int maxRate = 0;
            if ("RANDOM_RATE".equals(this.runType)) {
                rates = new ArrayList<Rate>();
                for (Thing child : rchilds) {
                    int rate = 1;
                    try {
                        rate = child.getInt("rate");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rate <= 0) {
                        rate = 1;
                    }
                    Rate r = new Rate();
                    r.minRate = maxRate;
                    r.maxRate = maxRate += rate;
                    rates.add(r);
                }
            }
            int runCount = rchilds.size() > 0 ? random.nextInt(rchilds.size()) : 0;
            int count = 0;
            Object result = null;
            while (count < rchilds.size()) {
                int sint;
                Exception aexception = null;
                boolean successed = false;
                Thing data = rchilds.get(count);
                try {
                    if ("RANDOM_RATE".equals(this.runType)) {
                        int rate = random.nextInt(maxRate);
                        Rate r = (Rate)rates.get(count);
                        if (r.minRate > rate || r.maxRate <= rate) continue;
                    }
                    if ((result = data.getAction().run(actionContext, null, true)) instanceof String) {
                        if ("success".equals(result)) {
                            successed = true;
                        }
                    } else {
                        successed = true;
                    }
                }
                catch (Exception ee) {
                    aexception = ee;
                }
                if (successed) {
                    if ("SUCCESS".equals(this.runType) || "RANDOM_SUCCESS".equals(this.runType)) {
                        break;
                    }
                } else if ("SUCCESS".equals(this.runType) || "RANDOM_SUCCESS".equals(this.runType)) {
                    if (aexception != null) {
                        log.error("run script method", (Throwable)aexception);
                    }
                } else if (aexception != null) {
                    throw aexception;
                }
                if ("RANDOM_RATE".equals(this.runType) || "RANDOM_ONE".equals(this.runType) || "RANDOM_RANDOM".equals(this.runType) && runCount == count || (sint = actionContext.getStatus()) == 1 || sint == 3 || sint == 4) break;
                if (sint == 2) {
                    actionContext.setStatus(0);
                    break;
                }
                ++count;
            }
            return result;
        }
    }

    static class ClassCompileTimeFile {
        Map<String, Long> classTimes;
        String timeFileName;

        public ClassCompileTimeFile(String path) {
            block15: {
                this.classTimes = new HashMap<String, Long>();
                this.timeFileName = null;
                File file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                File timeFile = new File(file, "_classTime.txt");
                this.timeFileName = timeFile.getAbsolutePath();
                if (timeFile.exists()) {
                    FileInputStream fin = null;
                    try {
                        try {
                            fin = new FileInputStream(timeFile);
                            BufferedReader br = new BufferedReader(new InputStreamReader(fin));
                            String line = null;
                            while ((line = br.readLine()) != null) {
                                String[] strs;
                                if ("".equals(line = line.trim()) || (strs = line.split("[|]")).length != 2) continue;
                                this.classTimes.put(strs[0], Long.parseLong(strs[1]));
                            }
                            br.close();
                        }
                        catch (Exception e) {
                            log.error("init class compile time file error, " + this.timeFileName, (Throwable)e);
                            if (fin == null) break block15;
                            try {
                                fin.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    finally {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }

        public long getTime(String className) {
            Long time = this.classTimes.get(className);
            if (time != null) {
                return time;
            }
            return 0L;
        }

        public synchronized void updateTime(String className, long time) {
            block13: {
                this.classTimes.put(className, time);
                FileOutputStream fout = null;
                try {
                    try {
                        fout = new FileOutputStream(this.timeFileName);
                        for (String key : this.classTimes.keySet()) {
                            Long ctime = this.classTimes.get(key);
                            fout.write((String.valueOf(key) + "|" + ctime + "\n").getBytes());
                        }
                    }
                    catch (Exception e) {
                        log.error("update class compile time file error, " + this.timeFileName, (Throwable)e);
                        if (fout == null) break block13;
                        try {
                            fout.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    class Rate {
        int minRate;
        int maxRate;

        Rate() {
        }
    }

    public static class ThrowableRecord {
        public Throwable throwable;
        public String actionStackTrace;
        public Date date;
        public String threadName;

        public ThrowableRecord(Throwable throwable, ActionContext actionContext) {
            this.throwable = throwable;
            this.actionStackTrace = actionContext.getStackTrace();
            this.date = new Date();
            this.threadName = Thread.currentThread().getName();
        }
    }
}

