/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xmeta.Action;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.util.UtilData;

public class ActionContext
implements Map<String, Object> {
    public static final int RUNNING = 0;
    public static final int RETURN = 1;
    public static final int CANCEL = 2;
    public static final int BREAK = 3;
    public static final int CONTINUE = 4;
    public static final int EXCEPTION = 5;
    public static final String RESULT_SUCCESS = "success";
    public static final String RESULT_FAILURE = "failure";
    public static final String RUNTYPE_DEFAULT = "DEFAULT";
    public static final String RUNTYPE_SUCCESS = "SUCCESS";
    public static final String RUNTYPE_RANDOM = "RANDOM";
    public static final String RUNTYPE_RANDOM_ONE = "RANDOM_ONE";
    public static final String RUNTYPE_RANDOM_RANDOM = "RANDOM_RANDOM";
    public static final String RUNTYPE_RANDOM_SUCCESS = "RANDOM_SUCCESS";
    public static final String RUNTYPE_RANDOM_RATE = "RANDOM_RATE";
    public static final String PARENT_CONTEXT = "parentContext";
    private ThreadLocal<Stack<Bindings>> threadStacks = new ThreadLocal();
    private ThreadLocal<Integer> threadStatus = new ThreadLocal();
    private ThreadLocal<Object> threadThrowedObject = new ThreadLocal();
    private Stack<Bindings> baseStacks = new Stack();
    private Thread createThread = null;
    private int dummyScopeCount = 0;
    private ThreadLocal<Stack<Action>> actionStacks = new ThreadLocal();
    private String label = null;
    private boolean disableGloableContext = false;

    public ActionContext() {
        this((Bindings)null);
    }

    public ActionContext(boolean managedByPool) {
        this((Bindings)null);
        managedByPool = true;
    }

    public ActionContext(ActionContext actionContext) {
        this.createThread = Thread.currentThread();
        for (Bindings binding : actionContext.getScopes()) {
            this.baseStacks.push(binding);
            ++this.dummyScopeCount;
        }
        Bindings bindings = this.push(null);
        bindings.put("actionContext", this);
        bindings.put("_g", bindings);
    }

    public ActionContext(Bindings bindings) {
        this.createThread = Thread.currentThread();
        Bindings bds = this.push(bindings);
        bds.put("actionContext", this);
        bds.put("_g", bds);
    }

    private Stack<Action> getActionStack() {
        Stack<Action> actionStack = this.actionStacks.get();
        if (actionStack == null) {
            actionStack = new Stack();
            this.actionStacks.set(actionStack);
        }
        return actionStack;
    }

    public void pushAction(Action action) {
        this.getActionStack().push(action);
    }

    public void popAction() {
        this.getActionStack().pop();
    }

    public Action getAction() {
        return this.getActionStack().peek();
    }

    private Stack<Bindings> getBindingStack() {
        Stack<Bindings> stack = this.threadStacks.get();
        if (stack == null) {
            if (this.createThread == Thread.currentThread()) {
                return this.baseStacks;
            }
            stack = new Stack();
            int i = 0;
            while (i < this.dummyScopeCount + 1) {
                stack.push((Bindings)this.baseStacks.get(i));
                ++i;
            }
            this.threadStacks.set(stack);
        }
        return stack;
    }

    public int getStatus() {
        Integer status = this.threadStatus.get();
        if (status == null) {
            return 0;
        }
        return status;
    }

    public boolean isDisableGlobalContext() {
        return this.peek().disableGloableContext;
    }

    public void setStatus(int status) {
        this.threadStatus.set(status);
    }

    public void _break() {
        this.setStatus(3);
    }

    public void _ontinue() {
        this.setStatus(4);
    }

    public void _return(Object obj) {
        this.setStatus(1);
    }

    public void _exception(Object throwedObject) {
        this.setStatus(5);
        this.setThrowedObject(throwedObject);
    }

    public Bindings push() {
        return this.push(null);
    }

    public Bindings push(Bindings bindings) {
        if (bindings == null) {
            bindings = new Bindings();
        }
        Stack<Bindings> stacks = this.getBindingStack();
        stacks.push(bindings);
        return bindings;
    }

    public Bindings pushPoolBindings() {
        return this.push(new Bindings());
    }

    public Bindings peek() {
        return this.getBindingStack().peek();
    }

    public Bindings pop() {
        return this.getBindingStack().pop();
    }

    public List<Bindings> getScopes() {
        ArrayList<Bindings> bindings = new ArrayList<Bindings>();
        Stack<Bindings> bindingsStack = this.getBindingStack();
        int i = 0;
        while (i < bindingsStack.size()) {
            bindings.add((Bindings)bindingsStack.get(i));
            ++i;
        }
        return bindings;
    }

    public Bindings getScope() {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        int i = bindingsStack.size() - 1;
        while (i >= 0) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (bindings.isVarScopeFlag()) {
                return bindings;
            }
            --i;
        }
        return null;
    }

    public Bindings getLocalScope() {
        return this.getScope();
    }

    public Bindings getGlobalScope() {
        return this.getScope(0);
    }

    public Bindings g() {
        return this.getScope(0);
    }

    public Bindings l() {
        return this.getScope();
    }

    public Bindings l(int index) {
        int c = 0;
        Stack<Bindings> bindingsStack = this.getBindingStack();
        int i = bindingsStack.size() - 1;
        while (i >= 0) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (bindings.isVarScopeFlag()) {
                if (c == index) {
                    return bindings;
                }
                ++c;
            }
            --i;
        }
        return null;
    }

    public String getStackTrace() {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        String content = "ActionContext stacktrace, thread=" + Thread.currentThread().getName() + ":";
        int i = bindingsStack.size() - 1;
        while (i >= 0) {
            String method;
            String stack = "";
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (bindings.getCaller() != null) {
                Object caller = bindings.getCaller();
                stack = caller instanceof Thing ? String.valueOf(stack) + "caller: thing: " + ((Thing)caller).getMetadata().getPath() : (caller instanceof Action ? String.valueOf(stack) + "caller: action: " + ((Action)caller).getThing().getMetadata().getPath() : String.valueOf(stack) + "caller: object: " + caller.getClass());
            }
            if ((method = bindings.getCallerMethod()) != null && !"".equals(method)) {
                stack = String.valueOf(stack) + ", callerMethod: " + method;
            }
            if (bindings.getContexts() != null) {
                String values = "";
                for (Thing key : bindings.getContexts().keySet()) {
                    values = String.valueOf(values) + key.getMetadata().getPath() + ",";
                }
                if (!"".equals(values)) {
                    stack = String.valueOf(stack) + ", contexts: " + values;
                }
            }
            if (!"".equals(stack)) {
                content = String.valueOf(content) + "\n    " + stack;
            }
            --i;
        }
        return content;
    }

    public void printStackTrace() {
        System.out.println(this.getStackTrace());
    }

    public Bindings getScope(int index) {
        return (Bindings)this.getBindingStack().get(index + this.dummyScopeCount);
    }

    /*
     * Unable to fully structure code
     */
    public Bindings getScope(String actionThingPath) {
        if (actionThingPath == null) {
            return null;
        }
        if ("Global".equals(actionThingPath)) {
            return this.getScope(0);
        }
        if ("Local".equals(actionThingPath)) {
            bindingsStack = this.getBindingStack();
            return bindingsStack.peek();
        }
        try {
            stack = Integer.parseInt(actionThingPath);
            return this.getScope(stack);
        }
        catch (Exception e) {
            bindingsStack = this.getBindingStack();
            i = bindingsStack.size() - 1;
            ** GOTO lbl22
        }
        {
            --i;
            do {
                if (i >= bindingsStack.size()) continue block2;
                bindings = (Bindings)bindingsStack.get(i);
                if (bindings.getCaller() instanceof Action != false ? actionThingPath.equals((action = (Action)bindings.getCaller()).getThing().getMetadata().getPath()) != false || actionThingPath.equals(action.getThing().getMetadata().getName()) != false : bindings.getCaller() instanceof Thing != false && ((thing = (Thing)bindings.getCaller()) != null && actionThingPath.equals(thing.getMetadata().getPath()) != false || actionThingPath.equals(thing.getMetadata().getName()) != false)) {
                    return bindings;
                }
                --i;
lbl22:
                // 2 sources

            } while (i >= 0);
        }
        return null;
    }

    public int getScopesSize() {
        return this.getBindingStack().size() - this.dummyScopeCount;
    }

    public int getScopesSizeAll() {
        return this.getBindingStack().size();
    }

    @Override
    public void clear() {
        this.getBindingStack().peek().clear();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean containsKey(Object key) {
        ck = false;
        bindingsStack = this.getBindingStack();
        i = bindingsStack.size() - 1;
        ** GOTO lbl12
        {
            --i;
            do {
                if (i >= bindingsStack.size()) continue block0;
                if (((Bindings)bindingsStack.get(i)).containsKey(key)) {
                    ck = true;
                    break block0;
                }
                --i;
lbl12:
                // 2 sources

            } while (i >= 0);
        }
        return ck;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean containsValue(Object value) {
        bindingsStack = this.getBindingStack();
        i = bindingsStack.size() - 1;
        ** GOTO lbl10
        {
            --i;
            do {
                if (i >= bindingsStack.size()) continue block0;
                if (((Bindings)bindingsStack.get(i)).containsValue(value)) {
                    return true;
                }
                --i;
lbl10:
                // 2 sources

            } while (i >= 0);
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap map = new HashMap();
        Stack<Bindings> bindingsStack = this.getBindingStack();
        int i = 0;
        while (i < bindingsStack.size()) {
            map.putAll((Map)bindingsStack.get(i));
            ++i;
        }
        return map.entrySet();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object get(Object key) {
        if (key == null || "".equals(key)) {
            return null;
        }
        value = null;
        bindingsStack = this.getBindingStack();
        i = bindingsStack.size() - 1;
        ** GOTO lbl14
        {
            --i;
            do {
                if (i >= bindingsStack.size()) continue block0;
                map = (Map)bindingsStack.get(i);
                value = map.get(key);
                if (value != null || map.containsKey(key)) break block0;
                --i;
lbl14:
                // 2 sources

            } while (i >= 0);
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public Object getParameter(Object key) {
        if (key == null || "".equals(key)) {
            return null;
        }
        value = null;
        bindingsStack = this.getBindingStack();
        i = bindingsStack.size() - 1;
        ** GOTO lbl12
        {
            --i;
            do {
                if (i >= bindingsStack.size()) continue block0;
                if (((Bindings)bindingsStack.get(i)).isParameterScope() && ((value = (map = (Map)bindingsStack.get(i)).get(key)) != null || map.containsKey(key))) break block0;
                --i;
lbl12:
                // 2 sources

            } while (i >= 0);
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public Object get(Object key, String scopeThingPath) {
        bindingsStack = this.getBindingStack();
        i = bindingsStack.size() - 1;
        ** GOTO lbl14
        {
            --i;
            do {
                if (i >= bindingsStack.size()) continue block0;
                bindings = (Bindings)bindingsStack.get(i);
                currentThing = null;
                if (bindings.getCaller() instanceof Action) {
                    currentThing = ((Action)bindings.getCaller()).getThing();
                }
                if (currentThing != null && scopeThingPath.equals(currentThing.getMetadata().getPath())) {
                    return bindings.get(key);
                }
                --i;
lbl14:
                // 2 sources

            } while (i >= 0);
        }
        return null;
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Bindings bindings : this.getBindingStack()) {
            if (!(bindings.getCaller() instanceof Action)) continue;
            actions.add((Action)bindings.getCaller());
        }
        return actions;
    }

    public List<Thing> getThings() {
        ArrayList<Thing> things = new ArrayList<Thing>();
        for (Bindings bindings : this.getBindingStack()) {
            if (!(bindings.getCaller() instanceof Thing)) continue;
            things.add((Thing)bindings.getCaller());
        }
        return things;
    }

    @Override
    public boolean isEmpty() {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        int i = bindingsStack.size() - 1;
        while (i >= 0) {
            if (!((Bindings)bindingsStack.get(i)).isEmpty()) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> aset = new HashSet<String>();
        int i = this.getBindingStack().size() - 1;
        while (i >= 0) {
            aset.addAll(((Bindings)this.getBindingStack().get(i)).keySet());
            --i;
        }
        return aset;
    }

    @Override
    public Object put(String key, Object value) {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        int i = bindingsStack.size() - 1;
        while (i >= this.dummyScopeCount) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (bindings.containsKey(key)) {
                return bindings.put(key, value);
            }
            --i;
        }
        Object v = this.getScope(0).put(key, value);
        return v;
    }

    public Object put(String key, Object value, String scopeThingPath) {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        int i = bindingsStack.size() - 1;
        while (i >= this.dummyScopeCount) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            Thing currentThing = null;
            if (bindings.getCaller() instanceof Action) {
                currentThing = ((Action)bindings.getCaller()).getThing();
            }
            if (currentThing != null && scopeThingPath.equals(currentThing.getMetadata().getPath())) {
                return bindings.put(key, value);
            }
            --i;
        }
        return null;
    }

    public Object putTo(String key, String scopeThingPath) {
        Object value = this.get(key);
        return this.put(key, value, scopeThingPath);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        return this.getBindingStack().peek().remove(key);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String key : this.keySet()) {
            list.add(this.get(key));
        }
        return list;
    }

    public void setThrowedObject(Object obj) {
        this.threadThrowedObject.set(obj);
    }

    public Object getThrowedObject() {
        return this.threadThrowedObject.get();
    }

    public String toString() {
        return "ActionContext [hashCode=" + this.hashCode() + ",callers=" + this.getThings() + "]";
    }

    public String getString(String key) {
        return UtilData.getString(this.get(key), null);
    }

    public byte getByte(String key) {
        return UtilData.getByte(this.get(key), (byte)0);
    }

    public short getShort(String key) {
        return UtilData.getShort(this.get(key), (short)0);
    }

    public int getInt(String key) {
        return UtilData.getInt(this.get(key), 0);
    }

    public long getLong(String key) {
        return UtilData.getLong(this.get(key), 0L);
    }

    public boolean getBoolean(String key) {
        return UtilData.getBoolean(this.get(key), false);
    }

    public byte[] getBytes(String key) {
        return UtilData.getBytes(this.get(key), null);
    }

    public Date getDate(String key) {
        return UtilData.getDate(this.get(key), null);
    }

    public double getDouble(String key) {
        return UtilData.getDouble(this.get(key), 0.0);
    }

    public float getFloat(String key) {
        return UtilData.getFloat(this.get(key), 0.0f);
    }

    public BigDecimal getBigDecimal(String key) {
        return UtilData.getBigDecimal(this.get(key), null);
    }

    public BigInteger getBigInteger(String key) {
        return UtilData.getBigInteger(this.get(key), null);
    }

    public <T> T getObject(String key) {
        Object obj = this.get(key);
        return (T)obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isDisableGloableContext() {
        return this.disableGloableContext;
    }

    public void setDisableGloableContext(boolean disableGloableContext) {
        this.disableGloableContext = disableGloableContext;
    }
}

