/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.util.List;
import java.util.Locale;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.codes.DmlThingCoder;
import org.xmeta.ui.session.Session;
import org.xmeta.ui.session.SessionManager;

public class ThingMetadata {
    String id;
    long lastModifed;
    String path;
    String reserve;
    Thing thing;
    Category category;
    int fileVersion;
    boolean includeDefaultValue = false;
    boolean removed = false;
    String coderType = DmlThingCoder.TYPE;
    String userGroup = null;

    public ThingMetadata(Thing thing) {
        this.thing = thing;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void initPath() {
        if (this.category != null) {
            String packageName = this.category.getName();
            String fileName = this.reserve;
            if (fileName == null) {
                fileName = this.getName();
            }
            this.path = packageName != null ? String.valueOf(packageName) + "." + fileName : fileName;
        }
    }

    public long getLastModified() {
        return this.lastModifed;
    }

    public void setLastModified(long lastModified) {
        this.lastModifed = lastModified;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.id == null || "".equals(this.id)) {
            try {
                this.id = (String)this.thing.getAttributes().get("id");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.id;
    }

    public void setId(String id) {
        int index;
        this.id = id;
        if (this.path != null && (index = this.path.lastIndexOf("@")) != -1) {
            this.path = String.valueOf(this.path.substring(0, index)) + "@" + id;
        }
        for (Thing child : this.thing.getChilds()) {
            this.thing.initChildMetadata(child);
        }
    }

    public String getName() {
        String name = (String)this.thing.attributes.get("name");
        if (name != null && !"".equals(name)) {
            return name;
        }
        List<Thing> descriptors = this.thing.getDescriptors();
        if (descriptors.size() > 0) {
            return (String)descriptors.get((int)0).attributes.get("name");
        }
        return "";
    }

    public String getLabel() {
        Session session = SessionManager.getSession(null);
        Locale locale = session.getLocale();
        return this.getLabel(locale);
    }

    public String getLabel(ActionContext actionContext) {
        Session session = SessionManager.getSession(actionContext);
        Locale locale = session.getLocale();
        return this.getLabel(locale);
    }

    public String getGroup() {
        if (this.userGroup != null && !"".equals(this.userGroup)) {
            return this.userGroup;
        }
        Session session = SessionManager.getSession(null);
        Locale locale = session.getLocale();
        return this.getLocaleString("group", locale);
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    public String getLabel(Locale locale) {
        String label = this.getLocaleString("label", locale);
        if (label == null) {
            return this.getName();
        }
        return label;
    }

    public String getLocaleString(String name, Locale locale) {
        if (locale == null) {
            Session session = SessionManager.getSession(null);
            locale = session.getLocale();
        }
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String label = this.thing.getString(String.valueOf(country) + "_" + language + "_" + name);
        if (label == null || "".equals(label)) {
            label = this.thing.getString(String.valueOf(language) + "_" + name);
        }
        if (label == null || "".equals(label)) {
            label = this.thing.getString(name);
        }
        if (label == null || "".equals(label)) {
            return null;
        }
        return label;
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(ActionContext actionContext) {
        List<Thing> extendsThing;
        Session session = SessionManager.getSession(actionContext);
        Locale locale = session.getLocale();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String description = this.thing.getString(String.valueOf(country) + "_" + language + "_" + "description");
        if (description == null || "".equals(description)) {
            description = this.thing.getString(String.valueOf(language) + "_" + "description");
        }
        if (description == null || "".equals(description)) {
            description = this.thing.getString("description");
        }
        if ((description == null || "".equals(description.trim())) && this.thing.getBoolean("inheritDescription") && (extendsThing = this.thing.getExtends()).size() > 0) {
            return extendsThing.get(0).getMetadata().getDescription();
        }
        return description;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getPaths() {
        List<Thing> extendList = this.thing.getAllExtends();
        String[] paths = new String[1 + extendList.size()];
        paths[0] = this.getPath();
        int i = 1;
        while (i <= extendList.size()) {
            Thing ext = extendList.get(i - 1);
            paths[i] = ext.getMetadata().getPath();
            ++i;
        }
        return paths;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ThingManager getThingManager() {
        return this.category.getThingManager();
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(int fileVersion) {
        this.fileVersion = fileVersion;
    }

    public boolean isIncludeDefaultValue() {
        return this.includeDefaultValue;
    }

    public void setIncludeDefaultValue(boolean includeDefaultValue) {
        this.includeDefaultValue = includeDefaultValue;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
        for (Thing child : this.thing.childs) {
            child.getMetadata().setRemoved(removed);
        }
    }

    public String getCoderFileType() {
        ThingCoder coder = World.getInstance().getThingCoder(this.coderType);
        if (coder == null) {
            throw new ActionException("ThingCoder not exists, type=" + this.coderType);
        }
        return coder.getType();
    }

    public String getCoderType() {
        return this.coderType;
    }

    public void setCoderType(String coderType) {
        this.coderType = coderType;
    }
}

