/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.annotation.AAction;
import org.xmeta.annotation.AAttribute;
import org.xmeta.annotation.AChild;
import org.xmeta.annotation.AChildXml;
import org.xmeta.annotation.AThing;
import org.xmeta.annotation.AThingAttribute;
import org.xmeta.annotation.AThingChild;
import org.xmeta.util.UtilString;

public class ThingAnnotationUtils {
    public static Thing parse(Class<?> cls) {
        AThing athing = cls.getAnnotation(AThing.class);
        if (athing == null) {
            return null;
        }
        Thing thing = new Thing(athing.descriptors());
        thing.set("extends", athing.extends_());
        String attrs = athing.attributes();
        if (attrs != null) {
            Map<String, String> as = UtilString.getParams(attrs);
            for (String key : as.keySet()) {
                thing.set(key, as.get(key));
            }
        }
        Object[] objectArray = (AThingAttribute[])cls.getAnnotationsByType(AThingAttribute.class);
        int n = objectArray.length;
        int key = 0;
        while (key < n) {
            AThingAttribute attr = objectArray[key];
            thing.set(attr.name(), attr.value());
            ++key;
        }
        objectArray = (AThingChild[])cls.getAnnotationsByType(AThingChild.class);
        n = objectArray.length;
        key = 0;
        while (key < n) {
            Annotation achild = objectArray[key];
            Thing child = new Thing();
            child.set("name", achild.name());
            child.set("extends", achild.descriptors());
            thing.addChild(child);
            ++key;
        }
        objectArray = cls.getDeclaredFields();
        n = objectArray.length;
        key = 0;
        while (key < n) {
            Object field = objectArray[key];
            AAttribute aatri = ((Field)field).getAnnotation(AAttribute.class);
            if (aatri != null) {
                try {
                    if ((((Field)field).getModifiers() & 8) == 8) {
                        thing.set(((Field)field).getName(), ((Field)field).get(null));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else {
                AChild achild = ((Field)field).getAnnotation(AChild.class);
                if (achild != null) {
                    if ((((Field)field).getModifiers() & 8) == 8) {
                        try {
                            Object obj = ((Field)field).get(null);
                            if (obj != null && obj instanceof Thing) {
                                thing.addChild((Thing)obj);
                            } else {
                                Thing child = ThingAnnotationUtils.parse(((Field)field).getType());
                                if (child != null) {
                                    thing.addChild(child);
                                }
                            }
                        }
                        catch (IllegalArgumentException obj) {
                        }
                        catch (IllegalAccessException obj) {}
                    }
                } else {
                    AChildXml achildxml = ((Field)field).getAnnotation(AChildXml.class);
                    if (achildxml != null && (((Field)field).getModifiers() & 8) == 8) {
                        try {
                            String xml = (String)((Field)field).get(null);
                            if (xml != null) {
                                thing.addChild(xml);
                            }
                        }
                        catch (IllegalArgumentException xml) {
                        }
                        catch (IllegalAccessException xml) {
                        }
                        catch (Exception e) {
                            throw new ActionException("Parse xml error, field=" + field, e);
                        }
                    }
                }
            }
            ++key;
        }
        Thing actions = null;
        Method[] methodArray = cls.getDeclaredMethods();
        int n2 = methodArray.length;
        n = 0;
        while (n < n2) {
            Method method = methodArray[n];
            AAction aaction = method.getAnnotation(AAction.class);
            if (aaction != null) {
                if (actions == null) {
                    actions = new Thing("actions");
                    thing.addChild(actions);
                }
                Thing javaAction = new Thing("JavaAction");
                javaAction.set("name", method.getName());
                javaAction.set("useOuterJava", "true");
                javaAction.set("outerClassName", cls.getName());
                javaAction.set("methodName", method.getName());
                actions.addChild(javaAction);
            }
            ++n;
        }
        return thing;
    }
}

