/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingIndex;
import org.xmeta.XMetaException;

public class JsonThingCoder
implements ThingCoder {
    private static ObjectMapper mapper = null;
    private static String codeType = "xer.js";

    @Override
    public void encode(Thing thing, OutputStream out) {
        throw new ActionException("JsonThingCoder doese not supper encode method, code is edit by hand");
    }

    private synchronized void initMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
    }

    @Override
    public void decode(Thing thing, InputStream in, long lastModifyed) {
        try {
            this.initMapper();
            Map values = (Map)mapper.readValue(in, Map.class);
            HashMap<String, String> importContext = new HashMap<String, String>();
            Map imports = (Map)values.get("imports");
            if (imports != null) {
                for (String key : imports.keySet()) {
                    importContext.put(key, String.valueOf(imports.get(key)));
                }
            }
            for (String key : values.keySet()) {
                if ("imports".equals(key)) continue;
                this.decode(thing, key, values.get(key), importContext, lastModifyed, false);
                break;
            }
        }
        catch (Exception e) {
            throw new XMetaException("decode json thing error", e);
        }
    }

    private void decode(Thing thing, String thingName, Object value, Map<String, String> imports, long lastModifyed, boolean decodeIndex) {
        Map<String, Object> attributes = thing.getAttributes();
        if (!(value instanceof Map)) {
            thing.put(thingName, value);
            return;
        }
        String descriptors = null;
        Map values = (Map)value;
        String descs = (String)values.get("descriptors");
        descriptors = descs == null ? this.importToNormalString(thingName, imports) : this.importToNormalString(String.valueOf(thingName) + "," + descs, imports);
        attributes.put("descriptors", descriptors);
        String exts = (String)values.get("extends");
        if (exts != null) {
            attributes.put("extends", this.importToNormalString(exts, imports));
        }
        for (String key : values.keySet()) {
            if ("descriptors".equals(key) || "extends".equals(key)) continue;
            if ("xid".equals(key)) {
                thing.getMetadata().setId((String)values.get(key));
                continue;
            }
            Object v = values.get(key);
            if (v instanceof Map) {
                if (decodeIndex) continue;
                Thing child = new Thing();
                this.decode(child, key, v, imports, lastModifyed, decodeIndex);
                thing.addChild(child);
                continue;
            }
            attributes.put(key, v);
        }
        thing.initDefaultValue();
        thing.getMetadata().setLastModified(lastModifyed);
    }

    public String importToNormalString(String str, Map<String, String> imports) {
        String strs = null;
        if (str == null) {
            return strs;
        }
        String[] stringArray = str.split("[,]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int index = s.indexOf(":");
            if (index != -1) {
                String key = s.substring(0, index);
                String subPath = s.substring(index, s.length());
                String imp = imports.get(key);
                if (imp == null && "thing".equals(imp)) {
                    imp = "MetaThing";
                }
                s = String.valueOf(imp) + subPath;
            } else {
                String imp = imports.get(s);
                if (imp != null) {
                    s = imp;
                }
            }
            strs = strs == null ? s : String.valueOf(strs) + "," + s;
            ++n2;
        }
        return strs;
    }

    @Override
    public void decodeIndex(ThingIndex thingIndex, InputStream in, long lastModifyed) {
        try {
            this.initMapper();
            Map values = (Map)mapper.readValue(in, Map.class);
            HashMap<String, String> importContext = new HashMap<String, String>();
            Map imports = (Map)values.get("imports");
            if (imports != null) {
                for (String key : imports.keySet()) {
                    importContext.put(key, String.valueOf(imports.get(key)));
                }
            }
            Thing thing = new Thing();
            for (String key : values.keySet()) {
                if ("imports".equals(key)) continue;
                this.decode(thing, key, values.get(key), importContext, lastModifyed, false);
                break;
            }
            thingIndex.name = thing.getMetadata().getName();
            thingIndex.description = thing.getString("description");
            thingIndex.descriptors = thing.getString("descriptors");
            thingIndex.extendsStr = thing.getString("extends");
            thingIndex.label = thing.getString("label");
            thingIndex.lastModified = lastModifyed;
        }
        catch (Exception e) {
            throw new XMetaException("decode json thing error", e);
        }
    }

    @Override
    public String getType() {
        return codeType;
    }

    @Override
    public boolean acceptType(String type) {
        return codeType.equals(type);
    }

    @Override
    public String[] getCodeTypes() {
        return new String[]{codeType};
    }
}

