/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingCoderException;
import org.xmeta.ThingIndex;
import org.xmeta.codes.XerCoder;

public class XerThingCoder
implements ThingCoder {
    private static final Logger logger = LoggerFactory.getLogger(XerThingCoder.class);
    public static String TYPE = "xer";

    @Override
    public void decode(Thing thing, InputStream in, long loastModifyed) {
        thing.beginModify();
        try {
            try {
                XerCoder.decode(thing, in);
            }
            catch (Exception e) {
                logger.error("decode thing error, still return part decoded thing", (Throwable)e);
                thing.endModify(false);
            }
        }
        finally {
            thing.endModify(false);
        }
    }

    @Override
    public void decodeIndex(ThingIndex thingIndex, InputStream in, long lastModifyed) {
        try {
            int length = in.available();
            byte[] bytes = new byte[length];
            in.read(bytes);
            Thing thing = XerCoder.decodeAttributeOnly(bytes, 0);
            thingIndex.label = thing.getMetadata().getLabel();
            thingIndex.description = thing.getString("description");
            thingIndex.descriptors = thing.getString("descriptors");
            thingIndex.lastModified = lastModifyed;
        }
        catch (Exception e) {
            throw new ThingCoderException(e);
        }
    }

    @Override
    public void encode(Thing thing, OutputStream out) {
        try {
            XerCoder.encode(thing, out, new HashMap<Thing, String>());
        }
        catch (IOException e) {
            throw new ThingCoderException(e);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean acceptType(String type) {
        return TYPE.equals(type);
    }

    @Override
    public String[] getCodeTypes() {
        return new String[]{TYPE};
    }
}

