/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.index;

import java.util.HashMap;
import java.util.List;
import org.xmeta.Category;
import org.xmeta.Index;
import org.xmeta.Thing;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.index.CategoryIndex;
import org.xmeta.index.ThingIndexIndex;
import org.xmeta.index.ThingManagerIndex;
import org.xmeta.index.WorkingSetIndex;

public abstract class IndexFactory {
    public static IndexFactory thingIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new ThingIndexIndex(parent, (ThingIndex)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((ThingIndex)obj).name;
        }
    };
    public static IndexFactory categoryIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new CategoryIndex(parent, (Category)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((Category)obj).getSimpleName();
        }
    };
    public static IndexFactory workingSetIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new WorkingSetIndex(parent, (Thing)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((Thing)obj).getMetadata().getName();
        }
    };
    public static IndexFactory thingManagerIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new ThingManagerIndex(parent, (ThingManager)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((ThingManager)obj).getName();
        }
    };

    public abstract Index createIndex(Index var1, Object var2);

    public abstract String getName(Object var1);

    public static void addOrRemoveChilds(Index parent, List<Index> childs, List indexObjects, IndexFactory indexFactory, String type) {
        HashMap<String, Index> existsMap = new HashMap<String, Index>();
        for (Index child : childs) {
            existsMap.put(child.getName(), child);
        }
        HashMap<String, Index> context = new HashMap<String, Index>();
        for (Object obj : indexObjects) {
            Index index = (Index)existsMap.get(indexFactory.getName(obj));
            if (index == null) {
                index = indexFactory.createIndex(parent, obj);
                childs.add(index);
            }
            context.put(indexFactory.getName(obj), index);
        }
        int i = 0;
        while (i < childs.size()) {
            Index child = childs.get(i);
            if (type.equals(child.getType()) && context.get(child.getName()) == null) {
                childs.remove(i);
                --i;
            }
            ++i;
        }
    }
}

