/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.index;

import java.util.ArrayList;
import java.util.List;
import org.xmeta.Index;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.index.IndexFactory;
import org.xmeta.index.WorldIndex;

public class WorkingSetIndex
extends Index {
    String thingPath;
    Index parent = null;
    Thing thing = null;
    List<Index> childs = null;

    public WorkingSetIndex(Index parent, Thing thing) {
        this.parent = parent;
        this.thingPath = thing.getMetadata().getPath();
        this.thing = thing;
    }

    @Override
    public Object getIndexObject() {
        return World.getInstance().getThing(this.thingPath);
    }

    public Thing getThing() {
        Thing t = World.getInstance().getThing(this.thingPath);
        if (t == null) {
            return this.thing;
        }
        return t;
    }

    @Override
    public Index getParent() {
        return this.parent;
    }

    @Override
    public List<Index> getChilds() {
        if (!this.indexed) {
            this.refresh();
        }
        return this.childs;
    }

    @Override
    public String getDescription() {
        return this.getThing().getString("description");
    }

    @Override
    public String getLabel() {
        return this.getThing().getMetadata().getLabel();
    }

    @Override
    public String getName() {
        return this.getThing().getMetadata().getName();
    }

    @Override
    public String getPath() {
        return this.getThing().getMetadata().getPath();
    }

    @Override
    public String getType() {
        return "workingSet";
    }

    @Override
    public boolean refresh() {
        this.indexed = true;
        Thing thing = this.getThing();
        if (thing == null) {
            return false;
        }
        if (this.childs == null) {
            this.childs = new ArrayList<Index>();
        }
        World world = World.getInstance();
        List<Thing> childWorkdSets = thing.getChilds("WorkingSet");
        IndexFactory.addOrRemoveChilds(this, this.childs, childWorkdSets, IndexFactory.workingSetIndexFactory, "workingSet");
        List<Thing> thingManagers = thing.getChilds("ThingManager");
        ArrayList<ThingManager> tlist = new ArrayList<ThingManager>();
        for (Thing t : thingManagers) {
            ThingManager manager = world.getThingManager(t.getString("name"));
            if (manager == null) continue;
            tlist.add(manager);
        }
        IndexFactory.addOrRemoveChilds(this, this.childs, tlist, IndexFactory.thingManagerIndexFactory, "thingManager");
        for (Index child : this.childs) {
            if (!child.getType().equals("workingSet")) continue;
            child.refresh();
        }
        WorldIndex.sort(this.childs);
        return true;
    }
}

