/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.ThingManagerListener;
import org.xmeta.World;
import org.xmeta.cache.ThingCache;

public abstract class AbstractThingManager
implements ThingManager {
    protected String name = null;
    Category rootCategory = null;
    protected List<ThingManagerListener> listeners = new ArrayList<ThingManagerListener>();
    protected List<Package> packages = new ArrayList<Package>();
    protected File rootDir;

    public AbstractThingManager(String name) {
        this.name = name;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public Category getCategory(String categoryName) {
        return this.getCategory(categoryName, false);
    }

    public Category getCategory(String categoryName, boolean refresh) {
        if (categoryName == null || "".equals(categoryName)) {
            return this.rootCategory;
        }
        Category pkg = this.rootCategory;
        String[] stringArray = categoryName.split("[.]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pkName = stringArray[n2];
            Category childPkg = pkg.getCategory(pkName);
            if (childPkg == null) {
                if (refresh) {
                    pkg.refresh();
                }
                pkg = pkg.getCategory(pkName);
            } else {
                pkg = childPkg;
            }
            if (pkg == null) {
                return null;
            }
            ++n2;
        }
        return pkg;
    }

    public void refreshParentCategory(String categoryName) {
        int index;
        if (categoryName == null || "".equals(categoryName)) {
            this.rootCategory.refresh();
        }
        if ((index = categoryName.lastIndexOf(".")) != -1) {
            String name = categoryName.substring(0, index);
            Category category = this.getCategory(name, true);
            if (category != null) {
                category.refresh();
            } else {
                this.refreshParentCategory(name);
                category = this.getCategory(name, true);
                if (category != null) {
                    category.refresh();
                }
            }
        }
    }

    @Override
    public List<Category> getCategorys() {
        return this.rootCategory.getCategorys();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ThingIndex> getThingIndexs(String categoryName) {
        Category category = this.getCategory(categoryName);
        if (category != null) {
            return category.getThingIndexs();
        }
        return null;
    }

    @Override
    public List<ThingIndex> getThingIndexs(String categoryName, String descriptorPath) {
        Category category = this.getCategory(categoryName);
        if (category != null) {
            return category.getThingIndexs(descriptorPath);
        }
        return null;
    }

    @Override
    public List<Thing> getThings(String categoryName, String descriptorPath) {
        Category category = this.getCategory(categoryName);
        if (category != null) {
            return category.getThings(descriptorPath);
        }
        return null;
    }

    @Override
    public List<Thing> getThings(String categoryName) {
        Category category = this.getCategory(categoryName);
        if (category != null) {
            return category.getThings();
        }
        return null;
    }

    @Override
    public Iterator<Thing> iterator(String categoryName, boolean includeChildCategory) {
        return this.iterator(categoryName, null, includeChildCategory);
    }

    @Override
    public Iterator<Thing> iterator(String categoryName, String descriptorPath, boolean includeChildCategory) {
        Category category = this.getCategory(categoryName);
        if (category == null) {
            return Collections.emptyIterator();
        }
        return category.iterator(descriptorPath, includeChildCategory);
    }

    @Override
    public void refresh(String categoryName, boolean includeChildCategory) {
        Category category = this.getCategory(categoryName);
        if (category != null) {
            category.refresh(includeChildCategory);
        }
    }

    @Override
    public void addThingManagerListener(ThingManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeThingManagerListener(ThingManagerListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public Thing getThing(String thingName) {
        Thing thing = ThingCache.get(thingName);
        if (thing != null) {
            if (thing.getMetadata().isRemoved()) {
                thing = null;
            } else {
                return thing;
            }
        }
        if ((thing = this.doLoadThing(thingName)) != null) {
            for (ThingManagerListener listener : this.listeners) {
                listener.loaded(this, thing);
            }
            for (ThingManagerListener listener : World.getInstance().getThingManagerListeners(this.getName())) {
                listener.loaded(this, thing);
            }
        }
        return thing;
    }

    public abstract Thing doLoadThing(String var1);

    @Override
    public boolean remove(Thing thing) {
        boolean removed = this.doRemoveThing(thing);
        if (thing != null) {
            for (ThingManagerListener listener : this.listeners) {
                listener.removed(this, thing);
            }
            for (ThingManagerListener listener : World.getInstance().getThingManagerListeners(this.getName())) {
                listener.removed(this, thing);
            }
        }
        return removed;
    }

    public abstract boolean doRemoveThing(Thing var1);

    @Override
    public boolean save(Thing thing) {
        boolean removed = this.doSaveThing(thing);
        if (thing != null) {
            for (ThingManagerListener listener : this.listeners) {
                listener.saved(this, thing);
            }
            for (ThingManagerListener listener : World.getInstance().getThingManagerListeners(this.getName())) {
                listener.saved(this, thing);
            }
        }
        return removed;
    }

    public abstract boolean doSaveThing(Thing var1);

    @Override
    public void setRootDir(File root) {
        this.rootDir = root;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

