/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xmeta.Category;
import org.xmeta.ThingCoder;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.thingManagers.CachedCategory;
import org.xmeta.thingManagers.JarThingManager;

public class JarCategory
extends CachedCategory {
    public JarCategory(ThingManager thingManager, Category parentPackage, String name) {
        super(thingManager, parentPackage, name);
    }

    @Override
    public String getFilePath() {
        return null;
    }

    @Override
    public void refresh() {
        JarThingManager jarThingManager = (JarThingManager)this.thingManager;
        if (jarThingManager.rootCategory == this) {
            try {
                World world = World.getInstance();
                Enumeration<JarEntry> enumeration = jarThingManager.jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String fileExt;
                    ThingCoder thingCoder;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory()) continue;
                    String jarEntryName = jarEntry.getName();
                    int index = jarEntryName.lastIndexOf("/");
                    String packageName = null;
                    String fileName = null;
                    if (index != -1) {
                        packageName = jarEntryName.substring(0, index);
                        packageName = packageName.replace('/', '.');
                        fileName = jarEntryName.substring(index + 1, jarEntryName.length());
                    } else {
                        fileName = jarEntryName;
                    }
                    index = fileName.indexOf(".");
                    if (index == -1 || (thingCoder = world.getThingCoder(fileExt = fileName.substring(index + 1, fileName.length()))) == null) continue;
                    String thingName = fileName.substring(0, index);
                    this.initThingIndex(jarThingManager.jarFile, jarEntry, thingCoder, packageName, thingName, fileExt);
                }
            }
            catch (IOException ioe) {
                throw new XMetaException("refresh jarThingManager error, jarFile=" + jarThingManager.jarFile, ioe);
            }
        }
    }

    private void initThingIndex(JarFile jFile, JarEntry jarEntry, ThingCoder thingCoder, String packageName, String thingName, String fileExt) throws IOException {
        Category category = this.initCategory(packageName);
        CachedCategory cat = (CachedCategory)category;
        for (ThingIndex index : cat.getThingIndexs()) {
            if (!index.getThingName().equals(thingName)) continue;
            return;
        }
        ThingIndex thingIndex = new ThingIndex();
        InputStream in = jFile.getInputStream(jarEntry);
        in.close();
        thingIndex.name = thingName;
        thingIndex.path = String.valueOf(packageName) + "." + thingName;
        thingIndex.thingManager = this.thingManager;
        thingIndex.lastModified = jarEntry.getTime();
        ((CachedCategory)category).addThingIndex(thingIndex);
    }

    private Category initCategory(String packageName) {
        JarThingManager jarThingManager = (JarThingManager)this.thingManager;
        Category category = null;
        if (packageName == null) {
            category = jarThingManager.rootCategory;
        } else {
            Category parentPackage = jarThingManager.rootCategory;
            String[] stringArray = packageName.split("[.]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pkName = stringArray[n2];
                category = parentPackage.getCategory(pkName);
                if (category == null) {
                    String name = parentPackage.getName();
                    name = name != null && !"".equals(name) ? String.valueOf(name) + "." + pkName : pkName;
                    category = new JarCategory(jarThingManager, parentPackage, name);
                    ((JarCategory)parentPackage).addCategory(category);
                }
                parentPackage = category;
                ++n2;
            }
        }
        return category;
    }

    @Override
    public void refresh(boolean includeChild) {
    }
}

