/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.Category;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.thingManagers.CachedCategory;
import org.xmeta.thingManagers.JdbcThingManager;
import org.xmeta.thingManagers.RedisThingManager;
import redis.clients.jedis.Jedis;

public class JdbcCategory
extends CachedCategory {
    private static Logger logger = LoggerFactory.getLogger(JdbcCategory.class);

    public JdbcCategory(String name, ThingManager thingManager, Category parent) {
        super(thingManager, parent, name);
        this.refresh();
    }

    @Override
    public String getFilePath() {
        return null;
    }

    public Connection getConnection() {
        return ((JdbcThingManager)this.thingManager).getConnection();
    }

    @Override
    public void refresh() {
        block34: {
            Connection con = this.getConnection();
            if (con == null) {
                return;
            }
            PreparedStatement pst = null;
            ResultSet rs = null;
            try {
                try {
                    boolean have;
                    pst = con.prepareStatement("select simpleName from tblCategorys where parent=?");
                    pst.setString(1, this.name == null ? "" : this.name);
                    rs = pst.executeQuery();
                    HashSet<String> categorys = new HashSet<String>();
                    while (rs.next()) {
                        categorys.add(rs.getString("simpleName"));
                    }
                    ArrayList<String> childNames = new ArrayList<String>();
                    for (String path : categorys) {
                        if (path.indexOf(".") != -1) continue;
                        childNames.add(path);
                        have = false;
                        for (Category category : this.childCategorys) {
                            if (!category.getSimpleName().equals(path)) continue;
                            have = true;
                            break;
                        }
                        if (have) continue;
                        String newCategoryPath = path;
                        if (this.name != null && !"".equals(this.name)) {
                            newCategoryPath = String.valueOf(this.name) + "." + path;
                        }
                        JdbcCategory category = new JdbcCategory(newCategoryPath, this.getThingManager(), this);
                        this.childCategorys.add(category);
                    }
                    int i = 0;
                    while (i < this.childCategorys.size()) {
                        Category category = (Category)this.childCategorys.get(i);
                        have = false;
                        for (String path : childNames) {
                            if (!path.equals(category.getSimpleName())) continue;
                            have = true;
                            break;
                        }
                        if (!have) {
                            this.childCategorys.remove(i);
                            --i;
                        }
                        ++i;
                    }
                    String thingPath = null;
                    thingPath = this.name == null || "".equals(this.name) ? "" : this.name;
                    rs.close();
                    pst.close();
                    pst = con.prepareStatement("select * from tblThings where category=?");
                    pst.setString(1, thingPath);
                    rs = pst.executeQuery();
                    while (rs.next()) {
                        String path = rs.getString("path");
                        int index = path.lastIndexOf(".");
                        if (index != -1) {
                            path = path.substring(index + 1, path.length());
                        }
                        if (path.indexOf(".") != -1) continue;
                        childNames.add(path);
                        boolean have2 = false;
                        for (ThingIndex thingIndex : this.thingIndexs) {
                            if (!thingIndex.getName().equals(path)) continue;
                            have2 = true;
                            break;
                        }
                        if (have2) continue;
                        ThingIndex childIndex = new ThingIndex();
                        childIndex.name = path;
                        childIndex.path = this.name != null && !"".equals(this.name) ? String.valueOf(this.name) + "." + path : path;
                        childIndex.thingManager = this.thingManager;
                        childIndex.lastModified = rs.getLong("lastModified");
                        childIndex.descriptors = rs.getString("descriptors");
                        childIndex.label = rs.getString("label");
                        this.thingIndexs.add(childIndex);
                    }
                    int i2 = 0;
                    while (i2 < this.thingIndexs.size()) {
                        ThingIndex thingIndex = (ThingIndex)this.thingIndexs.get(i2);
                        boolean have3 = false;
                        for (String path : childNames) {
                            if (!path.equals(thingIndex.getName())) continue;
                            have3 = true;
                            break;
                        }
                        if (!have3) {
                            this.thingIndexs.remove(i2);
                            --i2;
                        }
                        ++i2;
                    }
                }
                catch (Exception e) {
                    logger.error("Refresh category error", (Throwable)e);
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (con == null) break block34;
                    try {
                        con.close();
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (pst != null) {
                    try {
                        pst.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Jedis getJedis() {
        RedisThingManager th = (RedisThingManager)this.getThingManager();
        return th.getJedis();
    }

    public void releaseJedis(Jedis jedis) {
        RedisThingManager th = (RedisThingManager)this.getThingManager();
        th.releaseJedis(jedis);
    }

    @Override
    public void refresh(boolean includeChild) {
        this.refresh();
        if (includeChild) {
            for (Category child : this.childCategorys) {
                child.refresh(includeChild);
            }
        }
    }
}

